/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EditorManager {
    protected AuthoringTool authoringTool;
    protected List availableEditors = new ArrayList();
    protected List inUseEditors = new ArrayList();

    public EditorManager(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public Editor getEditorInstance(Class editorClass) {
        if (editorClass == null) {
            return null;
        }
        Iterator iter = this.availableEditors.listIterator();
        while (iter.hasNext()) {
            Object editor = iter.next();
            if (editor.getClass() != editorClass) continue;
            iter.remove();
            this.inUseEditors.add(editor);
            return (Editor)editor;
        }
        Editor editor = EditorUtilities.getEditorFromClass(editorClass);
        if (editor != null) {
            this.authoringTool.addAuthoringToolStateListener(editor);
            this.inUseEditors.add(editor);
            editor.setAuthoringTool(this.authoringTool);
        }
        return editor;
    }

    public void releaseEditorInstance(Editor editor) {
        if (this.inUseEditors.contains(editor)) {
            this.inUseEditors.remove(editor);
            if (!this.availableEditors.contains(editor)) {
                this.availableEditors.add(editor);
            }
        }
    }
}

