/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@Deprecated
public class EditorComponent
extends JPanel {
    protected AuthoringTool authoringTool;
    protected JPanel editorPanel = new JPanel();
    protected EditLabel editLabel = new EditLabel();
    protected AbstractAction backAction;
    protected AbstractAction forwardAction;
    protected AbstractAction editSceneAction;
    protected Editor activeEditor = null;
    protected Method activeEditorSetMethod = null;
    protected HashMap cachedEditors = new HashMap();
    protected EditStack editStack = new EditStack();
    protected final ChildrenListener deletionListener = new ChildrenListener(){

        public void childrenChanging(ChildrenEvent ev) {
        }

        public void childrenChanged(ChildrenEvent ev) {
            if (ev.getChangeType() == 3 && ev.getChild() == EditorComponent.this.getElementBeingEdited()) {
                EditorComponent.this.editElement(null);
                ev.getParent().removeChildrenListener(this);
            }
        }
    };

    public Editor loadEditor(Class editorClass) {
        Editor editor = null;
        if (editorClass != null && (editor = (Editor)this.cachedEditors.get(editorClass)) == null) {
            try {
                editor = EditorUtilities.getEditorFromClass(editorClass);
                if (editor == null) {
                    AuthoringTool.showErrorDialog("Can't create editor of type " + editorClass.getName(), null);
                } else {
                    this.cachedEditors.put(editorClass, editor);
                    this.authoringTool.addAuthoringToolStateListener(editor);
                    editor.setAuthoringTool(this.authoringTool);
                }
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error while creating editor of type " + editorClass.getName(), t);
            }
        }
        return editor;
    }

    public void editElement(Element element) {
        this.editElement(element, true);
    }

    protected void editElement(Element element, boolean performPush) {
        if (element == null) {
            this.editElement(null, null, performPush);
        } else {
            Class bestEditorClass = EditorUtilities.getBestEditor(element.getClass());
            if (bestEditorClass == null) {
                AuthoringTool.showErrorDialog("No editor found for " + element.getClass().getName(), null);
            }
            this.editElement(element, bestEditorClass, performPush);
        }
    }

    protected void editElement(Element element, Class editorClass, boolean performPush) {
        Editor editor;
        if (this.getElementBeingEdited() != null && this.getElementBeingEdited().getParent() != null) {
            this.getElementBeingEdited().getParent().removeChildrenListener(this.deletionListener);
        }
        if (this.activeEditor != (editor = this.loadEditor(editorClass))) {
            if (this.activeEditor != null) {
                try {
                    this.activeEditorSetMethod.invoke((Object)this.activeEditor, new Object[1]);
                }
                catch (InvocationTargetException ite) {
                    AuthoringTool.showErrorDialog("Error while cleaning editor.", ite);
                }
                catch (IllegalAccessException iae) {
                    AuthoringTool.showErrorDialog("Error while cleaning editor.", iae);
                }
            }
            this.editorPanel.removeAll();
            this.activeEditor = editor;
            if (this.activeEditor != null) {
                this.activeEditorSetMethod = EditorUtilities.getSetMethodFromClass(editorClass);
                this.editorPanel.add("Center", this.activeEditor.getJComponent());
            } else {
                this.activeEditorSetMethod = null;
            }
            this.editorPanel.revalidate();
            this.editorPanel.repaint();
        }
        if (this.activeEditor != null && this.activeEditor.getObject() != element) {
            try {
                this.activeEditorSetMethod.invoke((Object)this.activeEditor, element);
                if (performPush && element != null) {
                    this.editStack.push(new EditItem(element, editorClass));
                    this.updateActions();
                }
                if (element != null) {
                    this.editLabel.setText(AuthoringToolResources.getReprForValue(element));
                    if (element.getParent() != null) {
                        element.getParent().addChildrenListener(this.deletionListener);
                    }
                }
            }
            catch (InvocationTargetException ite) {
                AuthoringTool.showErrorDialog("Error while setting up editor.", ite);
            }
            catch (IllegalAccessException iae) {
                AuthoringTool.showErrorDialog("Error while setting up editor.", iae);
            }
        }
    }

    public Element getElementBeingEdited() {
        if (this.activeEditor != null) {
            return (Element)this.activeEditor.getObject();
        }
        return null;
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public boolean canGoBack() {
        return this.editStack.getCurrentUndoableRedoableIndex() > 0;
    }

    public boolean canGoForward() {
        return this.editStack.getCurrentUndoableRedoableIndex() != this.editStack.size() - 1;
    }

    protected void updateActions() {
        this.backAction.setEnabled(this.canGoBack());
        this.forwardAction.setEnabled(this.canGoForward());
        this.editSceneAction.setEnabled(this.getElementBeingEdited() != this.authoringTool.getWorld());
    }

    class EditStack
    extends DefaultUndoRedoStack {
        EditStack() {
        }

        public UndoableRedoable undo() {
            UndoableRedoable ur = super.undo();
            UndoableRedoable newItem = EditorComponent.this.editStack.getCurrentUndoableRedoable();
            if (ur != null) {
                EditorComponent.this.editElement(((EditItem)newItem).getElement(), ((EditItem)newItem).getEditorClass(), false);
            }
            return ur;
        }

        public UndoableRedoable redo() {
            UndoableRedoable ur = super.redo();
            if (ur != null) {
                EditorComponent.this.editElement(((EditItem)ur).getElement(), ((EditItem)ur).getEditorClass(), false);
            }
            return ur;
        }
    }

    class EditItem
    implements UndoableRedoable {
        protected Element element;
        protected Class editorClass;

        public EditItem(Element element, Class editorClass) {
            this.element = element;
            this.editorClass = editorClass;
        }

        public void undo() {
        }

        public void redo() {
        }

        public Object getAffectedObject() {
            return this.element;
        }

        public Object getContext() {
            return EditorComponent.this;
        }

        public Element getElement() {
            return this.element;
        }

        public Class getEditorClass() {
            return this.editorClass;
        }
    }

    public class EditLabel
    extends JLabel
    implements DropTargetListener {
        public EditLabel() {
            int fontSize = 12;
            this.setFont(new Font("SansSerif", 1, (int)(18.0 * ((double)fontSize / 12.0))));
            this.setForeground(Color.black);
            this.setText("drop here");
            this.setOpaque(false);
            this.setDropTarget(new DropTarget(this, this));
        }

        protected void checkDrag(DropTargetDragEvent dtde) {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.elementReferenceFlavor)) {
                dtde.acceptDrag(2);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ResponsePrototypeReferenceTransferable.responsePrototypeReferenceFlavor)) {
                dtde.acceptDrag(2);
            } else {
                dtde.rejectDrag();
            }
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        public void dragOver(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void drop(DropTargetDropEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            try {
                if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.elementReferenceFlavor)) {
                    dtde.acceptDrop(2);
                    Element element = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
                    EditorComponent.this.editElement(element);
                    dtde.dropComplete(true);
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                    dtde.acceptDrop(2);
                    CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype = (CallToUserDefinedResponsePrototype)transferable.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor);
                    EditorComponent.this.editElement(callToUserDefinedResponsePrototype.getActualResponse());
                    dtde.dropComplete(true);
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                    dtde.acceptDrop(2);
                    CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype = (CallToUserDefinedQuestionPrototype)transferable.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
                    EditorComponent.this.editElement(callToUserDefinedQuestionPrototype.getActualQuestion());
                    dtde.dropComplete(true);
                } else {
                    dtde.rejectDrop();
                    dtde.dropComplete(false);
                }
            }
            catch (UnsupportedFlavorException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
                dtde.dropComplete(false);
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
                dtde.dropComplete(false);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Drop didn't work.", t);
                dtde.dropComplete(false);
            }
        }
    }

    class HighlightButton
    extends JButton {
        protected Border highlightBorder = new HighlightBorder(true);
        protected Border pressedBorder = new HighlightBorder(false);
        protected Insets insets = new Insets(4, 4, 4, 4);

        public HighlightButton() {
            this.setHorizontalTextPosition(0);
            this.setVerticalTextPosition(3);
            this.setOpaque(false);
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.setRolloverEnabled(true);
            this.setBorder(null);
            this.getModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ev) {
                    HighlightButton.this.updateBorder();
                }
            });
        }

        public Insets getInsets() {
            return this.insets;
        }

        protected void updateBorder() {
            if (this.getModel().isEnabled()) {
                if (this.getModel().isPressed()) {
                    if (this.getModel().isArmed()) {
                        this.setBorder(this.pressedBorder);
                    } else {
                        this.setBorder(this.highlightBorder);
                    }
                } else if (this.getModel().isRollover()) {
                    this.setBorder(this.highlightBorder);
                } else {
                    this.setBorder(null);
                }
            } else {
                this.setBorder(null);
            }
        }

        class HighlightBorder
        extends AbstractBorder {
            protected Color highlightColor = Color.white;
            protected Color shadowColor = Color.gray;
            protected boolean raised;

            public HighlightBorder(boolean isRaised) {
                this.raised = isRaised;
            }

            public void setRaised(boolean isRaised) {
                this.raised = isRaised;
            }

            public boolean isRaised() {
                return this.raised;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Color oldColor = g.getColor();
                if (this.raised) {
                    g.setColor(this.highlightColor);
                    g.drawLine(x, y, x + width - 1, y);
                    g.drawLine(x, y, x, y + height - 1);
                    g.setColor(this.shadowColor);
                    g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
                    g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
                } else {
                    g.setColor(this.shadowColor);
                    g.drawLine(x, y, x + width - 2, y);
                    g.drawLine(x, y, x, y + height - 2);
                    g.setColor(this.highlightColor);
                    g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
                    g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
                }
                g.setColor(oldColor);
            }

            public Insets getBorderInsets(Component c) {
                return new Insets(1, 1, 1, 1);
            }

            public Insets getBorderInsets(Component c, Insets insets) {
                insets.bottom = 1;
                insets.right = 1;
                insets.top = 1;
                insets.left = 1;
                return insets;
            }

            public boolean isBorderOpaque() {
                return true;
            }
        }
    }
}

