/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.io.ZipFileTreeLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class ZipFileTreeStorer
implements DirectoryTreeStorer {
    private static final int ENDSIG = 101010256;
    private static final int HEADSIG = 33639248;
    private static final int LOCHEADSIG = 67324752;
    private static final int DATADESCSIG = 134695760;
    private static final int SIG = 1;
    private static final int MADEBY = 2;
    private static final int VERNEEDED = 3;
    private static final int BITFLAG = 4;
    private static final int COMPMETH = 5;
    private static final int MODTIME = 6;
    private static final int CRC32 = 8;
    private static final int COMPSIZE = 9;
    private static final int UNCOMPSIZE = 10;
    private static final int NAMELENGTH = 11;
    private static final int EXTRALENGTH = 12;
    private static final int COMLENGTH = 13;
    private static final int DISKSTART = 14;
    private static final int INTATTRIB = 15;
    private static final int EXTATTRIB = 16;
    private static final int OFFSET = 17;
    private static final int FILENAME = 18;
    private static final int EXTRAFIELD = 19;
    private static final int COMMENT = 20;
    private static final int compressionBitFlag = 0;
    private static final int compressionMethodValue = 8;
    private static final int BITFLAG_DEFAULT = 0;
    private byte[] endHeader;
    private Vector centralDirectory;
    private int centralDirectoryLocation;
    private String currentFile = null;
    private File rootFile;
    private CRC32 crc = new CRC32();
    private Vector holes;
    private Vector toWrite = new Vector();
    private ByteArrayOutputStream m_currentlyOpenStream = null;
    private boolean outputStreamOpen = false;
    private RandomAccessFile m_randomAccessFile = null;
    private HashMap filenameToHeaderMap;
    private boolean newZip = false;
    private boolean allOpen = false;
    private boolean shouldCompressCurrent = true;
    private int lastEntry = -1;
    private int timeStamp = -1;
    private String currentDirectory;
    private HoleComparator holeComparator = new HoleComparator();
    private HeaderSizeComparator headerSizeComparator = new HeaderSizeComparator();
    private HeaderLocationComparator headerLocationComparator = new HeaderLocationComparator();

    private static long getCurrentDosTime() {
        Calendar d = Calendar.getInstance();
        int year = d.get(1);
        if (year < 1980) {
            return 0x210000L;
        }
        return year - 1980 << 25 | d.get(2) + 1 << 21 | d.get(5) << 16 | d.get(11) << 11 | d.get(12) << 5 | d.get(13) >> 1;
    }

    private void writeInt(int pos, int value, int size) throws IOException {
        int mask = 255;
        this.m_randomAccessFile.seek(pos);
        int i = 0;
        while (i < size) {
            this.m_randomAccessFile.writeByte(mask & value);
            value >>= 8;
            ++i;
        }
    }

    private void writeString(int pos, String toWrite) throws IOException {
        this.m_randomAccessFile.seek(pos);
        this.m_randomAccessFile.write(toWrite.getBytes());
    }

    public void setCurrentDirectory(String pathname) throws IllegalArgumentException {
        if (pathname == null) {
            pathname = "";
        } else if (pathname.length() > 0) {
            int index;
            pathname = pathname.replace('\\', '/');
            while ((index = pathname.indexOf("//")) != -1) {
                pathname = String.valueOf(pathname.substring(0, index + 1)) + pathname.substring(index + 2);
            }
            if (!(pathname = pathname.charAt(0) == '/' ? pathname.substring(1) : String.valueOf(this.currentDirectory) + pathname).endsWith("/")) {
                pathname = String.valueOf(pathname) + "/";
            }
            if (!pathname.startsWith("/")) {
                pathname = "/" + pathname;
            }
        }
        this.currentDirectory = pathname;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    protected boolean isCompressed() {
        return true;
    }

    public void openForUpdate(Object pathname) throws IllegalArgumentException, IOException {
        this.open(pathname);
        int i = 0;
        while (i < this.centralDirectory.size()) {
            ((CentralDirectoryHeader)this.centralDirectory.get((int)i)).shouldDelete = false;
            ++i;
        }
    }

    public void open(Object pathname) throws IllegalArgumentException, IOException {
        if (this.allOpen) {
            this.close();
        }
        if (pathname instanceof String) {
            this.m_randomAccessFile = new RandomAccessFile((String)pathname, "rw");
            this.rootFile = new File((String)pathname);
        } else if (pathname instanceof File) {
            this.m_randomAccessFile = new RandomAccessFile((File)pathname, "rw");
            this.rootFile = (File)pathname;
        } else {
            if (pathname instanceof OutputStream) {
                throw new IllegalArgumentException("pathname must be an instance of String or java.io.File");
            }
            if (pathname == null) {
                throw new IllegalArgumentException("pathname is null");
            }
            throw new IllegalArgumentException("pathname must be an instance of String or java.io.File");
        }
        if (this.m_randomAccessFile.length() <= 0L) {
            this.newZip = true;
        }
        this.currentDirectory = "";
        this.m_currentlyOpenStream = null;
        if (!this.newZip) {
            try {
                this.setAtEndSig();
            }
            catch (IOException e) {
                this.newZip = true;
            }
        }
        this.timeStamp = (int)ZipFileTreeStorer.getCurrentDosTime();
        this.initCentralDirectory();
        this.setEnd();
        this.allOpen = true;
    }

    private void findHoles() {
        this.lastEntry = -1;
        if (this.centralDirectory != null) {
            this.holes = new Vector();
            int i = 0;
            while (i < this.centralDirectory.size() - 1) {
                CentralDirectoryHeader current = (CentralDirectoryHeader)this.centralDirectory.get(i);
                CentralDirectoryHeader next = (CentralDirectoryHeader)this.centralDirectory.get(i + 1);
                int currentSize = 30 + current.fileNameLength + current.extraFieldLength + current.compressedSize;
                int currentEnd = current.relativeOffset + currentSize;
                if (currentEnd < next.relativeOffset) {
                    LocalizedVacuity hole = new LocalizedVacuity(currentEnd, next.relativeOffset - currentEnd);
                    this.holes.add(hole);
                }
                ++i;
            }
            if (this.centralDirectory.size() == 0) {
                this.lastEntry = 0;
            } else {
                int currentEnd;
                CentralDirectoryHeader last = (CentralDirectoryHeader)this.centralDirectory.get(this.centralDirectory.size() - 1);
                int lastSize = 30 + last.fileNameLength + last.extraFieldLength + last.compressedSize;
                this.lastEntry = currentEnd = last.relativeOffset + lastSize;
                Collections.sort(this.holes, this.holeComparator);
            }
        }
    }

    private void fillHoles() {
        this.findHoles();
        int i = 0;
        while (i < this.holes.size()) {
            LocalizedVacuity currentHole = (LocalizedVacuity)this.holes.get(i);
            byte[] bufOfZeroes = new byte[currentHole.size];
            try {
                this.writeValue(bufOfZeroes, 0, currentHole.size, currentHole.pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private void setEnd() {
        this.lastEntry = 0;
        if (this.centralDirectory != null && this.centralDirectory.size() > 0) {
            int currentEnd;
            CentralDirectoryHeader last = (CentralDirectoryHeader)this.centralDirectory.get(this.centralDirectory.size() - 1);
            int lastSize = last.getLocalHeaderSpace();
            this.lastEntry = currentEnd = last.relativeOffset + lastSize;
        }
    }

    private void updateHeader(CentralDirectoryHeader header, byte[] data, boolean writeImmediately) throws IOException {
        int newSize = 0;
        int oldSize = header.compressedSize;
        int inflatedSize = 0;
        if (data != null) {
            inflatedSize = data.length;
            this.crc.reset();
            this.crc.update(data);
            if (header.shouldCompress) {
                data = this.compressData(data);
            }
            newSize = data.length;
        }
        header.crc32 = (int)this.crc.getValue();
        header.compressedSize = newSize;
        header.uncompressedSize = inflatedSize;
        if (header.localHeaderReference != null) {
            header.localHeaderReference.crc32 = (int)this.crc.getValue();
            header.localHeaderReference.compressedSize = newSize;
            header.localHeaderReference.uncompressedSize = inflatedSize;
        }
        if (newSize > oldSize && !writeImmediately) {
            header.setShouldDelete(true);
            header.data = data;
            this.toWrite.add(header);
            this.centralDirectory.remove(header);
        } else {
            header.data = null;
            if (writeImmediately) {
                header.localHeaderReference.writeAll();
            } else {
                header.localHeaderReference.writeData(8);
                header.localHeaderReference.writeData(9);
                header.localHeaderReference.writeData(10);
                header.localHeaderReference.writeData(6);
            }
            this.writeValue(data, 0, newSize, header.relativeOffset + header.localHeaderReference.getThisHeaderSpace());
            if (header.localHeaderReference.needsDataDescriptor() && header.localHeaderReference.hasDataDescriptor) {
                header.localHeaderReference.writeDataDescriptor();
            }
        }
    }

    private byte[] compressData(byte[] data) {
        int justCompressed;
        Deflater deflater = new Deflater(-1, true);
        deflater.setInput(data);
        int totalCompressed = 0;
        ByteArrayOutputStream compressedData = new ByteArrayOutputStream();
        byte[] buf = new byte[512];
        while (!deflater.needsInput()) {
            justCompressed = deflater.deflate(buf, 0, buf.length);
            if (justCompressed > 0) {
                compressedData.write(buf, 0, justCompressed);
            }
            totalCompressed += justCompressed;
        }
        deflater.finish();
        while (!deflater.finished()) {
            justCompressed = deflater.deflate(buf, 0, buf.length);
            if (justCompressed > 0) {
                compressedData.write(buf, 0, justCompressed);
            }
            totalCompressed += justCompressed;
        }
        return compressedData.toByteArray();
    }

    private int getUnsigned(byte toConvert) {
        if (toConvert < 0) {
            return toConvert + 256;
        }
        return toConvert;
    }

    private long getValue(byte[] buf, int offset, int size) {
        long toReturn = 0L;
        int i = size - 1;
        while (i >= 0) {
            int toAdd = this.getUnsigned(buf[offset + i]);
            toReturn += (long)toAdd;
            if (i != 0) {
                toReturn <<= 8;
            }
            --i;
        }
        return toReturn;
    }

    private void writeValue(byte[] buf, int offset, int size, int pos) throws IOException {
        if (buf != null) {
            try {
                this.m_randomAccessFile.seek(pos);
                this.m_randomAccessFile.write(buf, offset, size);
            }
            catch (Exception e) {
                throw new IOException("An error occurred while writing to the zip file. The file may not have been saved properly.");
            }
        }
    }

    private String getString(byte[] buf, int offset, int size) {
        StringBuffer sb = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            sb.append((char)this.getUnsigned(buf[offset + i]));
            ++i;
        }
        return sb.toString();
    }

    private void initCentralDirectory() throws IOException {
        this.centralDirectory = new Vector();
        this.filenameToHeaderMap = new HashMap();
        if (this.newZip) {
            return;
        }
        int size = (int)this.getValue(this.endHeader, 12, 4);
        long offset = this.getValue(this.endHeader, 16, 4);
        int currentHeaderOffset = 0;
        this.centralDirectoryLocation = (int)offset;
        byte[] centralArray = new byte[size];
        try {
            this.m_randomAccessFile.seek(offset);
            this.m_randomAccessFile.readFully(centralArray, 0, size);
        }
        catch (IOException e) {
            this.newZip = true;
            return;
        }
        currentHeaderOffset = 0;
        int currentSize = 46;
        while (currentHeaderOffset < centralArray.length) {
            if (currentHeaderOffset + 46 >= centralArray.length) {
                currentHeaderOffset = centralArray.length;
                break;
            }
            CentralDirectoryHeader header = null;
            try {
                header = new CentralDirectoryHeader(currentHeaderOffset, this.centralDirectoryLocation, centralArray);
            }
            catch (IllegalArgumentException e) {
                this.centralDirectory = new Vector();
                this.filenameToHeaderMap = new HashMap();
                this.newZip = true;
                return;
            }
            currentHeaderOffset += header.size;
            header.setShouldDelete(true);
            this.centralDirectory.add(header);
            this.filenameToHeaderMap.put(header.fileName, header);
            try {
                header.localHeaderReference = this.initLocalHeader(header);
            }
            catch (IOException e) {
                this.centralDirectory = new Vector();
                this.filenameToHeaderMap = new HashMap();
                this.newZip = true;
                return;
            }
            if (currentHeaderOffset + 46 >= centralArray.length) {
                currentHeaderOffset = centralArray.length;
                break;
            }
            if (this.getValue(centralArray, currentHeaderOffset, 4) == 33639248L) continue;
            currentHeaderOffset -= currentSize + 1;
            while (currentHeaderOffset + 3 < centralArray.length && this.getValue(centralArray, currentHeaderOffset, 4) != 33639248L) {
                ++currentHeaderOffset;
            }
        }
        Collections.sort(this.centralDirectory, this.headerLocationComparator);
    }

    private LocalHeader initLocalHeader(CentralDirectoryHeader headerReference) throws IOException {
        int pos = headerReference.relativeOffset;
        int headerSize = headerReference.fileNameLength + headerReference.extraFieldLength + 30;
        byte[] currentLocalHeaderBytes = new byte[headerSize];
        LocalHeader headerToReturn = null;
        this.m_randomAccessFile.seek(pos);
        this.m_randomAccessFile.readFully(currentLocalHeaderBytes, 0, headerSize);
        headerToReturn = new LocalHeader(pos, headerReference, currentLocalHeaderBytes);
        this.m_randomAccessFile.seek(headerToReturn.getThisHeaderSpace() + headerToReturn.compressedSize);
        byte[] dataDescriptor = new byte[4];
        this.m_randomAccessFile.readFully(dataDescriptor, 0, 4);
        if (this.getValue(dataDescriptor, 0, 4) == 134695760L) {
            headerToReturn.hasDataDescriptor = true;
        }
        return headerToReturn;
    }

    private void setAtEndSig() throws IOException {
        long pos;
        long len = pos = this.m_randomAccessFile.length();
        int endHeaderLength = 22;
        int maxSize = 65535;
        byte[] buf = new byte[endHeaderLength * 2];
        Arrays.fill(buf, (byte)0);
        while (len - pos < (long)maxSize) {
            int i = 0;
            while (i < endHeaderLength) {
                buf[i + endHeaderLength] = buf[i];
                ++i;
            }
            this.m_randomAccessFile.seek(pos -= (long)endHeaderLength);
            this.m_randomAccessFile.readFully(buf, 0, endHeaderLength);
            i = 0;
            while (i < endHeaderLength * 2 - 3) {
                int commentLength;
                long endpos;
                if (this.getValue(buf, i, 4) == 101010256L && (endpos = pos + (long)i) + (long)(commentLength = (int)this.getValue(buf, i + 20, 2)) + (long)endHeaderLength == len) {
                    this.endHeader = new byte[commentLength + endHeaderLength];
                    this.m_randomAccessFile.seek(endpos);
                    this.m_randomAccessFile.readFully(this.endHeader, i, commentLength + endHeaderLength);
                    return;
                }
                ++i;
            }
        }
        throw new IOException("End header not found");
    }

    private CentralDirectoryHeader getHeader(String filename) {
        if (this.newZip) {
            return null;
        }
        return (CentralDirectoryHeader)this.filenameToHeaderMap.get(filename);
    }

    private void writeHeader(CentralDirectoryHeader header, int pos) throws IOException {
        header.relativeOffset = pos;
        header.localHeaderReference.position = pos;
        if (header.data != null) {
            this.crc.reset();
            this.crc.update(header.data);
        }
        header.localHeaderReference.writeAll();
        if (header.data != null) {
            this.writeValue(header.data, 0, header.data.length, header.localHeaderReference.position + header.localHeaderReference.getThisHeaderSpace());
        }
        if (header.localHeaderReference.needsDataDescriptor()) {
            header.localHeaderReference.writeDataDescriptor();
        }
    }

    private boolean placeHeader(CentralDirectoryHeader header) throws IOException {
        int i = 0;
        while (i < this.holes.size()) {
            LocalizedVacuity currentHole = (LocalizedVacuity)this.holes.get(i);
            if (currentHole.size >= header.getLocalHeaderSpace()) {
                this.writeHeader(header, currentHole.pos);
                this.holes.remove(currentHole);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void placeHeaders() throws IOException {
        Collections.sort(this.toWrite, this.headerSizeComparator);
        this.findHoles();
        boolean stillPlacing = true;
        int i = 0;
        while (i < this.toWrite.size()) {
            CentralDirectoryHeader currentHeader = (CentralDirectoryHeader)this.toWrite.get(i);
            if (stillPlacing) {
                stillPlacing = this.placeHeader(currentHeader);
            }
            if (!stillPlacing) {
                int amountWritten = currentHeader.getLocalHeaderSpace();
                this.writeHeader(currentHeader, this.lastEntry);
                this.lastEntry += amountWritten;
            }
            if (!this.centralDirectory.contains(currentHeader)) {
                this.centralDirectory.add(currentHeader);
            }
            ++i;
        }
        if (this.toWrite.size() > 0) {
            Collections.sort(this.centralDirectory, this.headerLocationComparator);
        }
    }

    private void writeCentralDirectoryAndEndHeader() throws IOException {
        int startLocation;
        this.newZip = false;
        this.setEnd();
        int pos = startLocation = this.lastEntry;
        int size = 0;
        int totalEntries = this.centralDirectory.size();
        int i = 0;
        while (i < totalEntries) {
            CentralDirectoryHeader currentHeader = (CentralDirectoryHeader)this.centralDirectory.get(i);
            currentHeader.position = pos;
            currentHeader.writeAll();
            pos += currentHeader.getThisHeaderSpace();
            size += currentHeader.getThisHeaderSpace();
            ++i;
        }
        this.writeInt(pos, 101010256, 4);
        this.writeInt(pos + 4, 0, 2);
        this.writeInt(pos + 6, 0, 2);
        this.writeInt(pos + 8, totalEntries, 2);
        this.writeInt(pos + 10, totalEntries, 2);
        this.writeInt(pos + 12, size, 4);
        this.writeInt(pos + 16, startLocation, 4);
        this.writeInt(pos + 20, 0, 2);
        this.m_randomAccessFile.setLength(pos + 22);
    }

    private void deleteDirectories() {
        Iterator i = this.centralDirectory.iterator();
        while (i.hasNext()) {
            CentralDirectoryHeader currentHeader = (CentralDirectoryHeader)i.next();
            if (!currentHeader.shouldDelete) continue;
            i.remove();
        }
    }

    public void close() throws IOException {
        if (this.outputStreamOpen) {
            this.closeCurrentFile();
        }
        this.deleteDirectories();
        this.placeHeaders();
        this.writeCentralDirectoryAndEndHeader();
        this.fillHoles();
        this.allOpen = false;
        this.m_randomAccessFile.close();
        this.endHeader = null;
        this.centralDirectory = null;
    }

    public OutputStream createFile(String filename) throws IllegalArgumentException, IOException {
        return this.createFile(filename, true);
    }

    public OutputStream createFile(String filename, boolean compressItIfYouGotIt) throws IllegalArgumentException, IOException {
        this.shouldCompressCurrent = compressItIfYouGotIt;
        if (this.m_randomAccessFile != null) {
            if (this.outputStreamOpen) {
                this.closeCurrentFile();
            }
        } else {
            throw new IOException("No zip file currently open");
        }
        this.m_currentlyOpenStream = new ByteArrayOutputStream();
        this.currentFile = filename;
        this.outputStreamOpen = true;
        return this.m_currentlyOpenStream;
    }

    public void keepFile(String filename) throws KeepFileNotSupportedException {
        if (this.newZip) {
            throw new KeepFileNotSupportedException();
        }
        String fullName = String.valueOf(this.currentDirectory) + filename;
        CentralDirectoryHeader toKeep = this.getHeader(fullName);
        if (toKeep == null) {
            throw new RuntimeException("Could not keep file \"" + fullName + "\"");
        }
        toKeep.setShouldDelete(false);
    }

    public boolean isKeepFileSupported() {
        return !this.newZip;
    }

    public void createDirectory(String pathname) throws IllegalArgumentException, IOException {
        if (pathname.indexOf(47) != -1 || pathname.indexOf(92) != -1) {
            throw new IllegalArgumentException("pathname cannot contain path separators");
        }
        if (pathname.length() <= 0) {
            throw new IllegalArgumentException("pathname has no length");
        }
    }

    public void checkAndUpdateHeader(String filename, byte[] data) throws IOException {
        CentralDirectoryHeader header = this.getHeader(filename);
        if (header != null) {
            header.setShouldDelete(false);
            if (data != null) {
                header.lastModTime = this.timeStamp;
                header.localHeaderReference.lastModTime = this.timeStamp;
                this.updateHeader(header, data, false);
            }
        } else {
            header = new CentralDirectoryHeader();
            header.localHeaderReference = new LocalHeader();
            header.setCompression(this.shouldCompressCurrent);
            header.lastModTime = this.timeStamp;
            header.localHeaderReference.lastModTime = this.timeStamp;
            header.setFileName(filename);
            if (this.newZip) {
                header.position = this.lastEntry;
                header.relativeOffset = this.lastEntry;
                header.localHeaderReference.position = this.lastEntry;
                this.updateHeader(header, data, true);
                this.centralDirectory.add(header);
                this.lastEntry += header.getLocalHeaderSpace();
            } else {
                this.updateHeader(header, data, false);
            }
        }
    }

    public void closeCurrentFile() throws IOException {
        String filename = String.valueOf(this.currentDirectory) + this.currentFile;
        this.outputStreamOpen = false;
        this.checkAndUpdateHeader(filename, this.m_currentlyOpenStream.toByteArray());
        this.m_currentlyOpenStream.close();
    }

    private boolean doesFileExist(String filename) {
        int i = 0;
        while (i < this.centralDirectory.size()) {
            CentralDirectoryHeader cdh = (CentralDirectoryHeader)this.centralDirectory.get(i);
            if (cdh.fileName.equals(String.valueOf(this.currentDirectory) + filename)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getKeepKey(String filename) {
        if (this.newZip || !this.doesFileExist(filename)) {
            return null;
        }
        return ZipFileTreeLoader.getKeepKey(this.rootFile, this.currentDirectory, filename);
    }

    public void inspectZipFile() {
        this.findHoles();
    }

    private class CentralDirectoryHeader {
        public int position;
        public int size;
        boolean shouldDelete = false;
        public LocalHeader localHeaderReference;
        public boolean shouldCompress = true;
        public byte[] data = null;
        public int sig = 33639248;
        public int versionMadeBy = 20;
        public int versionNeededToExtract = 20;
        public int bitFlag = 0;
        public int compressionMethod = 8;
        public int lastModTime = 0;
        public int crc32 = 0;
        public int compressedSize = -1;
        public int uncompressedSize = -1;
        public int fileNameLength = 0;
        public int extraFieldLength = 0;
        public int fileCommentLength = 0;
        public int diskNumberStart = 0;
        public int internalFileAttributes = 0;
        public int externalFileAttributes = 0;
        public int relativeOffset = 0;
        public String fileName = "";
        public String extraField = "";
        public String comment = "";

        public CentralDirectoryHeader() {
        }

        public CentralDirectoryHeader(int offset, int pos, byte[] buf) throws IllegalArgumentException {
            this.position = pos + offset;
            if (buf != null && buf.length > 42 + offset) {
                this.sig = (int)ZipFileTreeStorer.this.getValue(buf, offset, 4);
                if (this.sig != 33639248) {
                    throw new IllegalArgumentException();
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.versionMadeBy = (int)ZipFileTreeStorer.this.getValue(buf, offset + 4, 2);
            this.versionNeededToExtract = (int)ZipFileTreeStorer.this.getValue(buf, offset + 6, 2);
            this.bitFlag = (int)ZipFileTreeStorer.this.getValue(buf, offset + 8, 2);
            this.compressionMethod = (int)ZipFileTreeStorer.this.getValue(buf, offset + 10, 2);
            this.lastModTime = (int)ZipFileTreeStorer.this.getValue(buf, offset + 12, 4);
            this.crc32 = (int)ZipFileTreeStorer.this.getValue(buf, offset + 16, 4);
            this.compressedSize = (int)ZipFileTreeStorer.this.getValue(buf, offset + 20, 4);
            this.uncompressedSize = (int)ZipFileTreeStorer.this.getValue(buf, offset + 24, 4);
            this.fileNameLength = (int)ZipFileTreeStorer.this.getValue(buf, offset + 28, 2);
            this.extraFieldLength = (int)ZipFileTreeStorer.this.getValue(buf, offset + 30, 2);
            this.fileCommentLength = (int)ZipFileTreeStorer.this.getValue(buf, offset + 32, 2);
            this.diskNumberStart = (int)ZipFileTreeStorer.this.getValue(buf, offset + 34, 2);
            this.internalFileAttributes = (int)ZipFileTreeStorer.this.getValue(buf, offset + 36, 2);
            this.externalFileAttributes = (int)ZipFileTreeStorer.this.getValue(buf, offset + 38, 4);
            this.relativeOffset = (int)ZipFileTreeStorer.this.getValue(buf, offset + 42, 4);
            this.fileName = ZipFileTreeStorer.this.getString(buf, offset + 46, this.fileNameLength);
            this.extraField = ZipFileTreeStorer.this.getString(buf, offset + 46 + this.fileNameLength, this.extraFieldLength);
            this.comment = ZipFileTreeStorer.this.getString(buf, offset + 46 + this.fileNameLength + this.extraFieldLength, this.fileCommentLength);
            this.size = this.fileNameLength + this.extraFieldLength + this.fileCommentLength + 46;
            this.shouldCompress = this.compressionMethod != 0;
        }

        public void setCompression(boolean compressBool) {
            this.shouldCompress = compressBool;
            if (this.shouldCompress) {
                this.bitFlag = 0;
                this.compressionMethod = 8;
                if (this.localHeaderReference != null) {
                    this.localHeaderReference.bitFlag = this.bitFlag;
                    this.localHeaderReference.compressionMethod = this.compressionMethod;
                }
            } else {
                this.bitFlag = 0;
                this.compressionMethod = 0;
                if (this.localHeaderReference != null) {
                    this.localHeaderReference.bitFlag = 0;
                    this.localHeaderReference.compressionMethod = 0;
                }
            }
        }

        public int getLocalHeaderSpace() {
            if ((this.bitFlag & 8) > 0 && this.localHeaderReference != null && this.localHeaderReference.hasDataDescriptor) {
                return 30 + this.fileNameLength + this.extraFieldLength + this.compressedSize + 16;
            }
            return 30 + this.fileNameLength + this.extraFieldLength + this.compressedSize;
        }

        public int getThisHeaderSpace() {
            return 46 + this.fileNameLength + this.extraFieldLength + this.fileCommentLength;
        }

        public void writeData(int toWrite) throws IOException {
            switch (toWrite) {
                case 1: {
                    ZipFileTreeStorer.this.writeInt(this.position + 0, this.sig, 4);
                    break;
                }
                case 2: {
                    ZipFileTreeStorer.this.writeInt(this.position + 4, this.versionMadeBy, 2);
                    break;
                }
                case 3: {
                    ZipFileTreeStorer.this.writeInt(this.position + 6, this.versionNeededToExtract, 2);
                    break;
                }
                case 4: {
                    ZipFileTreeStorer.this.writeInt(this.position + 8, this.bitFlag, 2);
                    break;
                }
                case 5: {
                    ZipFileTreeStorer.this.writeInt(this.position + 10, this.compressionMethod, 2);
                    break;
                }
                case 6: {
                    ZipFileTreeStorer.this.writeInt(this.position + 12, this.lastModTime, 4);
                    break;
                }
                case 8: {
                    ZipFileTreeStorer.this.writeInt(this.position + 16, this.crc32, 4);
                    break;
                }
                case 9: {
                    ZipFileTreeStorer.this.writeInt(this.position + 20, this.compressedSize, 4);
                    break;
                }
                case 10: {
                    ZipFileTreeStorer.this.writeInt(this.position + 24, this.uncompressedSize, 4);
                    break;
                }
                case 11: {
                    ZipFileTreeStorer.this.writeInt(this.position + 28, this.fileNameLength, 2);
                    break;
                }
                case 12: {
                    ZipFileTreeStorer.this.writeInt(this.position + 30, this.extraFieldLength, 2);
                    break;
                }
                case 13: {
                    ZipFileTreeStorer.this.writeInt(this.position + 32, this.fileCommentLength, 2);
                    break;
                }
                case 14: {
                    ZipFileTreeStorer.this.writeInt(this.position + 34, this.diskNumberStart, 2);
                    break;
                }
                case 15: {
                    ZipFileTreeStorer.this.writeInt(this.position + 36, this.internalFileAttributes, 2);
                    break;
                }
                case 16: {
                    ZipFileTreeStorer.this.writeInt(this.position + 38, this.externalFileAttributes, 4);
                    break;
                }
                case 17: {
                    ZipFileTreeStorer.this.writeInt(this.position + 42, this.relativeOffset, 4);
                    break;
                }
                case 18: {
                    ZipFileTreeStorer.this.writeString(this.position + 46, this.fileName);
                    break;
                }
                case 19: {
                    ZipFileTreeStorer.this.writeString(this.position + 46 + this.fileName.length(), this.extraField);
                    break;
                }
                case 20: {
                    ZipFileTreeStorer.this.writeString(this.position + 46 + this.fileName.length() + this.extraField.length(), this.comment);
                    break;
                }
            }
        }

        public void writeAll() throws IOException {
            int i = 1;
            while (i <= 20) {
                this.writeData(i);
                ++i;
            }
        }

        public void setShouldDelete(boolean toSetTo) {
            this.shouldDelete = toSetTo;
        }

        public void setFileName(String name) {
            this.fileName = new String(name);
            this.fileNameLength = this.fileName.length();
            if (this.localHeaderReference != null) {
                this.localHeaderReference.fileName = new String(this.fileName);
                this.localHeaderReference.fileNameLength = this.fileName.length();
            }
        }

        public String toString() {
            String toReturn = "";
            toReturn = String.valueOf(toReturn) + "position in file: " + String.valueOf(this.position) + "\n";
            toReturn = String.valueOf(toReturn) + "size: " + String.valueOf(this.size) + "\n";
            toReturn = String.valueOf(toReturn) + "sig: " + String.valueOf(this.sig) + "\n";
            toReturn = String.valueOf(toReturn) + "version made: " + String.valueOf(this.versionMadeBy) + "\n";
            toReturn = String.valueOf(toReturn) + "version needed: " + String.valueOf(this.versionNeededToExtract) + "\n";
            toReturn = String.valueOf(toReturn) + "bit flag: " + String.valueOf(this.bitFlag) + "\n";
            toReturn = String.valueOf(toReturn) + "compression method: " + String.valueOf(this.compressionMethod) + "\n";
            toReturn = String.valueOf(toReturn) + "las mod time: " + String.valueOf(this.lastModTime) + "\n";
            toReturn = String.valueOf(toReturn) + " crc-32: " + String.valueOf(this.crc32) + "\n";
            toReturn = String.valueOf(toReturn) + "compressed size: " + String.valueOf(this.compressedSize) + "\n";
            toReturn = String.valueOf(toReturn) + "uncompressed size: " + String.valueOf(this.uncompressedSize) + "\n";
            toReturn = String.valueOf(toReturn) + "file name length: " + String.valueOf(this.fileNameLength) + "\n";
            toReturn = String.valueOf(toReturn) + "extra field length: " + String.valueOf(this.extraFieldLength) + "\n";
            toReturn = String.valueOf(toReturn) + "comment length: " + String.valueOf(this.fileCommentLength) + "\n";
            toReturn = String.valueOf(toReturn) + "disk number start: " + String.valueOf(this.diskNumberStart) + "\n";
            toReturn = String.valueOf(toReturn) + "internal attrib: " + String.valueOf(this.internalFileAttributes) + "\n";
            toReturn = String.valueOf(toReturn) + "external attrib: " + String.valueOf(this.externalFileAttributes) + "\n";
            toReturn = String.valueOf(toReturn) + "relative offset for local header: " + String.valueOf(this.relativeOffset) + "\n";
            toReturn = String.valueOf(toReturn) + "file name: " + this.fileName + ", spans from " + String.valueOf(this.position) + " to " + String.valueOf(this.position + this.getThisHeaderSpace()) + "\n";
            toReturn = String.valueOf(toReturn) + "extra field: " + this.extraField + "\n";
            toReturn = String.valueOf(toReturn) + "comment: " + this.comment;
            return toReturn;
        }
    }

    private class LocalHeader {
        public int position;
        public int size;
        public int sig = 67324752;
        public int versionNeededToExtract = 20;
        public int bitFlag = 0;
        public int compressionMethod = 8;
        public int lastModTime = 0;
        public int crc32 = 0;
        public int compressedSize = -1;
        public int uncompressedSize = -1;
        public int fileNameLength = 0;
        public int extraFieldLength = 0;
        public String fileName = "";
        public String extraField = "";
        public boolean hasDataDescriptor = false;

        public LocalHeader() {
        }

        public LocalHeader(int pos, CentralDirectoryHeader cd, byte[] buf) throws IllegalArgumentException {
            this.position = pos;
            if (buf != null && buf.length > 30) {
                this.sig = (int)ZipFileTreeStorer.this.getValue(buf, 0, 4);
                if (this.sig != 67324752) {
                    throw new IllegalArgumentException();
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.versionNeededToExtract = (int)ZipFileTreeStorer.this.getValue(buf, 4, 2);
            this.bitFlag = (int)ZipFileTreeStorer.this.getValue(buf, 6, 2);
            this.compressionMethod = (int)ZipFileTreeStorer.this.getValue(buf, 8, 2);
            this.lastModTime = (int)ZipFileTreeStorer.this.getValue(buf, 10, 4);
            this.crc32 = (int)ZipFileTreeStorer.this.getValue(buf, 14, 4);
            this.compressedSize = (int)ZipFileTreeStorer.this.getValue(buf, 18, 4);
            this.uncompressedSize = (int)ZipFileTreeStorer.this.getValue(buf, 22, 4);
            this.fileNameLength = (int)ZipFileTreeStorer.this.getValue(buf, 26, 2);
            this.extraFieldLength = (int)ZipFileTreeStorer.this.getValue(buf, 28, 2);
            this.fileName = ZipFileTreeStorer.this.getString(buf, 30, this.fileNameLength);
            this.extraField = ZipFileTreeStorer.this.getString(buf, 30 + this.fileNameLength, this.extraFieldLength);
            this.size = this.fileNameLength + this.extraFieldLength + 30;
            this.hasDataDescriptor = false;
        }

        public int getThisHeaderSpace() {
            return 30 + this.fileNameLength + this.extraFieldLength;
        }

        public boolean needsDataDescriptor() {
            return (this.bitFlag & 8) > 0;
        }

        public void writeData(int toWrite) throws IOException {
            switch (toWrite) {
                case 1: {
                    ZipFileTreeStorer.this.writeInt(this.position + 0, this.sig, 4);
                    break;
                }
                case 3: {
                    ZipFileTreeStorer.this.writeInt(this.position + 4, this.versionNeededToExtract, 2);
                    break;
                }
                case 4: {
                    ZipFileTreeStorer.this.writeInt(this.position + 6, this.bitFlag, 2);
                    break;
                }
                case 5: {
                    ZipFileTreeStorer.this.writeInt(this.position + 8, this.compressionMethod, 2);
                    break;
                }
                case 6: {
                    ZipFileTreeStorer.this.writeInt(this.position + 10, this.lastModTime, 4);
                    break;
                }
                case 8: {
                    ZipFileTreeStorer.this.writeInt(this.position + 14, this.crc32, 4);
                    break;
                }
                case 9: {
                    ZipFileTreeStorer.this.writeInt(this.position + 18, this.compressedSize, 4);
                    break;
                }
                case 10: {
                    ZipFileTreeStorer.this.writeInt(this.position + 22, this.uncompressedSize, 4);
                    break;
                }
                case 11: {
                    ZipFileTreeStorer.this.writeInt(this.position + 26, this.fileNameLength, 2);
                    break;
                }
                case 12: {
                    ZipFileTreeStorer.this.writeInt(this.position + 28, this.extraFieldLength, 2);
                    break;
                }
                case 18: {
                    ZipFileTreeStorer.this.writeString(this.position + 30, this.fileName);
                    break;
                }
                case 19: {
                    ZipFileTreeStorer.this.writeString(this.position + 30 + this.fileName.length(), this.extraField);
                    break;
                }
            }
        }

        public void writeAll() throws IOException {
            int i = 1;
            while (i <= 20) {
                this.writeData(i);
                ++i;
            }
        }

        public void writeDataDescriptor() throws IOException {
            int startPosition = this.position + this.getThisHeaderSpace() + this.compressedSize;
            ZipFileTreeStorer.this.writeInt(startPosition, 134695760, 4);
            ZipFileTreeStorer.this.writeInt(startPosition + 4, this.crc32, 4);
            ZipFileTreeStorer.this.writeInt(startPosition + 8, this.compressedSize, 4);
            ZipFileTreeStorer.this.writeInt(startPosition + 12, this.uncompressedSize, 4);
        }

        public String toString() {
            String toReturn = "";
            toReturn = String.valueOf(toReturn) + "position in file: " + String.valueOf(this.position) + "\n";
            toReturn = String.valueOf(toReturn) + "size: " + String.valueOf(this.size) + "\n";
            toReturn = String.valueOf(toReturn) + "sig: " + String.valueOf(this.sig) + "\n";
            toReturn = String.valueOf(toReturn) + "version made: " + String.valueOf(this.versionNeededToExtract) + "\n";
            toReturn = String.valueOf(toReturn) + "bit flag: " + String.valueOf(this.bitFlag) + "\n";
            toReturn = String.valueOf(toReturn) + "compression method: " + String.valueOf(this.compressionMethod) + "\n";
            toReturn = String.valueOf(toReturn) + "las mod time: " + String.valueOf(this.lastModTime) + "\n";
            toReturn = String.valueOf(toReturn) + "crc-32: " + String.valueOf(this.crc32) + "\n";
            toReturn = String.valueOf(toReturn) + "compressed size: " + String.valueOf(this.compressedSize) + "\n";
            toReturn = String.valueOf(toReturn) + "uncompressed size: " + String.valueOf(this.uncompressedSize) + "\n";
            toReturn = String.valueOf(toReturn) + "file name length: " + String.valueOf(this.fileNameLength) + "\n";
            toReturn = String.valueOf(toReturn) + "extra field length: " + String.valueOf(this.extraFieldLength) + "\n";
            toReturn = String.valueOf(toReturn) + "local header file name: " + this.fileName + " spans from " + String.valueOf(this.position) + " to " + String.valueOf(this.position + this.getThisHeaderSpace() + this.compressedSize) + "\n";
            toReturn = String.valueOf(toReturn) + "extra field: " + this.extraField + "\n";
            toReturn = this.hasDataDescriptor ? String.valueOf(toReturn) + "There IS a data descriptor\n" : String.valueOf(toReturn) + "There ISN'T a data descriptor\n";
            return toReturn;
        }
    }

    private class LocalizedVacuity {
        public int pos;
        public int size;

        public LocalizedVacuity(int newpos, int newsize) {
            this.pos = newpos;
            this.size = newsize;
        }

        public String toString() {
            return "position: " + String.valueOf(this.pos) + ", size: " + String.valueOf(this.size);
        }
    }

    private class HoleComparator
    implements Comparator {
        private HoleComparator() {
        }

        public int compare(Object a, Object b) {
            LocalizedVacuity holeA = (LocalizedVacuity)a;
            LocalizedVacuity holeB = (LocalizedVacuity)b;
            return holeA.size - holeB.size;
        }
    }

    private class HeaderSizeComparator
    implements Comparator {
        private HeaderSizeComparator() {
        }

        public int compare(Object a, Object b) {
            CentralDirectoryHeader headerA = (CentralDirectoryHeader)a;
            CentralDirectoryHeader headerB = (CentralDirectoryHeader)b;
            int headerASize = headerA.getLocalHeaderSpace();
            int headerBSize = headerB.getLocalHeaderSpace();
            return headerASize - headerBSize;
        }
    }

    private class HeaderLocationComparator
    implements Comparator {
        private HeaderLocationComparator() {
        }

        public int compare(Object a, Object b) {
            CentralDirectoryHeader headerA = (CentralDirectoryHeader)a;
            CentralDirectoryHeader headerB = (CentralDirectoryHeader)b;
            return headerA.relativeOffset - headerB.relativeOffset;
        }
    }
}

