/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.awt;

import java.awt.Component;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class AWTUtilities {
    private static boolean s_successfullyLoadedLibrary;
    private static Vector s_mouseListeners;
    private static Vector s_mouseMotionListeners;
    private static Component s_source;
    private static int s_prevModifiers;
    private static int s_clickCount;
    private static Point s_prevCursorPos;
    private static Point s_currCursorPos;

    static {
        try {
            System.loadLibrary("jni_awtutilities");
            s_successfullyLoadedLibrary = true;
        }
        catch (Throwable t) {
            s_successfullyLoadedLibrary = false;
        }
        s_mouseListeners = new Vector();
        s_mouseMotionListeners = new Vector();
        s_source = new Label("toolkit.Toolkit");
        s_prevModifiers = 0;
        s_clickCount = 0;
        s_prevCursorPos = new Point();
        s_currCursorPos = new Point();
    }

    private static native boolean isGetCursorLocationSupportedNative();

    public static boolean isGetCursorLocationSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isGetCursorLocationSupportedNative();
        }
        return false;
    }

    private static native boolean isSetCursorLocationSupportedNative();

    public static boolean isSetCursorLocationSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isSetCursorLocationSupportedNative();
        }
        return false;
    }

    private static native boolean isGetModifiersSupportedNative();

    public static boolean isGetModifiersSupported() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.isGetModifiersSupportedNative();
        }
        return false;
    }

    private static native void pumpMessageQueueNative();

    public static void pumpMessageQueue() {
        if (s_successfullyLoadedLibrary) {
            AWTUtilities.pumpMessageQueueNative();
        }
    }

    private static native void getCursorLocationNative(Point var0);

    public static Point getCursorLocation() {
        if (s_successfullyLoadedLibrary) {
            Point p = new Point();
            AWTUtilities.getCursorLocationNative(p);
            return p;
        }
        return null;
    }

    private static native void setCursorLocationNative(int var0, int var1);

    public static void setCursorLocation(int x, int y) {
        if (s_successfullyLoadedLibrary) {
            AWTUtilities.setCursorLocationNative(x, y);
        }
    }

    public static void setCursorLocation(Point p) {
        AWTUtilities.setCursorLocation(p.x, p.y);
    }

    private static native int getModifiersNative();

    public static int getModifiers() {
        if (s_successfullyLoadedLibrary) {
            return AWTUtilities.getModifiersNative();
        }
        return 0;
    }

    public static boolean mouseListenersAreSupported() {
        return AWTUtilities.isGetModifiersSupported() && AWTUtilities.isGetCursorLocationSupported();
    }

    public static boolean mouseMotionListenersAreSupported() {
        return AWTUtilities.isGetModifiersSupported() && AWTUtilities.isGetCursorLocationSupported();
    }

    public static void addMouseListener(MouseListener mouseListener) {
        s_mouseListeners.addElement(mouseListener);
    }

    public static void removeMouseListener(MouseListener mouseListener) {
        s_mouseListeners.removeElement(mouseListener);
    }

    public static void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.addElement(mouseMotionListener);
    }

    public static void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        s_mouseMotionListeners.removeElement(mouseMotionListener);
    }

    private static boolean isButton1Pressed(int modifiers) {
        return (modifiers & 0x10) == 16;
    }

    private static boolean isButton2Pressed(int modifiers) {
        return (modifiers & 8) == 8;
    }

    private static boolean isButton3Pressed(int modifiers) {
        return (modifiers & 4) == 4;
    }

    public static void fireMouseAndMouseMotionListenersIfNecessary() {
        if (AWTUtilities.mouseListenersAreSupported()) {
            int id = 0;
            int currModifiers = AWTUtilities.getModifiers();
            boolean drag = false;
            if (AWTUtilities.isButton1Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton1Pressed(currModifiers)) {
                    drag = true;
                } else {
                    id = 502;
                }
            } else if (AWTUtilities.isButton1Pressed(currModifiers)) {
                id = 501;
                drag = true;
            }
            if (AWTUtilities.isButton2Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton2Pressed(currModifiers)) {
                    drag = true;
                } else {
                    id = 502;
                }
            } else if (AWTUtilities.isButton2Pressed(currModifiers)) {
                id = 501;
                drag = true;
            }
            if (AWTUtilities.isButton3Pressed(s_prevModifiers)) {
                if (AWTUtilities.isButton3Pressed(currModifiers)) {
                    drag = true;
                } else {
                    id = 502;
                }
            } else if (AWTUtilities.isButton3Pressed(currModifiers)) {
                id = 501;
                drag = true;
            }
            long when = System.currentTimeMillis();
            boolean isPopupTrigger = false;
            AWTUtilities.getCursorLocationNative(s_currCursorPos);
            if (id != 0) {
                if (s_mouseListeners.size() > 0) {
                    MouseEvent mouseEvent = new MouseEvent(s_source, id, when, currModifiers, AWTUtilities.s_currCursorPos.x, AWTUtilities.s_currCursorPos.y, s_clickCount, isPopupTrigger);
                    int i = 0;
                    while (i < s_mouseListeners.size()) {
                        MouseListener mouseListener = (MouseListener)s_mouseListeners.elementAt(i);
                        switch (id) {
                            case 500: {
                                mouseListener.mouseClicked(mouseEvent);
                                break;
                            }
                            case 504: {
                                mouseListener.mouseEntered(mouseEvent);
                                break;
                            }
                            case 505: {
                                mouseListener.mouseExited(mouseEvent);
                                break;
                            }
                            case 501: {
                                mouseListener.mousePressed(mouseEvent);
                                break;
                            }
                            case 502: {
                                mouseListener.mouseReleased(mouseEvent);
                            }
                        }
                        ++i;
                    }
                }
            } else if ((AWTUtilities.s_currCursorPos.x != AWTUtilities.s_prevCursorPos.x || AWTUtilities.s_currCursorPos.y != AWTUtilities.s_prevCursorPos.y) && s_mouseMotionListeners.size() > 0) {
                id = drag ? 506 : 503;
                MouseEvent mouseEvent = new MouseEvent(s_source, id, when, currModifiers, AWTUtilities.s_currCursorPos.x, AWTUtilities.s_currCursorPos.y, s_clickCount, isPopupTrigger);
                int i = 0;
                while (i < s_mouseMotionListeners.size()) {
                    MouseMotionListener mouseMotionListener = (MouseMotionListener)s_mouseMotionListeners.elementAt(i);
                    switch (id) {
                        case 503: {
                            mouseMotionListener.mouseMoved(mouseEvent);
                            break;
                        }
                        case 506: {
                            mouseMotionListener.mouseDragged(mouseEvent);
                        }
                    }
                    ++i;
                }
            }
            AWTUtilities.s_prevCursorPos.x = AWTUtilities.s_currCursorPos.x;
            AWTUtilities.s_prevCursorPos.y = AWTUtilities.s_currCursorPos.y;
            s_prevModifiers = currModifiers;
        }
    }
}

