/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.visualization;

import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.Visualization;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import java.util.Vector;

public abstract class CollectionOfModelsVisualization
extends Visualization {
    private Vector m_bins = new Vector();
    private Variable m_itemsVariable = null;

    public void unhook(Model model) {
        int i = this.indexOf(model, 0);
        if (i != -1) {
            this.set(i, null);
        }
    }

    protected String getItemsName() {
        return "items";
    }

    private Variable getItemsVariable() {
        if (this.m_itemsVariable == null) {
            this.m_itemsVariable = (Variable)this.getChildNamed(this.getItemsName());
        }
        return this.m_itemsVariable;
    }

    public Collection getItemsCollection() {
        return (Collection)this.getItemsVariable().value.getValue();
    }

    public Model[] getItems() {
        return (Model[])this.getItemsCollection().values.getArrayValue();
    }

    public void setItems(Model[] items) {
        this.getItemsCollection().values.set(items);
    }

    private Model getPrototype() {
        return (Model)this.getChildNamed("BinPrototype");
    }

    private int getBinCount() {
        return this.m_bins.size();
    }

    private Model getBinAt(int i) {
        return (Model)this.m_bins.get(i);
    }

    private void setBinAt(int i, Model bin) {
        if (this.m_bins.size() == i) {
            this.m_bins.addElement(bin);
        } else {
            if (this.m_bins.size() < i) {
                this.m_bins.ensureCapacity(i + 1);
            }
            this.m_bins.set(i, bin);
        }
    }

    private void synchronize(Model[] curr) {
        int binCount = this.getBinCount();
        int i = binCount - 1;
        while (i >= curr.length) {
            Model binI = this.getBinAt(i);
            this.m_bins.remove(binI);
            --i;
        }
        Model prototype = this.getPrototype();
        if (prototype != null) {
            int i2 = binCount;
            while (i2 < curr.length) {
                Class[] share = new Class[]{};
                String name = "Sub" + i2;
                Model binI = (Model)this.getChildNamed(name);
                if (binI == null) {
                    binI = (Model)prototype.HACK_createCopy(name, this, -1, share, null);
                }
                this.setBinAt(i2, binI);
                ++i2;
            }
            binCount = this.getBinCount();
        }
    }

    public Model get(int i) {
        return (Model)this.getItemsCollection().values.get(i);
    }

    public void set(int i, Model model) {
        this.getItemsCollection().values.set(i, model);
    }

    public int indexOf(Model model, int from) {
        return this.getItemsCollection().values.indexOf(model, from);
    }

    public int lastIndexOf(Model model, int from) {
        return this.getItemsCollection().values.lastIndexOf(model, from);
    }

    public boolean contains(Model model) {
        return this.getItemsCollection().values.contains(model);
    }

    public int size() {
        return this.getItemsCollection().values.size();
    }

    public boolean isEmpty() {
        return this.getItemsCollection().values.isEmpty();
    }

    protected void loadCompleted() {
        super.loadCompleted();
        Collection collection = this.getItemsCollection();
        if (collection != null) {
            collection.values.addPropertyListener(new PropertyListener(){

                public void propertyChanging(PropertyEvent propertyEvent) {
                }

                public void propertyChanged(PropertyEvent propertyEvent) {
                    CollectionOfModelsVisualization.this.synchronize((Model[])propertyEvent.getValue());
                }
            });
            this.synchronize(this.getItems());
        } else {
            System.err.println("WARNING: collection is null " + this);
        }
    }
}

