/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.DoTogether;

public class DoInOrder
extends CompositeResponse {
    private static Class[] s_supportedCoercionClasses = new Class[]{DoTogether.class};

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public class RuntimeDoInOrder
    extends CompositeResponse.RuntimeCompositeResponse {
        private int m_index;
        private double m_timeRemaining;

        public RuntimeDoInOrder() {
            super(DoInOrder.this);
            this.m_index = 0;
        }

        protected boolean preLoopTest(double t) {
            return true;
        }

        protected boolean postLoopTest(double t) {
            return false;
        }

        protected int getChildCount() {
            Response.RuntimeResponse[] runtimeResponses = this.getRuntimeResponses();
            return runtimeResponses.length;
        }

        protected double getChildTimeRemaining(int index, double t) {
            Response.RuntimeResponse[] runtimeResponses = this.getRuntimeResponses();
            return runtimeResponses[index].getTimeRemaining(t);
        }

        protected void childPrologueIfNecessary(int index, double t) {
            Response.RuntimeResponse[] runtimeResponses = this.getRuntimeResponses();
            if (!runtimeResponses[index].isActive()) {
                runtimeResponses[index].prologue(t);
            }
        }

        protected void childUpdate(int index, double t) {
            Response.RuntimeResponse[] runtimeResponses = this.getRuntimeResponses();
            runtimeResponses[index].update(t);
        }

        protected void childEpilogue(int index, double t) {
            Response.RuntimeResponse[] runtimeResponses = this.getRuntimeResponses();
            runtimeResponses[index].epilogue(t);
        }

        protected boolean isCullable() {
            return this.getChildCount() == 0;
        }

        public void prologue(double t) {
            super.prologue(t);
            this.m_index = -1;
        }

        public void update(double t) {
            super.update(t);
            if (this.isCullable()) {
                this.m_timeRemaining = 0.0;
            } else {
                double timeRemaining;
                this.m_timeRemaining = Double.POSITIVE_INFINITY;
                do {
                    if (this.m_index == -1) {
                        if (this.preLoopTest(t)) {
                            if (this.getChildCount() == 0) {
                                if (this.postLoopTest(t)) {
                                    this.m_index = -1;
                                    break;
                                }
                                this.m_timeRemaining = 0.0;
                                break;
                            }
                            this.m_index = 0;
                        } else {
                            this.m_timeRemaining = 0.0;
                            break;
                        }
                    }
                    this.childPrologueIfNecessary(this.m_index, t);
                    this.childUpdate(this.m_index, t);
                    timeRemaining = this.getChildTimeRemaining(this.m_index, t);
                    if (timeRemaining <= 0.0) {
                        this.childEpilogue(this.m_index, t);
                        ++this.m_index;
                    }
                    if (this.m_index != this.getChildCount()) continue;
                    if (this.postLoopTest(t)) {
                        this.m_index = -1;
                        continue;
                    }
                    this.m_timeRemaining = 0.0;
                    break;
                } while (timeRemaining < 0.0);
            }
        }

        public double getTimeRemaining(double t) {
            return this.m_timeRemaining;
        }
    }
}

