/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.applet.AppletXmlStruct;
import edu.cmu.cs.stage3.alice.core.criterion.ElementKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.ExternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.InternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.core.reference.ObjectArrayPropertyReference;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.util.Criterion;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ObjectArrayProperty
extends ObjectProperty {
    private Object[] m_arrayValueIfNull = null;
    private Vector m_objectArrayPropertyListeners = new Vector();
    private ObjectArrayPropertyListener[] m_objectArrayPropertyListenerArray = null;

    public ObjectArrayProperty(Element owner, String name, Object[] defaultValue, Class valueClass) {
        super(owner, name, defaultValue, valueClass);
    }

    public void addObjectArrayPropertyListener(ObjectArrayPropertyListener objectArrayPropertyListener) {
        if (!this.m_objectArrayPropertyListeners.contains(objectArrayPropertyListener)) {
            this.m_objectArrayPropertyListeners.addElement(objectArrayPropertyListener);
            this.m_objectArrayPropertyListenerArray = null;
        }
    }

    public void removeObjectArrayPropertyListener(ObjectArrayPropertyListener objectArrayPropertyListener) {
        this.m_objectArrayPropertyListeners.removeElement(objectArrayPropertyListener);
        this.m_objectArrayPropertyListenerArray = null;
    }

    public ObjectArrayPropertyListener[] getObjectArrayPropertyListeners() {
        if (this.m_objectArrayPropertyListenerArray == null) {
            this.m_objectArrayPropertyListenerArray = new ObjectArrayPropertyListener[this.m_objectArrayPropertyListeners.size()];
            this.m_objectArrayPropertyListeners.copyInto(this.m_objectArrayPropertyListenerArray);
        }
        return this.m_objectArrayPropertyListenerArray;
    }

    public Class getComponentType() {
        return this.getValueClass().getComponentType();
    }

    public void setComponentType(Class componentType) {
        Object value = this.get();
        Object[] prevArray = null;
        int length = 0;
        if (value != null && value instanceof Object[]) {
            prevArray = (Object[])value;
            length = prevArray.length;
        }
        Object[] currArray = (Object[])Array.newInstance(componentType, length);
        this.setValueClass(currArray.getClass());
        if (value != null) {
            System.arraycopy(prevArray, 0, currArray, 0, length);
            this.set(currArray);
        }
    }

    public Object[] getArrayValue() {
        Object[] value = (Object[])this.getValue();
        if (value != null) {
            return value;
        }
        if (this.m_arrayValueIfNull == null) {
            this.m_arrayValueIfNull = (Object[])Array.newInstance(this.getComponentType(), 0);
        }
        return this.m_arrayValueIfNull;
    }

    protected void decodeObject(org.w3c.dom.Element node, Vector referencesToBeResolved) throws IOException {
        String componentTypeName = node.getAttribute("componentClass");
        try {
            Class<?> arrayComponentCls = Class.forName(componentTypeName);
            NodeList itemNodeList = node.getElementsByTagName("item");
            Object[] array = (Object[])Array.newInstance(arrayComponentCls, itemNodeList.getLength());
            int precedingReferenceTotal = 0;
            int i = 0;
            while (i < array.length) {
                org.w3c.dom.Element itemNode = (org.w3c.dom.Element)itemNodeList.item(i);
                String criterionTypeName = itemNode.getAttribute("criterionClass");
                if (criterionTypeName.length() > 0) {
                    try {
                        Class<ElementKeyedCriterion> criterionType = Class.forName(criterionTypeName);
                        String text = this.getNodeText(itemNode);
                        Criterion criterion = criterionType.isAssignableFrom(InternalReferenceKeyedCriterion.class) ? new InternalReferenceKeyedCriterion(text) : (criterionType.isAssignableFrom(ExternalReferenceKeyedCriterion.class) ? new ExternalReferenceKeyedCriterion(text) : (Criterion)this.getValueOf(criterionType, text));
                        referencesToBeResolved.addElement(new ObjectArrayPropertyReference(this, criterion, i, precedingReferenceTotal++));
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new RuntimeException(criterionTypeName);
                    }
                } else {
                    String itemTypeName = itemNode.getAttribute("class");
                    if (itemTypeName.length() > 0) {
                        try {
                            Class<?> itemType = Class.forName(itemTypeName);
                            array[i] = this.getValueOf(itemType, this.getNodeText(itemNode));
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw new RuntimeException(itemTypeName);
                        }
                    } else {
                        array[i] = null;
                    }
                }
                ++i;
            }
            this.set(array);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(componentTypeName);
        }
    }

    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        if (node == null) {
            System.err.println("node==null");
            System.err.println(this);
        }
        if (this.getComponentType() == null) {
            System.err.println("getComponentType()==null");
            System.err.println(this);
        }
        node.setAttribute("componentClass", this.getComponentType().getName());
        Object[] array = this.getArrayValue();
        if (array != null && array.length > 0) {
            Object[] objectArray = array;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object item = objectArray[n];
                org.w3c.dom.Element itemNode = document.createElement("item");
                if (item instanceof Element) {
                    this.encodeReference(document, itemNode, referenceGenerator, (Element)item);
                } else if (item != null) {
                    itemNode.setAttribute("class", item.getClass().getName());
                    itemNode.appendChild(this.createNodeForString(document, item.toString()));
                }
                node.appendChild(itemNode);
                ++n;
            }
        }
    }

    protected AppletXmlStruct encodeObjectToXml(ReferenceGenerator referenceGenerator) throws IOException {
        AppletXmlStruct struct = new AppletXmlStruct();
        struct.addAtribute("componentClass='" + this.getComponentType().getName() + "'");
        Object[] array = this.getArrayValue();
        if (array != null && array.length > 0) {
            Object[] objectArray = array;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object item = objectArray[n];
                struct.addElement("<item");
                if (item instanceof Element) {
                    AppletXmlStruct itemStruct = this.encodeReferenceToXml(referenceGenerator, (Element)item);
                    struct.addElement(String.valueOf(itemStruct.getAttributes()) + ">");
                    struct.addElement(itemStruct.getElements());
                } else if (item != null) {
                    struct.addElement(" class='" + item.getClass().getName() + "'>");
                    struct.addElement(item.toString());
                }
                struct.addElement("</item>");
                ++n;
            }
        }
        return struct;
    }

    private void onItemChanging(Object item, int changeType, int oldIndex, int newIndex) {
        if (!this.m_objectArrayPropertyListeners.isEmpty()) {
            ObjectArrayPropertyListener[] objectArrayPropertyListeners;
            ObjectArrayPropertyEvent objectArrayPropertyEvent = new ObjectArrayPropertyEvent(this, item, changeType, oldIndex, newIndex);
            ObjectArrayPropertyListener[] objectArrayPropertyListenerArray = objectArrayPropertyListeners = this.getObjectArrayPropertyListeners();
            int n = 0;
            int n2 = objectArrayPropertyListenerArray.length;
            while (n < n2) {
                ObjectArrayPropertyListener objectArrayPropertyListener = objectArrayPropertyListenerArray[n];
                objectArrayPropertyListener.objectArrayPropertyChanging(objectArrayPropertyEvent);
                ++n;
            }
        }
    }

    private void onItemChanged(Object item, int changeType, int oldIndex, int newIndex) {
        if (!this.m_objectArrayPropertyListeners.isEmpty()) {
            ObjectArrayPropertyListener[] objectArrayPropertyListeners;
            ObjectArrayPropertyEvent objectArrayPropertyEvent = new ObjectArrayPropertyEvent(this, item, changeType, oldIndex, newIndex);
            ObjectArrayPropertyListener[] objectArrayPropertyListenerArray = objectArrayPropertyListeners = this.getObjectArrayPropertyListeners();
            int n = 0;
            int n2 = objectArrayPropertyListenerArray.length;
            while (n < n2) {
                ObjectArrayPropertyListener objectArrayPropertyListener = objectArrayPropertyListenerArray[n];
                objectArrayPropertyListener.objectArrayPropertyChanged(objectArrayPropertyEvent);
                ++n;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(int index, Object o) {
        if (index == -1) {
            this.add(o);
            return;
        } else {
            Object[] prev = this.getArrayValue();
            if (prev == null) {
                if (index != 0) throw new RuntimeException();
                this.add(o);
                return;
            } else {
                this.onItemChanging(o, 1, -1, index);
                int n = prev.length;
                Object[] curr = (Object[])Array.newInstance(this.getComponentType(), n + 1);
                if (index > 0) {
                    System.arraycopy(prev, 0, curr, 0, index);
                }
                if (index < n) {
                    System.arraycopy(prev, index, curr, index + 1, n - index);
                }
                curr[index] = o;
                this.set(curr);
                this.onItemChanged(o, 1, -1, index);
            }
        }
    }

    public void addValue(int index, Object o) {
        this.add(index, this.evaluateIfNecessary(o));
    }

    public void add(Object o) {
        Object[] curr;
        Object[] prev = this.getArrayValue();
        int index = prev == null ? 0 : prev.length;
        this.onItemChanging(o, 1, -1, index);
        if (prev == null) {
            curr = (Object[])Array.newInstance(this.getComponentType(), 1);
        } else {
            curr = (Object[])Array.newInstance(this.getComponentType(), index + 1);
            System.arraycopy(prev, 0, curr, 0, index);
        }
        curr[index] = o;
        this.set(curr);
        this.onItemChanged(o, 1, -1, index);
    }

    public void addValue(Object o) {
        this.add(this.evaluateIfNecessary(o));
    }

    public void remove(int index) {
        Object[] prev = this.getArrayValue();
        this.onItemChanging(prev[index], 3, index, -1);
        int n = prev.length;
        Object[] curr = (Object[])Array.newInstance(this.getComponentType(), n - 1);
        if (index > 0) {
            System.arraycopy(prev, 0, curr, 0, index);
        }
        if (index < n - 1) {
            System.arraycopy(prev, index + 1, curr, index, n - 1 - index);
        }
        this.set(curr);
        this.onItemChanged(prev[index], 3, index, -1);
    }

    public void remove(Object o) {
        Object[] prev = this.getArrayValue();
        if (prev != null) {
            int n = prev.length;
            int i = 0;
            while (i < n) {
                if (prev[i] == o) {
                    this.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    public void removeValue(Object o) {
        this.remove(this.evaluateIfNecessary(o));
    }

    public void set(int index, Object o) {
        this.ensureCapacity(index + 1);
        int n = this.size();
        if (index < 0 || index >= n) {
            throw new ArrayIndexOutOfBoundsException("index " + index + " is out of bounds [ 0, " + n + ")");
        }
        Object[] prev = this.getArrayValue();
        this.onItemChanging(prev[index], 3, index, -1);
        this.onItemChanging(o, 1, -1, index);
        Object[] curr = (Object[])Array.newInstance(this.getComponentType(), n);
        System.arraycopy(prev, 0, curr, 0, n);
        curr[index] = o;
        this.set(curr);
        this.onItemChanged(prev[index], 3, index, -1);
        this.onItemChanged(o, 1, -1, index);
    }

    public void setValue(int index, Object o) {
        this.set(index, this.evaluateIfNecessary(o));
    }

    public void clear() {
        Object[] prev = this.getArrayValue();
        int i = 0;
        while (i < prev.length) {
            this.onItemChanging(prev[i], 3, i, -1);
            ++i;
        }
        this.set(Array.newInstance(this.getComponentType(), 0));
        i = 0;
        while (i < prev.length) {
            this.onItemChanged(prev[i], 3, i, -1);
            ++i;
        }
    }

    public void shift(int fromIndex, int toIndex) {
        if (fromIndex != toIndex) {
            Object[] prev = this.getArrayValue();
            this.onItemChanging(prev[fromIndex], 2, fromIndex, toIndex);
            Object[] curr = (Object[])Array.newInstance(this.getComponentType(), prev.length);
            if (fromIndex < toIndex) {
                int i = 0;
                while (i < fromIndex) {
                    curr[i] = prev[i];
                    ++i;
                }
                i = fromIndex;
                while (i < toIndex) {
                    curr[i] = prev[i + 1];
                    ++i;
                }
                curr[toIndex] = prev[fromIndex];
                i = toIndex + 1;
                while (i < prev.length) {
                    curr[i] = prev[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < toIndex) {
                    curr[i] = prev[i];
                    ++i;
                }
                curr[toIndex] = prev[fromIndex];
                i = toIndex + 1;
                while (i < fromIndex + 1) {
                    curr[i] = prev[i - 1];
                    ++i;
                }
                i = fromIndex + 1;
                while (i < prev.length) {
                    curr[i] = prev[i];
                    ++i;
                }
            }
            this.set(curr);
            this.onItemChanged(prev[fromIndex], 2, fromIndex, toIndex);
        }
    }

    public Object get(int index) {
        int n = this.size();
        if (index == -1) {
            index = n;
        }
        if (index >= 0 && index < n) {
            Object[] array = this.getArrayValue();
            return array[index];
        }
        return null;
    }

    public Object getValue(int index) {
        return this.evaluateIfNecessary(this.get(index));
    }

    private static boolean areEqual(Object a, Object b, boolean evaluateExpressionIfNecessary) {
        if (evaluateExpressionIfNecessary) {
            if (a == null) {
                return b == null;
            }
            if (a.equals(b)) {
                return true;
            }
            if (a instanceof Expression) {
                Expression e = (Expression)a;
                Object v = e.getValue();
                if (v == null) {
                    return b == null;
                }
                return v.equals(b);
            }
            return false;
        }
        return a == b;
    }

    private int indexOf(Object o, int index, boolean evaluateExpressionIfNecessary) {
        Object[] array = this.getArrayValue();
        if (array != null) {
            int i = index;
            while (i < array.length) {
                if (ObjectArrayProperty.areEqual(o, array[i], evaluateExpressionIfNecessary)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public int indexOf(Object o, int index) {
        return this.indexOf(o, index, false);
    }

    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    public int indexOfValue(Object o, int index) {
        return this.indexOf(o, index, true);
    }

    public int indexOfValue(Object o) {
        return this.indexOfValue(o, this.size() - 1);
    }

    private int lastIndexOf(Object o, int index, boolean evaluateExpressionIfNecessary) {
        Object[] array = this.getArrayValue();
        if (array != null) {
            int i = index;
            while (i >= 0) {
                if (ObjectArrayProperty.areEqual(o, array[i], evaluateExpressionIfNecessary)) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object o, int index) {
        return this.lastIndexOf(o, index, false);
    }

    public int lastIndexOf(Object o) {
        return this.lastIndexOf(o, this.size() - 1);
    }

    public int lastIndexOfValue(Object o, int index) {
        return this.lastIndexOf(o, index, true);
    }

    public int lastIndexOfValue(Object o) {
        return this.lastIndexOfValue(o, this.size() - 1);
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean containsValue(Object o) {
        return this.indexOfValue(o) != -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        Object[] value = this.getArrayValue();
        if (value != null) {
            return value.length;
        }
        return 0;
    }

    public void ensureCapacity(int minCapacity) {
        Object[] prev = this.getArrayValue();
        if (prev.length < minCapacity) {
            Object[] curr = (Object[])Array.newInstance(this.getComponentType(), minCapacity);
            System.arraycopy(prev, 0, curr, 0, prev.length);
            this.set(curr);
        }
    }
}

