/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.AbstractConditionalBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.MouseButtonClickBehavior;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.IntegerProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.question.PickQuestion;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseButtonIsPressedBehavior
extends AbstractConditionalBehavior
implements MouseListener,
MouseMotionListener {
    private static Class[] s_supportedCoercionClasses = new Class[]{MouseButtonClickBehavior.class};
    public final IntegerProperty requiredModifierMask = new IntegerProperty(this, "requiredModifierMask", new Integer(0));
    public final IntegerProperty excludedModifierMask = new IntegerProperty(this, "excludedModifierMask", new Integer(0));
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    public final TransformableProperty onWhat = new TransformableProperty((Element)this, "onWhat", null);
    private RenderTarget[] m_renderTargets = null;

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public void manufactureAnyNecessaryDetails() {
        if (this.details.size() == 2) {
            PickQuestion what = new PickQuestion();
            what.name.set("what");
            what.setParent(this);
            this.details.add(what);
        }
        int i = 0;
        while (i < this.details.size()) {
            Object o = this.details.get(i);
            if (o instanceof PickQuestion) {
                ((PickQuestion)o).name.set("what");
            }
            ++i;
        }
    }

    public void manufactureDetails() {
        super.manufactureDetails();
        Variable x = new Variable();
        x.name.set("x");
        x.setParent(this);
        x.valueClass.set(Number.class);
        this.details.add(x);
        Variable y = new Variable();
        y.name.set("y");
        y.setParent(this);
        y.valueClass.set(Number.class);
        this.details.add(y);
        this.manufactureAnyNecessaryDetails();
    }

    private void updateDetails(MouseEvent mouseEvent) {
        int i = 0;
        while (i < this.details.size()) {
            Expression detail = (Expression)this.details.get(i);
            if (detail.name.getStringValue().equals("x")) {
                ((Variable)detail).value.set(new Double(mouseEvent.getX()));
            } else if (detail.name.getStringValue().equals("y")) {
                ((Variable)detail).value.set(new Double(mouseEvent.getY()));
            } else if (detail.name.getStringValue().equals("what")) {
                ((PickQuestion)detail).setMouseEvent(mouseEvent);
            }
            ++i;
        }
    }

    private boolean checkModifierMask(InputEvent e) {
        int modifiers = e.getModifiers();
        Integer requiredModifierMaskValue = (Integer)this.requiredModifierMask.getValue();
        Integer excludedModifierMaskValue = (Integer)this.excludedModifierMask.getValue();
        int required = 0;
        if (requiredModifierMaskValue != null) {
            required = requiredModifierMaskValue;
        }
        int excluded = 0;
        if (excludedModifierMaskValue != null) {
            excluded = excludedModifierMaskValue;
        }
        return (modifiers & required) == required && (modifiers & excluded) == 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.updateDetails(mouseEvent);
        if (this.isEnabled.booleanValue() && this.checkModifierMask(mouseEvent)) {
            Transformable transformable = this.onWhat.getTransformableValue();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateDetails(mouseEvent);
        this.set(false);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateDetails(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected void started(World world, double time) {
        super.started(world, time);
        this.m_renderTargets = (RenderTarget[])this.renderTargets.get();
        if (this.m_renderTargets == null) {
            this.m_renderTargets = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.addMouseListener(this);
            target.addMouseMotionListener(this);
            ++n;
        }
    }

    protected void stopped(World world, double time) {
        super.stopped(world, time);
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.removeMouseListener(this);
            target.removeMouseMotionListener(this);
            ++n;
        }
        this.m_renderTargets = null;
    }
}

