/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.AbstractConditionalBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.KeyClickBehavior;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.IntegerProperty;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyIsPressedBehavior
extends AbstractConditionalBehavior
implements KeyListener {
    private static Class[] s_supportedCoercionClasses = new Class[]{KeyClickBehavior.class};
    private int m_keyCode = -1;
    public final IntegerProperty keyCode = new IntegerProperty(this, "keyCode", null);
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    private RenderTarget[] m_renderTargets = null;

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public void manufactureDetails() {
        super.manufactureDetails();
        Variable keyChar = new Variable();
        keyChar.name.set("keyChar");
        keyChar.setParent(this);
        keyChar.valueClass.set(Character.class);
        this.details.add(keyChar);
    }

    private void updateDetails(KeyEvent keyEvent) {
        int i = 0;
        while (i < this.details.size()) {
            Variable detail = (Variable)this.details.get(i);
            if (detail.name.getStringValue().equals("keyChar")) {
                detail.value.set(new Character(keyEvent.getKeyChar()));
            }
            ++i;
        }
    }

    private boolean checkKeyCode(int actualValue) {
        int requiredValue = this.keyCode.intValue(actualValue);
        return actualValue == requiredValue;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int keyCode;
        if (this.m_keyCode == -1 && this.checkKeyCode(keyCode = keyEvent.getKeyCode())) {
            this.m_keyCode = keyCode;
            this.updateDetails(keyEvent);
            this.set(true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int keyCode;
        if (this.m_keyCode != -1 && (keyCode = keyEvent.getKeyCode()) == this.m_keyCode) {
            this.updateDetails(keyEvent);
            this.set(false);
            this.m_keyCode = -1;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void started(World world, double time) {
        super.started(world, time);
        this.m_renderTargets = (RenderTarget[])this.renderTargets.get();
        if (this.m_renderTargets == null) {
            this.m_renderTargets = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.addKeyListener(this);
            ++n;
        }
        this.m_keyCode = -1;
    }

    protected void stopped(World world, double time) {
        super.stopped(world, time);
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.removeKeyListener(this);
            ++n;
        }
        this.m_renderTargets = null;
    }
}

