/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.IllegalArrayPropertyValueException;
import edu.cmu.cs.stage3.alice.core.IllegalPropertyValueException;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.applet.AppletXmlStruct;
import edu.cmu.cs.stage3.alice.core.criterion.ElementKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.ExternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.InternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.xml.NodeUtilities;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Property {
    private static boolean HACK_s_isListeningEnabled = true;
    private boolean m_isAcceptingOfHowMuch = false;
    private Element m_owner;
    private String m_name;
    private Object m_defaultValue;
    private Class m_valueClass;
    private Object m_value;
    private Vector m_propertyListeners = new Vector();
    private PropertyListener[] m_propertyListenerArray = null;
    private boolean m_isDeprecated = false;
    protected Object m_associatedFileKey = null;
    private static Dictionary s_ownerClassMap = new Hashtable();
    private static Behavior m_currentBehavior = null;

    public static void HACK_enableListening() {
        HACK_s_isListeningEnabled = true;
    }

    public static void HACK_disableListening() {
        HACK_s_isListeningEnabled = false;
    }

    public boolean isAcceptingOfHowMuch() {
        return this.m_isAcceptingOfHowMuch;
    }

    public void setIsAcceptingOfHowMuch(boolean isAcceptingOfHowMuch) {
        this.m_isAcceptingOfHowMuch = isAcceptingOfHowMuch;
    }

    protected Property(Element owner, String name, Object defaultValue, Class valueClass) {
        this.m_owner = owner;
        this.m_name = name;
        this.m_defaultValue = defaultValue;
        this.m_valueClass = valueClass;
        this.m_isAcceptingOfHowMuch = false;
        this.m_value = this.m_defaultValue;
        this.m_owner.propertyCreated(this);
    }

    public static String[] getPropertyNames(Class ownerClass, Class valueClass) {
        Object[] propertyNameArray;
        Hashtable<Class, Object[]> valueClassMap = (Hashtable<Class, Object[]>)s_ownerClassMap.get(ownerClass);
        if (valueClassMap == null) {
            valueClassMap = new Hashtable<Class, Object[]>();
            s_ownerClassMap.put(ownerClass, valueClassMap);
        }
        if ((propertyNameArray = (String[])((Dictionary)valueClassMap).get(valueClass)) == null) {
            Field[] fields;
            Vector<String> propertyNames = new Vector<String>();
            Field[] fieldArray = fields = ownerClass.getFields();
            int n = 0;
            int n2 = fieldArray.length;
            while (n < n2) {
                Field field = fieldArray[n];
                if (Property.class.isAssignableFrom(field.getType())) {
                    String propertyName = field.getName();
                    Class cls = Element.getValueClassForPropertyNamed(ownerClass, propertyName);
                    if (cls != null) {
                        if (valueClass.isAssignableFrom(cls)) {
                            propertyNames.addElement(propertyName);
                        }
                    } else {
                        System.err.println(ownerClass + " " + propertyName);
                    }
                }
                ++n;
            }
            propertyNameArray = new String[propertyNames.size()];
            propertyNames.copyInto(propertyNameArray);
            ((Dictionary)valueClassMap).put(valueClass, propertyNameArray);
        }
        return propertyNameArray;
    }

    public static String[] getPropertyNames(Class ownerClass) {
        return Property.getPropertyNames(ownerClass, Object.class);
    }

    public boolean isAlsoKnownAs(Class cls, String name) {
        if (cls.isAssignableFrom(this.m_owner.getClass())) {
            try {
                Field field = cls.getField(name);
                Object o = field.get(this.m_owner);
                return o == this;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public Element getOwner() {
        return this.m_owner;
    }

    @Deprecated
    public Element getElement() {
        return this.getOwner();
    }

    public Class getValueClass() {
        return this.m_valueClass;
    }

    protected void setValueClass(Class valueClass) {
        this.m_valueClass = valueClass;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getName() {
        return this.m_name;
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        if (!this.m_propertyListeners.contains(propertyListener)) {
            this.m_propertyListeners.addElement(propertyListener);
            this.m_propertyListenerArray = null;
        }
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.m_propertyListeners.removeElement(propertyListener);
        this.m_propertyListenerArray = null;
    }

    public PropertyListener[] getPropertyListeners() {
        if (this.m_propertyListenerArray == null) {
            this.m_propertyListenerArray = new PropertyListener[this.m_propertyListeners.size()];
            this.m_propertyListeners.copyInto(this.m_propertyListenerArray);
        }
        return this.m_propertyListenerArray;
    }

    public Class getDeclaredClass() {
        if (this.m_owner != null) {
            for (Class<?> cls = this.m_owner.getClass(); cls != null; cls = cls.getSuperclass()) {
                try {
                    Field field = cls.getDeclaredField(this.m_name);
                    if (field.get(this.m_owner) == this) {
                        return cls;
                    }
                    throw new RuntimeException(this.m_owner + " has field named " + this.m_name + " that is not " + this);
                }
                catch (NoSuchFieldException nsfe) {
                    continue;
                }
                catch (IllegalAccessException iae) {
                    throw new ExceptionWrapper(iae, null);
                }
            }
            return null;
        }
        return null;
    }

    public Object get() {
        if (this.m_value instanceof Cloneable) {
            if (this.m_value.getClass().isArray()) {
                return this.m_value;
            }
            try {
                Class[] parameterTypes = new Class[]{};
                Object[] parameterValues = new Object[]{};
                Method method = this.m_value.getClass().getMethod("clone", parameterTypes);
                if (method.isAccessible()) {
                    return method.invoke(this.m_value, parameterValues);
                }
                return this.m_value;
            }
            catch (Exception nsme) {
                return this.m_value;
            }
        }
        return this.m_value;
    }

    private boolean isValueInADifferentWorld(Object value) {
        World world = this.getElement().getWorld();
        if (world != null && value instanceof Element) {
            return world != this.getElement().getWorld();
        }
        return false;
    }

    public void checkForBadReferences(Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int i = 0;
            while (i < array.length) {
                if (this.isValueInADifferentWorld(array[i])) {
                    throw new IllegalArrayPropertyValueException(this, i, value, "value must be in world");
                }
                ++i;
            }
        } else if (this.isValueInADifferentWorld(value)) {
            throw new IllegalPropertyValueException(this, value, "value must be in world");
        }
    }

    protected void checkValueType(Object value) {
        if (value != null) {
            Class valueClass = this.getValueClass();
            if (value instanceof Expression) {
                Expression expression = (Expression)value;
                if (!(valueClass.isAssignableFrom(Expression.class) || valueClass.isAssignableFrom(Variable.class) || valueClass.isAssignableFrom(Question.class) || Question.class.isAssignableFrom(valueClass) || valueClass.isAssignableFrom(expression.getValueClass()))) {
                    throw new IllegalPropertyValueException(this, value, "Cannot set property " + this.getName() + " on " + this.getOwner() + ".  " + valueClass + " is not assignable from " + expression.getValueClass());
                }
            } else if (!valueClass.isAssignableFrom(value.getClass())) {
                throw new IllegalPropertyValueException(this, value, "Cannot set property " + this.getName() + " on " + this.getOwner() + ".  " + valueClass + " is not assignable from " + value.getClass());
            }
        }
    }

    protected boolean getValueOfExpression() {
        Class valueClass = this.getValueClass();
        if (valueClass.isAssignableFrom(Expression.class)) {
            return false;
        }
        if (valueClass.isAssignableFrom(Variable.class)) {
            return false;
        }
        return !valueClass.isAssignableFrom(Question.class);
    }

    protected Object evaluateIfNecessary(Object o) {
        if (o instanceof Expression) {
            Variable runtimeVariable;
            Sandbox sandbox;
            World world;
            Element owner;
            Expression expression = (Expression)o;
            if (m_currentBehavior == null && !this.isDeprecated() && expression instanceof Variable && (owner = this.getOwner()) != null && (world = owner.getWorld()) != null && (sandbox = world.getCurrentSandbox()) != null && (m_currentBehavior = sandbox.getCurrentBehavior()) != null && (runtimeVariable = m_currentBehavior.stackLookup((Variable)expression)) != null) {
                expression = runtimeVariable;
            }
            Object value = this.getValueOfExpression() ? expression.getValue() : expression;
            m_currentBehavior = null;
            return value;
        }
        return o;
    }

    public Object getValue() {
        return this.evaluateIfNecessary(this.m_value);
    }

    private void onChanging(PropertyEvent propertyEvent) {
        this.m_owner.propertyChanging(propertyEvent);
        if (HACK_s_isListeningEnabled) {
            PropertyListener[] propertyListeners;
            PropertyListener[] propertyListenerArray = propertyListeners = this.getPropertyListeners();
            int n = 0;
            int n2 = propertyListenerArray.length;
            while (n < n2) {
                PropertyListener propertyListener = propertyListenerArray[n];
                propertyListener.propertyChanging(propertyEvent);
                ++n;
            }
        }
    }

    private void onChanged(PropertyEvent propertyEvent) {
        this.getElement().markKeepKeyDirty();
        this.m_owner.propertyChanged(propertyEvent);
        if (HACK_s_isListeningEnabled) {
            PropertyListener[] propertyListeners;
            PropertyListener[] propertyListenerArray = propertyListeners = this.getPropertyListeners();
            int n = 0;
            int n2 = propertyListenerArray.length;
            while (n < n2) {
                PropertyListener propertyListener = propertyListenerArray[n];
                propertyListener.propertyChanged(propertyEvent);
                ++n;
            }
        }
    }

    protected void onSet(Object value) {
        this.getValueClass();
        PropertyEvent propertyEvent = new PropertyEvent(this, value);
        this.onChanging(propertyEvent);
        this.m_value = value;
        this.onChanged(propertyEvent);
        this.m_associatedFileKey = null;
    }

    public void set(Object value) throws IllegalArgumentException {
        if (this.m_value == null ? value == null : this.m_value.equals(value)) {
            return;
        }
        if (!Element.s_isLoading) {
            this.checkValueType(value);
            this.checkForBadReferences(value);
        }
        this.onSet(value);
    }

    private static void setHowMuch(Element owner, String propertyName, Object value, HowMuch howMuch) {
        Property property = owner.getPropertyNamed(propertyName);
        if (property != null) {
            property.set(value);
        }
        if (howMuch.getDescend()) {
            int i = 0;
            while (i < owner.getChildCount()) {
                Element child = owner.getChildAt(i);
                if (!howMuch.getRespectDescendant()) {
                    Property.setHowMuch(child, propertyName, value, howMuch);
                }
                ++i;
            }
        }
    }

    public void set(Object value, HowMuch howMuch) throws IllegalArgumentException {
        if (this.m_owner instanceof Element) {
            Property.setHowMuch(this.m_owner, this.m_name, value, howMuch);
        }
    }

    protected Object getValueOf(Class type, String text) {
        if (type.equals(Double.class)) {
            if (text.equals("Infinity")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (text.equals("NaN")) {
                return new Double(Double.NaN);
            }
            return Double.valueOf(text);
        }
        if (type.equals(String.class)) {
            return text;
        }
        try {
            Class[] parameterTypes = new Class[]{String.class};
            Method valueOfMethod = type.getMethod("valueOf", parameterTypes);
            int modifiers = valueOfMethod.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                Object[] parameters = new Object[]{text};
                return valueOfMethod.invoke(null, parameters);
            }
            throw new RuntimeException("valueOf method not public static.");
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("NoSuchMethodException:" + type);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException: " + type);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("java.lang.reflect.InvocationTargetException: " + type + " " + text);
        }
    }

    protected String getNodeText(Node node) {
        return NodeUtilities.getNodeText(node);
    }

    protected Node createNodeForString(Document document, String s) {
        char[] cdataCharacters;
        char[] cArray = cdataCharacters = new char[]{' ', '\t', '\n', '\"', '\'', '>', '<', '&'};
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char cdataCharacter = cArray[n];
            if (s.indexOf(cdataCharacter) != -1) {
                return document.createCDATASection(s);
            }
            ++n;
        }
        return document.createTextNode(s);
    }

    protected String getFilename(String text) {
        String[] markers = new String[]{"java.io.File[", "]"};
        int begin = text.indexOf(markers[0]) + markers[0].length();
        int end = text.lastIndexOf(markers[1]);
        return text.substring(begin, end);
    }

    protected void decodeReference(org.w3c.dom.Element node, Vector referencesToBeResolved, String typeName) {
        try {
            Class<ElementKeyedCriterion> type = Class.forName(typeName);
            String text = this.getNodeText(node);
            if (text.equals(".")) {
                text = "";
            }
            Criterion criterion = type.isAssignableFrom(InternalReferenceKeyedCriterion.class) ? new InternalReferenceKeyedCriterion(text) : (type.isAssignableFrom(ExternalReferenceKeyedCriterion.class) ? new ExternalReferenceKeyedCriterion(text) : (Criterion)this.getValueOf(type, text));
            referencesToBeResolved.addElement(new PropertyReference(this, criterion));
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(typeName);
        }
    }

    protected void decodeObject(org.w3c.dom.Element node, Vector referencesToBeResolved) throws IOException {
        String typeName = node.getAttribute("class");
        if (typeName.length() > 0) {
            String text = this.getNodeText(node);
            try {
                Class<?> type = Class.forName(typeName);
                this.set(this.getValueOf(type, text));
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(typeName);
            }
        } else {
            System.err.println(this);
            throw new RuntimeException();
        }
    }

    public final void decode(org.w3c.dom.Element node, Vector referencesToBeResolved) throws IOException {
        if (node.hasChildNodes()) {
            String criterionClassname = node.getAttribute("criterionClass");
            if (criterionClassname.length() > 0) {
                this.decodeReference(node, referencesToBeResolved, criterionClassname);
            } else {
                this.decodeObject(node, referencesToBeResolved);
            }
        } else {
            this.set(null);
        }
    }

    protected void encodeReference(Document document, org.w3c.dom.Element node, ReferenceGenerator referenceGenerator, Element owner) {
        Criterion criterion = referenceGenerator.generateReference(owner);
        if (criterion != null) {
            node.setAttribute("criterionClass", criterion.getClass().getName());
            String s = criterion instanceof InternalReferenceKeyedCriterion ? ((InternalReferenceKeyedCriterion)criterion).getKey() : (criterion instanceof ExternalReferenceKeyedCriterion ? ((ExternalReferenceKeyedCriterion)criterion).getKey() : criterion.toString());
            if (s.length() == 0) {
                s = ".";
            }
            node.appendChild(this.createNodeForString(document, s));
        }
    }

    protected AppletXmlStruct encodeReferenceToXml(ReferenceGenerator referenceGenerator, Element owner) {
        Criterion criterion = referenceGenerator.generateReference(owner);
        AppletXmlStruct struct = new AppletXmlStruct();
        if (criterion != null) {
            struct.addAtribute("criterionClass='" + criterion.getClass().getName() + "'");
            if (criterion instanceof InternalReferenceKeyedCriterion) {
                struct.addElement(((InternalReferenceKeyedCriterion)criterion).getKey());
            } else if (criterion instanceof ExternalReferenceKeyedCriterion) {
                struct.addElement(((ExternalReferenceKeyedCriterion)criterion).getKey());
            } else {
                struct.addElement(criterion.toString());
            }
            if (struct.getElements().length() == 0) {
                struct.addElement(".");
            }
        }
        return struct;
    }

    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object o = this.get();
        node.setAttribute("class", o.getClass().getName());
        node.appendChild(this.createNodeForString(document, o.toString()));
    }

    protected AppletXmlStruct encodeObjectToXml(ReferenceGenerator referenceGenerator) throws IOException {
        Object o = this.get();
        AppletXmlStruct struct = new AppletXmlStruct();
        if (o == null || o instanceof Element) {
            return struct;
        }
        struct.addAtribute("class='" + o.getClass().getName() + "'");
        struct.addElement(o.toString());
        return struct;
    }

    public final void encode(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object o = this.get();
        if (o != null) {
            if (o instanceof Element) {
                this.encodeReference(document, node, referenceGenerator, (Element)o);
            } else {
                this.encodeObject(document, node, storer, referenceGenerator);
            }
        }
    }

    public final AppletXmlStruct encodeToXml(ReferenceGenerator referenceGenerator) throws IOException {
        Object o = this.get();
        if (o != null) {
            if (o instanceof Element) {
                return this.encodeReferenceToXml(referenceGenerator, (Element)o);
            }
            return this.encodeObjectToXml(referenceGenerator);
        }
        return new AppletXmlStruct();
    }

    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
    }

    public boolean isDeprecated() {
        return this.m_isDeprecated;
    }

    public void deprecate() {
        this.m_isDeprecated = true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[name=" + this.m_name + ",owner=" + this.m_owner + "]";
    }
}

