/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;

public abstract class TextFieldEditablePropertyViewController
extends PropertyViewController {
    protected JTextField textField = new JTextField();
    protected FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent ev) {
            TextFieldEditablePropertyViewController.this.stopEditing();
        }
    };
    protected boolean allowEasyEditWithClick = true;

    public TextFieldEditablePropertyViewController() {
        this.textField.setColumns(5);
        this.textField.setMinimumSize(new Dimension(80, 18));
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                TextFieldEditablePropertyViewController.this.stopEditing();
                TextFieldEditablePropertyViewController.this.popupButton.requestFocus();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 27) {
                    ev.consume();
                    TextFieldEditablePropertyViewController.this.cancelEditing();
                    TextFieldEditablePropertyViewController.this.popupButton.requestFocus();
                }
            }
        });
    }

    public void set(Property property, boolean includeDefaults, boolean allowExpressions, boolean includeOther, boolean omitPropertyName, PopupItemFactory factory) {
        super.set(property, includeDefaults, allowExpressions, includeOther, omitPropertyName, factory);
    }

    protected MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                if (TextFieldEditablePropertyViewController.this.allowEasyEditWithClick && (TextFieldEditablePropertyViewController.this.isAncestorOf(TextFieldEditablePropertyViewController.this.getNativeComponent()) || TextFieldEditablePropertyViewController.this.property.get() == null)) {
                    TextFieldEditablePropertyViewController.this.editValue();
                } else {
                    TextFieldEditablePropertyViewController.this.popupButton.doClick();
                }
            }
        };
    }

    public void editValue() {
        if (this.editingEnabled) {
            if (this.property.getValue() != null) {
                String propertyKey = "edu.cmu.cs.stage3.alice.authoringtool.userRepr." + this.property.getName();
                Object userRepr = this.property.getOwner().data.get(propertyKey);
                if (userRepr instanceof String) {
                    this.textField.setText((String)userRepr);
                } else {
                    this.textField.setText(this.property.getValue().toString());
                }
            }
            if (this.isAncestorOf(this.getNativeComponent())) {
                this.remove(this.getNativeComponent());
            } else if (this.isAncestorOf(this.expressionLabel)) {
                this.remove(this.expressionLabel);
            }
            if (!this.isAncestorOf(this.textField)) {
                this.add((Component)this.textField, "Center");
            }
            this.revalidate();
            this.textField.requestFocus();
            this.textField.addFocusListener(this.focusListener);
            this.textField.selectAll();
        }
    }

    public void stopEditing() {
        this.textField.removeFocusListener(this.focusListener);
        String valueString = this.textField.getText();
        this.remove(this.textField);
        this.add(this.getNativeComponent(), "Center");
        this.getNativeComponent().requestFocus();
        this.setValueFromString(valueString);
        this.refreshGUI();
    }

    public void cancelEditing() {
        this.textField.removeFocusListener(this.focusListener);
        this.remove(this.textField);
        this.add(this.getNativeComponent(), "Center");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        if (this.isAncestorOf(this.textField)) {
            this.remove(this.textField);
        }
        super.refreshGUI();
    }

    protected abstract void setValueFromString(String var1);
}

