/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.TextFieldEditablePropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;

public class NumberPropertyViewController
extends TextFieldEditablePropertyViewController {
    protected JLabel numberLabel = new JLabel();

    public void set(Property property, boolean includeDefaults, boolean allowExpressions, boolean omitPropertyName, PopupItemFactory factory) {
        super.set(property, includeDefaults, allowExpressions, true, omitPropertyName, factory);
        this.allowEasyEditWithClick = false;
        this.refreshGUI();
    }

    protected void setValueFromString(String valueString) {
        Double value = AuthoringToolResources.parseDouble(valueString);
        if (value != null) {
            ((Runnable)this.factory.createItem(value)).run();
            String propertyKey = "edu.cmu.cs.stage3.alice.authoringtool.userRepr." + this.property.getName();
            this.property.getOwner().data.put(propertyKey, valueString);
        } else {
            AuthoringTool.showErrorDialog("I don't understand this number: " + valueString, null, false);
        }
    }

    protected Component getNativeComponent() {
        return this.numberLabel;
    }

    protected MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mouseReleased(MouseEvent ev) {
                if (ev.getX() >= 0 && ev.getX() < ev.getComponent().getWidth() && ev.getY() >= 0 && ev.getY() < ev.getComponent().getHeight() && NumberPropertyViewController.this.isEnabled()) {
                    NumberPropertyViewController.this.popupButton.doClick();
                }
            }
        };
    }

    protected Class getNativeClass() {
        return Number.class;
    }

    protected void updateNativeComponent() {
        this.numberLabel.setText(AuthoringToolResources.getReprForValue(this.property.get(), this.property, this.property.getOwner().data));
    }

    protected void refreshGUI() {
        if (this.isAncestorOf(this.textField)) {
            this.remove(this.textField);
        }
        super.refreshGUI();
    }
}

