/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class FontPropertyViewController
extends JButton
implements GUIElement,
Releasable {
    protected Property property;
    protected boolean omitPropertyName;
    protected PropertyListener propertyListener = new PropertyListener(){

        public void propertyChanging(PropertyEvent ev) {
        }

        public void propertyChanged(PropertyEvent ev) {
            FontPropertyViewController.this.refreshGUI();
        }
    };

    public FontPropertyViewController() {
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
            }
        });
    }

    public void set(Property property, boolean omitPropertyName) {
        this.clean();
        this.property = property;
        this.omitPropertyName = omitPropertyName;
        this.setBackground(AuthoringToolResources.getColor("propertyViewControllerBackground"));
        this.setMargin(new Insets(0, 4, 0, 4));
        this.startListening();
        this.refreshGUI();
    }

    public void goToSleep() {
        this.stopListening();
    }

    public void wakeUp() {
        this.startListening();
    }

    public void clean() {
        this.stopListening();
    }

    public void die() {
        this.stopListening();
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }

    public void startListening() {
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
        }
    }

    public void stopListening() {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
        }
    }

    protected void refreshGUI() {
        Object value = this.property.get();
        StringBuffer repr = new StringBuffer();
        if (!this.omitPropertyName) {
            repr.append(String.valueOf(AuthoringToolResources.getReprForValue(this.property)) + " = ");
        }
        if (value instanceof Expression) {
            repr.append(AuthoringToolResources.getNameInContext((Element)value, this.property.getOwner()));
        } else if (value == null) {
            repr.append("<None>");
        } else if (value instanceof Font) {
            Font font = (Font)value;
            repr.append(font.getFontName());
        } else {
            throw new RuntimeException("Bad value: " + value);
        }
        this.setText(repr.toString());
        this.revalidate();
        this.repaint();
    }
}

