/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.CheckForValidityCallback;
import edu.cmu.cs.stage3.alice.core.Element;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NameTextField
extends JTextField {
    private CheckForValidityCallback okButtonCallback;
    private Element m_parent;

    public NameTextField(CheckForValidityCallback okButtonCallback) {
        this.okButtonCallback = okButtonCallback;
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                NameTextField.this.refresh();
            }

            public void insertUpdate(DocumentEvent e) {
                NameTextField.this.refresh();
            }

            public void removeUpdate(DocumentEvent e) {
                NameTextField.this.refresh();
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                NameTextField.this.textFieldAction();
            }
        });
    }

    public void setParent(Element parent) {
        this.m_parent = parent;
        this.refresh();
    }

    private void textFieldAction() {
        this.okButtonCallback.doAction();
    }

    private boolean isNameValid() {
        String name;
        return this.m_parent != null && Element.isPotentialNameValid(name = this.getText()) && this.m_parent.getChildNamedIgnoreCase(name) == null;
    }

    private void refresh() {
        if (this.isNameValid()) {
            this.okButtonCallback.setValidity(this, true);
            this.setForeground(Color.black);
        } else {
            this.okButtonCallback.setValidity(this, false);
            this.setForeground(Color.red);
        }
    }
}

