/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.util.ArrayList;

public class MultiColumnPopupLayout
implements LayoutManager {
    protected Dimension screenSize;

    protected void updateInfo() {
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.screenSize.height -= 28;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container parent) {
        this.updateInfo();
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int count = parent.getComponentCount();
            int numCols = 1;
            int totalWidth = 0;
            int totalHeight = 0;
            int heightSoFar = 0;
            int maxWidth = 0;
            int i = 0;
            while (i < count) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                maxWidth = Math.max(maxWidth, d.width);
                if ((heightSoFar += d.height) > this.screenSize.height) {
                    ++numCols;
                    totalHeight = Math.max(totalHeight, heightSoFar - d.height);
                    heightSoFar = d.height;
                }
                ++i;
            }
            if (totalHeight == 0) {
                totalHeight = heightSoFar;
            }
            Dimension d = new Dimension(insets.left + insets.right + (totalWidth += (maxWidth + 1) * numCols - 1), insets.top + insets.bottom + totalHeight);
            return d;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Dimension parentSize = parent.getSize();
            int count = parent.getComponentCount();
            int x = insets.left;
            int y = insets.top;
            int w = 0;
            int h = 0;
            int widthThisColumn = 0;
            int heightSoFar = 0;
            ArrayList<Component> oneColumn = new ArrayList<Component>();
            int i = 0;
            while (i < count) {
                Component comp = parent.getComponent(i);
                Dimension d = comp.getPreferredSize();
                if ((heightSoFar += d.height) > parentSize.height && !oneColumn.isEmpty()) {
                    w = widthThisColumn;
                    for (Component c : oneColumn) {
                        h = c.getPreferredSize().height;
                        c.setBounds(x, y, w, h);
                        y += h;
                    }
                    oneColumn.clear();
                    x += widthThisColumn + 1;
                    y = insets.top;
                    w = 0;
                    h = 0;
                    heightSoFar = d.height;
                    widthThisColumn = 0;
                }
                oneColumn.add(comp);
                widthThisColumn = Math.max(widthThisColumn, d.width);
                ++i;
            }
            if (!oneColumn.isEmpty()) {
                w = widthThisColumn;
                for (Component c : oneColumn) {
                    h = c.getPreferredSize().height;
                    c.setBounds(x, y, w, h);
                    y += h;
                }
            }
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }
}

