/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.ForEach;
import edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.ForEachInOrder;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.util.Arrays;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Vector;

public class ElementPrototype {
    protected Class elementClass;
    protected StringObjectPair[] knownPropertyValues;
    protected String[] desiredProperties;

    public ElementPrototype(Class elementClass, StringObjectPair[] knownPropertyValues, String[] desiredProperties) {
        if (!Element.class.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("The elementClass given is not actually a subclass of Element.");
        }
        Element testElement = null;
        try {
            testElement = (Element)elementClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to create a new element of type: " + elementClass.getName());
        }
        if (!CallToUserDefinedResponse.class.isAssignableFrom(elementClass) && !CallToUserDefinedQuestion.class.isAssignableFrom(elementClass)) {
            int n;
            int n2;
            Object[] objectArray;
            if (knownPropertyValues != null) {
                objectArray = knownPropertyValues;
                n2 = 0;
                n = objectArray.length;
                while (n2 < n) {
                    Object knownPropertyValue = objectArray[n2];
                    String propertyName = ((StringObjectPair)knownPropertyValue).getString();
                    Object propertyValue = ((StringObjectPair)knownPropertyValue).getObject();
                    Property property = testElement.getPropertyNamed(propertyName);
                    if (property == null) {
                        throw new IllegalArgumentException("property named " + propertyName + " does not exist in " + elementClass.getName());
                    }
                    if (propertyValue != null) {
                        if (propertyValue instanceof Expression) {
                            property.getValueClass();
                            if (!property.getValueClass().isAssignableFrom(propertyValue.getClass()) && !property.getValueClass().isAssignableFrom(((Expression)propertyValue).getValueClass())) {
                                throw new IllegalArgumentException("property named " + propertyName + " in class " + elementClass.getName() + " does not accept expressions of type " + ((Expression)propertyValue).getValueClass().getName());
                            }
                        } else if (!property.getValueClass().isAssignableFrom(propertyValue.getClass())) {
                            throw new IllegalArgumentException("property named " + propertyName + " in class " + elementClass.getName() + " does not accept values of type " + propertyValue.getClass().getName() + "; bad value: " + propertyValue);
                        }
                    }
                    ++n2;
                }
            } else {
                knownPropertyValues = new StringObjectPair[]{};
            }
            if (desiredProperties != null) {
                objectArray = desiredProperties;
                n2 = 0;
                n = objectArray.length;
                while (n2 < n) {
                    Object desiredPropertie = objectArray[n2];
                    Property property = testElement.getPropertyNamed((String)desiredPropertie);
                    if (property == null) {
                        throw new IllegalArgumentException("property named " + (String)desiredPropertie + " does not exist in " + elementClass.getName());
                    }
                    ++n2;
                }
            } else {
                desiredProperties = new String[]{};
            }
        }
        this.elementClass = elementClass;
        this.knownPropertyValues = knownPropertyValues;
        this.desiredProperties = desiredProperties;
    }

    public Element createNewElement() {
        try {
            Code loopN;
            Element element = (Element)this.elementClass.newInstance();
            if (this.knownPropertyValues != null) {
                StringObjectPair[] stringObjectPairArray = this.knownPropertyValues;
                int n = 0;
                int n2 = stringObjectPairArray.length;
                while (n < n2) {
                    Element e;
                    StringObjectPair knownPropertyValue = stringObjectPairArray[n];
                    String propertyName = knownPropertyValue.getString();
                    Object propertyValue = knownPropertyValue.getObject();
                    Property property = element.getPropertyNamed(propertyName);
                    property.set(propertyValue);
                    if (propertyValue instanceof PropertyValue) {
                        PropertyValue propertyValueQuestion = (PropertyValue)propertyValue;
                        propertyValueQuestion.removeFromParent();
                        property.getOwner().addChild(propertyValueQuestion);
                    } else if (propertyValue instanceof Question) {
                        Question q = (Question)propertyValue;
                        q.removeFromParent();
                        property.getOwner().addChild(q);
                        q.data.put("associatedProperty", property.getName());
                    }
                    if (propertyValue instanceof Element && (e = (Element)propertyValue).getParent() == null && !(e instanceof World)) {
                        property.getOwner().addChild(e);
                        e.data.put("associatedProperty", property.getName());
                    }
                    ++n;
                }
            }
            if (edu.cmu.cs.stage3.alice.core.response.ForEach.class.isAssignableFrom(this.elementClass)) {
                ForEachInOrder forResponse = null;
                if (ForEachInOrder.class.isAssignableFrom(this.elementClass)) {
                    forResponse = (ForEachInOrder)element;
                }
                Variable eachVar = new Variable();
                eachVar.name.set("item");
                eachVar.valueClass.set(Object.class);
                if (forResponse != null) {
                    forResponse.addChild(eachVar);
                    forResponse.each.set(eachVar);
                }
            } else if (ForEach.class.isAssignableFrom(this.elementClass)) {
                ForEach forQuestion = (ForEach)element;
                Variable eachVar = new Variable();
                eachVar.name.set("item");
                eachVar.valueClass.set(Object.class);
                forQuestion.addChild(eachVar);
                forQuestion.each.set(eachVar);
            } else if (LoopNInOrder.class.isAssignableFrom(this.elementClass)) {
                loopN = (LoopNInOrder)element;
                Variable indexVar = new Variable();
                indexVar.name.set("index");
                indexVar.valueClass.set(Number.class);
                loopN.addChild(indexVar);
                ((LoopNInOrder)loopN).index.set(indexVar);
            } else if (LoopN.class.isAssignableFrom(this.elementClass)) {
                loopN = (LoopN)element;
                Variable indexVar = new Variable();
                indexVar.name.set("index");
                indexVar.valueClass.set(Number.class);
                loopN.addChild(indexVar);
                ((LoopN)loopN).index.set(indexVar);
            }
            return element;
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog("Error creating new element.", e);
            return null;
        }
    }

    public ElementPrototype createCopy(StringObjectPair newKnownPropertyValue) {
        return this.createCopy(new StringObjectPair[]{newKnownPropertyValue});
    }

    public ElementPrototype createCopy(StringObjectPair[] newKnownPropertyValues) {
        Vector<StringObjectPair> vKnownPropertyValues = new Vector<StringObjectPair>((Collection)Arrays.asList(this.knownPropertyValues));
        Vector vDesiredProperties = new Vector(Arrays.asList(this.desiredProperties));
        if (newKnownPropertyValues != null) {
            StringObjectPair[] stringObjectPairArray = newKnownPropertyValues;
            int n = 0;
            int n2 = stringObjectPairArray.length;
            while (n < n2) {
                StringObjectPair newKnownPropertyValue = stringObjectPairArray[n];
                if (vDesiredProperties.contains(newKnownPropertyValue.getString())) {
                    vDesiredProperties.remove(newKnownPropertyValue.getString());
                }
                boolean subbed = false;
                ListIterator<StringObjectPair> iter = vKnownPropertyValues.listIterator();
                while (iter.hasNext()) {
                    StringObjectPair pair = (StringObjectPair)iter.next();
                    if (!pair.getString().equals(newKnownPropertyValue.getString())) continue;
                    iter.set(newKnownPropertyValue);
                    subbed = true;
                }
                if (!subbed) {
                    vKnownPropertyValues.add(newKnownPropertyValue);
                }
                ++n;
            }
        }
        return this.createInstance(this.elementClass, vKnownPropertyValues.toArray(new StringObjectPair[0]), vDesiredProperties.toArray(new String[0]));
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public StringObjectPair[] getKnownPropertyValues() {
        return this.knownPropertyValues;
    }

    public String[] getDesiredProperties() {
        return this.desiredProperties;
    }

    protected ElementPrototype createInstance(Class elementClass, StringObjectPair[] knownPropertyValues, String[] desiredProperties) {
        return new ElementPrototype(elementClass, knownPropertyValues, desiredProperties);
    }

    public String toString() {
        int n;
        int n2;
        Object[] objectArray;
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().getName()) + "[ ");
        sb.append("elementClass = " + this.elementClass.getName() + ", ");
        sb.append("knownPropertyValues = [ ");
        if (this.knownPropertyValues != null) {
            objectArray = this.knownPropertyValues;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                StringObjectPair knownPropertyValue = objectArray[n2];
                sb.append("StringObjectPair( ");
                sb.append(String.valueOf(knownPropertyValue.getString()) + ", ");
                sb.append(String.valueOf(knownPropertyValue.getObject().toString()) + ", ");
                sb.append("), ");
                ++n2;
            }
        } else {
            sb.append("<null>");
        }
        sb.append(" ], ");
        sb.append("desiredProperties = [ ");
        if (this.desiredProperties != null) {
            objectArray = this.desiredProperties;
            n2 = 0;
            n = objectArray.length;
            while (n2 < n) {
                Object desiredPropertie = objectArray[n2];
                sb.append(String.valueOf(desiredPropertie) + ", ");
                ++n2;
            }
        } else {
            sb.append("<null>");
        }
        sb.append(" ], ]");
        return sb.toString();
    }
}

