/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.EditorPanelEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.EditorPanelListener;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JPanel;

public class EditorPanel
extends JPanel
implements AuthoringToolStateListener {
    protected Editor activeEditor = null;
    protected Method activeEditorSetMethod = null;
    protected HashMap cachedEditors = new HashMap();
    protected EditStack editStack = new EditStack();
    protected HashSet listenerSet = new HashSet();
    protected AuthoringTool authoringTool;
    protected final ChildrenListener deletionListener = new ChildrenListener(){

        public void childrenChanging(ChildrenEvent ev) {
        }

        public void childrenChanged(ChildrenEvent ev) {
            if (ev.getChangeType() == 3 && ev.getChild() == EditorPanel.this.getElementBeingEdited()) {
                EditorPanel.this.editElement(null);
                ev.getParent().removeChildrenListener(this);
            }
        }
    };
    public final AbstractAction backAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            EditorPanel.this.back();
        }
    };
    public final AbstractAction forwardAction = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
            EditorPanel.this.forward();
        }
    };

    public Editor loadEditor(Class editorClass) {
        Editor editor = null;
        if (editorClass != null && (editor = (Editor)this.cachedEditors.get(editorClass)) == null) {
            try {
                editor = EditorUtilities.getEditorFromClass(editorClass);
                if (editor == null) {
                    AuthoringTool.showErrorDialog("Can't create editor of type " + editorClass.getName(), null);
                } else {
                    this.cachedEditors.put(editorClass, editor);
                    this.authoringTool.addAuthoringToolStateListener(editor);
                    editor.setAuthoringTool(this.authoringTool);
                }
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error creating editor for type " + editorClass.getName(), t);
            }
        }
        return editor;
    }

    public void editElement(Element element) {
        this.editElement(element, true);
    }

    protected void editElement(Element element, boolean performPush) {
        if (element == null) {
            this.editElement(null, null, performPush);
        } else {
            Class bestEditorClass = EditorUtilities.getBestEditor(element.getClass());
            if (bestEditorClass == null) {
                AuthoringTool.showErrorDialog("No editor found for " + element.getClass(), null);
            }
            this.editElement(element, bestEditorClass, performPush);
        }
    }

    protected void editElement(Element element, Class editorClass, boolean performPush) {
        EditorPanelEvent ev;
        Iterator iter;
        Editor editor;
        if (this.getElementBeingEdited() != null && this.getElementBeingEdited().getParent() != null) {
            this.getElementBeingEdited().getParent().removeChildrenListener(this.deletionListener);
        }
        if (this.activeEditor != (editor = this.loadEditor(editorClass))) {
            if (this.activeEditor != null) {
                try {
                    this.activeEditorSetMethod.invoke((Object)this.activeEditor, new Object[1]);
                }
                catch (InvocationTargetException ite) {
                    AuthoringTool.showErrorDialog("Error cleaning editor.", ite);
                }
                catch (IllegalAccessException iae) {
                    AuthoringTool.showErrorDialog("Error cleaning editor.", iae);
                }
            }
            this.removeAll();
            this.activeEditor = editor;
            if (this.activeEditor != null) {
                this.activeEditorSetMethod = EditorUtilities.getSetMethodFromClass(editorClass);
                this.add("Center", this.activeEditor.getJComponent());
            } else {
                this.activeEditorSetMethod = null;
                iter = this.listenerSet.iterator();
                while (iter.hasNext()) {
                    ev = new EditorPanelEvent(null);
                    ((EditorPanelListener)iter.next()).elementChanged(ev);
                }
            }
            this.revalidate();
            this.repaint();
        }
        if (this.activeEditor != null && this.activeEditor.getObject() != element) {
            try {
                this.activeEditorSetMethod.invoke((Object)this.activeEditor, element);
                if (performPush && element != null) {
                    this.editStack.push(new EditItem(element, editorClass));
                    this.updateActions();
                }
                iter = this.listenerSet.iterator();
                while (iter.hasNext()) {
                    ev = new EditorPanelEvent(element);
                    ((EditorPanelListener)iter.next()).elementChanged(ev);
                }
                if (element != null && element.getParent() != null) {
                    element.getParent().addChildrenListener(this.deletionListener);
                }
            }
            catch (InvocationTargetException ite) {
                AuthoringTool.showErrorDialog("Error intializing editor.", ite);
            }
            catch (IllegalAccessException iae) {
                AuthoringTool.showErrorDialog("Error intializing editor.", iae);
            }
        }
    }

    public Element getElementBeingEdited() {
        if (this.activeEditor != null) {
            return (Element)this.activeEditor.getObject();
        }
        return null;
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public void back() {
        this.editStack.undo();
        this.updateActions();
    }

    public void forward() {
        this.editStack.redo();
        this.updateActions();
    }

    public boolean canGoBack() {
        return this.editStack.getCurrentUndoableRedoableIndex() > 0;
    }

    public boolean canGoForward() {
        return this.editStack.getCurrentUndoableRedoableIndex() != this.editStack.size() - 1;
    }

    protected void updateActions() {
        this.backAction.setEnabled(this.canGoBack());
        this.forwardAction.setEnabled(this.canGoForward());
    }

    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
        this.editStack.clear();
    }

    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }

    class EditStack
    extends DefaultUndoRedoStack {
        EditStack() {
        }

        public UndoableRedoable undo() {
            UndoableRedoable ur = super.undo();
            UndoableRedoable newItem = EditorPanel.this.editStack.getCurrentUndoableRedoable();
            if (ur != null) {
                EditorPanel.this.editElement(((EditItem)newItem).getElement(), ((EditItem)newItem).getEditorClass(), false);
            }
            return ur;
        }

        public UndoableRedoable redo() {
            UndoableRedoable ur = super.redo();
            if (ur != null) {
                EditorPanel.this.editElement(((EditItem)ur).getElement(), ((EditItem)ur).getEditorClass(), false);
            }
            return ur;
        }
    }

    class EditItem
    implements UndoableRedoable {
        protected Element element;
        protected Class editorClass;

        public EditItem(Element element, Class editorClass) {
            this.element = element;
            this.editorClass = editorClass;
        }

        public void undo() {
        }

        public void redo() {
        }

        public Object getAffectedObject() {
            return this.element;
        }

        public Object getContext() {
            return EditorPanel.this;
        }

        public Element getElement() {
            return this.element;
        }

        public Class getEditorClass() {
            return this.editorClass;
        }
    }
}

