/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class AliceTabbedPaneUI
extends MetalTabbedPaneUI {
    protected Color defaultTabForeground;

    public AliceTabbedPaneUI() {
        this.setTabAreaInsets(new Insets(0, 0, 0, 0));
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectColor = Color.white;
        this.selectHighlight = Color.black;
        this.tabAreaBackground = Color.white;
        this.darkShadow = Color.black;
        this.focus = new Color(255, 255, 255, 0);
        this.highlight = Color.darkGray;
        this.contentBorderInsets = new Insets(1, 1, 1, 1);
        this.defaultTabForeground = UIManager.getColor("TabbedPane.foreground");
    }

    public void setTabAreaInsets(Insets insets) {
        this.tabAreaInsets = insets;
    }

    public void update(Graphics g, JComponent c) {
        int tabPlacement = this.tabPane.getTabPlacement();
        Insets insets = c.getInsets();
        Dimension size = c.getSize();
        Component selectedComponent = this.tabPane.getSelectedComponent();
        if (selectedComponent != null) {
            this.selectColor = this.tabAreaBackground = selectedComponent.getBackground();
        }
        g.setColor(this.tabAreaBackground);
        int tabAreaHeight = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
        g.fillRect(insets.left, insets.top + tabAreaHeight, size.width - insets.right - insets.left, size.height - tabAreaHeight);
        this.paint(g, c);
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        if (isSelected && this.tabPane.getSelectedComponent() != null) {
            Color background = this.tabPane.getSelectedComponent().getBackground();
            int brightness = (background.getRed() + background.getGreen() + background.getBlue()) / 3;
            if (brightness < 128) {
                if (!this.tabPane.getForegroundAt(tabIndex).equals(Color.white)) {
                    this.tabPane.setForegroundAt(tabIndex, Color.white);
                }
            } else if (!this.tabPane.getForegroundAt(tabIndex).equals(this.defaultTabForeground)) {
                this.tabPane.setForegroundAt(tabIndex, null);
            }
        } else if (!this.tabPane.getForegroundAt(tabIndex).equals(this.defaultTabForeground)) {
            this.tabPane.setForegroundAt(tabIndex, null);
        }
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        font = isSelected ? font.deriveFont(1) : font.deriveFont(0, 12.0f);
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        this.paintFocusIndicator(g, tabPlacement, rects, tabIndex, iconRect, textRect, isSelected);
    }

    public int getTabAreaHeight() {
        Insets tabAreaInsets = this.getTabAreaInsets(this.tabPane.getTabPlacement());
        int runCount = this.tabPane.getTabRunCount();
        int tabRunOverlay = this.getTabRunOverlay(this.tabPane.getTabPlacement());
        return runCount > 0 ? runCount * (this.maxTabHeight - tabRunOverlay) + tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom : 0;
    }

    public int getTabAreaHeightIgnoringInsets() {
        int runCount = this.tabPane.getTabRunCount();
        int tabRunOverlay = this.getTabRunOverlay(this.tabPane.getTabPlacement());
        return runCount > 0 ? runCount * (this.maxTabHeight - tabRunOverlay) + tabRunOverlay : 0;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont().deriveFont(1);
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
}

