/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.AlicePopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class AliceMenuItemUI
extends BasicMenuItemUI {
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            Vector<JMenuItem> path = new Vector<JMenuItem>();
            MenuElement me = this.menuItem;
            while (me instanceof MenuElement) {
                Component o;
                path.add(0, (JMenuItem)me);
                if (me instanceof JPopupMenu) {
                    o = ((JPopupMenu)me).getInvoker();
                    if (o instanceof MenuElement && o != me) {
                        me = (MenuElement)((Object)o);
                        continue;
                    }
                    me = null;
                    continue;
                }
                if (me instanceof JMenuItem) {
                    o = me.getParent();
                    if (o instanceof MenuElement && o != me) {
                        me = (MenuElement)((Object)o);
                        continue;
                    }
                    me = null;
                    continue;
                }
                me = null;
            }
            newPath = path.toArray(new MenuElement[0]);
        }
        return newPath;
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < AliceMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < AliceMenuItemUI.this.menuItem.getHeight()) {
                MenuElement[] path = AliceMenuItemUI.this.getPath();
                manager.clearSelectedPath();
                AliceMenuItemUI.this.menuItem.doClick(0);
                MenuElement[] menuElementArray = path;
                int n = 0;
                int n2 = menuElementArray.length;
                while (n < n2) {
                    MenuElement element = menuElementArray[n];
                    if (element instanceof AlicePopupMenu) {
                        ((AlicePopupMenu)element).setVisible(false);
                    }
                    ++n;
                }
            } else {
                manager.processMouseEvent(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(AliceMenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int i = 0;
                    int c = path.length - 1;
                    while (i < c) {
                        newPath[i] = path[i];
                        ++i;
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

