/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.variablegroupeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.NewVariableContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElementContainerListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.VariableGUI;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VariableGroupEditor
extends JPanel
implements ObjectArrayPropertyListener,
DropTargetListener {
    protected ObjectArrayProperty variables;
    protected JButton newVariableButton = new JButton("new global variable");
    protected NewVariableContentPane newVariableDialog;
    protected AuthoringTool authoringTool;
    protected int lineLocation = -1;
    protected int variablePosition = 0;

    public VariableGroupEditor() {
        this.guiInit();
    }

    private void guiInit() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.newVariableButton.setBackground(new Color(240, 240, 255));
        this.newVariableButton.setMargin(new Insets(2, 4, 2, 4));
        this.newVariableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Variable variable;
                if (VariableGroupEditor.this.authoringTool != null && (variable = VariableGroupEditor.this.authoringTool.showNewVariableDialog("create new variable", VariableGroupEditor.this.variables.getOwner())) != null) {
                    VariableGroupEditor.this.authoringTool.getUndoRedoStack().startCompound();
                    try {
                        VariableGroupEditor.this.variables.getOwner().addChild(variable);
                        VariableGroupEditor.this.variables.add(variable);
                    }
                    finally {
                        VariableGroupEditor.this.authoringTool.getUndoRedoStack().stopCompound();
                    }
                }
            }
        });
        this.addContainerListener(GUIElementContainerListener.getStaticListener());
        this.setDropTarget(new DropTarget(this, this));
        this.newVariableButton.setToolTipText("<html><font face=arial size=-1>Open New Variable Dialog.<p><p>Variables allow you to store information.<p>You may choose among several types<p>of information (like Numbers, Booleans, and Objects).</font></html>");
        this.refreshGUI();
    }

    public JComponent getJComponent() {
        return this;
    }

    public void setVariableObjectArrayProperty(ObjectArrayProperty variables) {
        if (this.variables != null) {
            this.variables.removeObjectArrayPropertyListener(this);
        }
        this.variables = variables;
        if (this.variables != null) {
            this.variables.addObjectArrayPropertyListener(this);
        }
        this.refreshGUI();
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public JButton getNewVariableButton() {
        return this.newVariableButton;
    }

    public void refreshGUI() {
        this.removeAll();
        if (this.variables != null) {
            int count = 0;
            int i = 0;
            while (i < this.variables.size()) {
                if (this.variables.get(i) instanceof Variable) {
                    SetPropertyImmediatelyFactory factory;
                    Variable variable = (Variable)this.variables.get(i);
                    VariableGUI gui = GUIFactory.getVariableGUI(variable, true, factory = new SetPropertyImmediatelyFactory(variable.value));
                    if (gui != null) {
                        this.add((Component)gui, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                    } else {
                        AuthoringTool.showErrorDialog("Unable to create gui for variable: " + variable, null);
                    }
                }
                ++i;
            }
            this.add((Component)this.newVariableButton, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 2, 8, 2), 0, 0));
            this.newVariableButton.setDropTarget(new DropTarget(this.newVariableButton, this));
            Component glue = Box.createGlue();
            this.add(glue, new GridBagConstraints(0, count++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
            glue.setDropTarget(new DropTarget(glue, this));
        }
        this.revalidate();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.lineLocation > -1) {
            Rectangle bounds = this.getBounds();
            g.setColor(Color.black);
            g.fillRect(0, this.lineLocation, bounds.width, 2);
        }
    }

    protected void calculateLineLocation(int mouseY) {
        int numSpots = this.variables.size() + 1;
        int[] spots = new int[numSpots];
        spots[0] = 0;
        int i = 1;
        while (i < numSpots) {
            Component c = this.getComponent(i - 1);
            spots[i] = c.getBounds().y + c.getBounds().height + 1;
            ++i;
        }
        int closestSpot = -1;
        int minDist = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < numSpots) {
            int d = Math.abs(mouseY - spots[i2]);
            if (d < minDist) {
                minDist = d;
                closestSpot = i2;
            }
            ++i2;
        }
        this.variablePosition = closestSpot;
        this.lineLocation = spots[closestSpot];
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.variableReferenceFlavor)) {
            dtde.acceptDrag(2);
            int mouseY = SwingUtilities.convertPoint((Component)dtde.getDropTargetContext().getComponent(), (Point)dtde.getLocation(), (Component)this).y;
            this.calculateLineLocation(mouseY);
        } else {
            this.lineLocation = -1;
            dtde.rejectDrag();
        }
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.variableReferenceFlavor)) {
            dtde.acceptDrag(2);
            int mouseY = SwingUtilities.convertPoint((Component)dtde.getDropTargetContext().getComponent(), (Point)dtde.getLocation(), (Component)this).y;
            this.calculateLineLocation(mouseY);
        } else {
            this.lineLocation = -1;
            dtde.rejectDrag();
        }
        this.repaint();
    }

    public void drop(DropTargetDropEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.variableReferenceFlavor)) {
            dtde.acceptDrop(2);
            try {
                Variable variable = (Variable)transferable.getTransferData(ElementReferenceTransferable.variableReferenceFlavor);
                if (this.variables.contains(variable)) {
                    if (this.variablePosition > this.variables.indexOf(variable)) {
                        --this.variablePosition;
                    }
                    this.variables.remove(variable);
                }
                this.variables.add(this.variablePosition, variable);
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
                dtde.dropComplete(false);
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
                dtde.dropComplete(false);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Drop didn't work.", t);
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        this.lineLocation = -1;
        this.repaint();
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.variableReferenceFlavor)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dte) {
        this.lineLocation = -1;
        this.repaint();
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
        this.refreshGUI();
    }

    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }
}

