/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.ComponentElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeComponentOwner;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.InsertPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.MainCompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElementContainerListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.ForEach;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class CompositeComponentElementPanel
extends GroupingPanel
implements ObjectArrayPropertyListener,
PopupMenuListener {
    protected final boolean USE_DEPTH = false;
    protected static Vector timers = new Vector();
    protected static boolean shouldReact = true;
    public static final int LEFT_INDENT = 15;
    public static final int RIGHT_INDENT = 5;
    public static final int STRUT_SIZE = 8;
    public static final int SCROLL_SIZE = 8;
    public static int SCROLL_AMOUNT = 3;
    public static final int SCROLL_DELTA = 1;
    public static final int SCROLL_START = 3;
    public static final int MAX_SCROLL = 10;
    public ObjectArrayProperty componentElements;
    public CompositeComponentOwner m_owner;
    protected boolean HACK_started = false;
    protected JScrollPane topLevelScrollPane;
    protected boolean inserting = false;
    protected boolean insertingElement = false;
    private boolean invalidEvent = false;
    protected InsertPanel insertPanel;
    protected GridBagLayout panelLayout;
    protected GridBagConstraints panelConstraints;
    protected Component glue;
    protected Component strut;
    protected Insets insets = new Insets(3, 2, 0, 2);
    protected int dropPanelPosition = -2;
    protected static CompositeComponentElementPanel s_currentComponentPanel;
    protected static Component s_componentPanelMoved;
    protected int dropPanelLocation = -2;
    protected int m_depth = -1;
    protected int lineLocation = -1;
    protected int oldLineLocation = -1;
    protected int insertLocation = -1;
    protected static boolean showDropPanel;
    protected boolean shouldDrawLine = false;
    protected ContainerAdapter containerAdapter;
    protected Timer HACK_timer;
    protected Timer lingerTimer;
    protected Timer insertTimer;
    protected AuthoringTool authoringTool;
    private static Container s_prevContainer;
    private static Rectangle s_prevRect;

    static {
        showDropPanel = false;
    }

    public CompositeComponentElementPanel() {
        this.panelLayout = new GridBagLayout();
        this.panelConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, this.insets, 0, 0);
        this.setOpaque(true);
        this.setLayout(this.panelLayout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 5));
        this.glue = Box.createVerticalGlue();
        this.strut = Box.createVerticalStrut(8);
        this.insertPanel = new InsertPanel();
        this.HACK_timer = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CompositeComponentElementPanel.this.removeDropPanelFromCurrentComponent();
            }
        });
        this.HACK_timer.setRepeats(false);
        s_currentComponentPanel = this;
    }

    protected boolean isInverted() {
        return false;
    }

    protected void startListening() {
        if (this.componentElements != null) {
            this.componentElements.addObjectArrayPropertyListener(this);
        }
    }

    protected void stopListening() {
        if (this.componentElements != null) {
            this.componentElements.removeObjectArrayPropertyListener(this);
        }
    }

    protected void setTopLevelScrollPanel() {
        Container currentOwner = (Container)((Object)this.m_owner);
        while (!(currentOwner instanceof MainCompositeElementPanel) && currentOwner != null) {
            currentOwner = currentOwner.getParent();
        }
        if (currentOwner != null) {
            this.topLevelScrollPane = ((MainCompositeElementPanel)currentOwner).scrollPane;
        }
    }

    public void set(ObjectArrayProperty elements, CompositeComponentOwner owner, AuthoringTool authoringToolIn) {
        this.clean();
        this.authoringTool = authoringToolIn;
        this.componentElements = elements;
        this.clean();
        this.m_owner = owner;
        this.updateGUI();
        this.startListening();
    }

    public void setAuthoringTool(AuthoringTool authoringToolIn) {
        this.authoringTool = authoringToolIn;
    }

    public void setStrut(int size) {
        this.strut = Box.createVerticalStrut(size);
        this.clean();
        this.updateGUI();
        this.wakeUp();
    }

    public void goToSleep() {
        this.stopListening();
        this.HACK_timer.stop();
    }

    public void wakeUp() {
        this.startListening();
    }

    public void clean() {
        this.goToSleep();
    }

    public CompositeComponentOwner getOwner() {
        return this.m_owner;
    }

    public Element getElement() {
        return this.componentElements.getOwner();
    }

    protected static void stopAllTimers() {
        int i = 0;
        while (i < timers.size()) {
            Timer t = (Timer)timers.elementAt(i);
            t.stop();
            ++i;
        }
        timers.removeAllElements();
    }

    protected abstract Component makeGUI(Element var1);

    protected void updateGUI() {
        if (this.componentElements != null) {
            if (this.componentElements.size() > 0) {
                this.removeAll();
                this.resetGUI();
                int i = 0;
                while (i < this.componentElements.size()) {
                    Element currentElement = (Element)this.componentElements.getArrayValue()[i];
                    Component toAdd = this.makeGUI(currentElement);
                    if (toAdd != null) {
                        this.addElementPanel(toAdd, i);
                    }
                    ++i;
                }
            } else {
                this.addDropTrough();
            }
        } else if (this.m_owner != null) {
            this.m_owner.setEnabled(false);
        }
        this.revalidate();
        this.repaint();
    }

    protected void resetGUI() {
        if (this.getComponentCount() < 2) {
            this.removeAll();
            this.add(this.strut, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.glue, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    protected void addDropTrough() {
        if (this.componentElements != null && this.componentsIsEmpty()) {
            this.removeAll();
            this.panelConstraints.gridy = 0;
            this.add(this.insertPanel, this.panelConstraints, 0);
            this.add(this.strut, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.glue, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent propertyEvent) {
        this.invalidEvent = false;
        if (propertyEvent.getChangeType() == 1 && this.componentElements.get(propertyEvent.getNewIndex()) == propertyEvent.getItem()) {
            this.invalidEvent = true;
        }
        if (propertyEvent.getChangeType() == 2) {
            if (this.componentElements.get(propertyEvent.getNewIndex()) == propertyEvent.getItem()) {
                this.invalidEvent = true;
            }
            if (this.componentElements.get(propertyEvent.getOldIndex()) != propertyEvent.getItem()) {
                this.invalidEvent = true;
            }
        }
        if (propertyEvent.getChangeType() == 3 && this.componentElements.get(propertyEvent.getOldIndex()) != propertyEvent.getItem()) {
            this.invalidEvent = true;
        }
    }

    protected int getElementComponentCount() {
        int count = 0;
        int i = 0;
        while (i < this.getComponentCount()) {
            if (this.getComponent(i) instanceof CompositeElementPanel || this.getComponent(i) instanceof ComponentElementPanel) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    protected boolean checkGUI() {
        int elementCount;
        boolean aOkay;
        Component[] c = this.getComponents();
        Element[] elements = (Element[])this.componentElements.get();
        boolean bl = aOkay = elements.length == (elementCount = this.getElementComponentCount());
        if (aOkay) {
            int i = 0;
            while (i < elements.length) {
                if (c[i] instanceof CompositeElementPanel) {
                    if (i < elements.length) {
                        if (((CompositeElementPanel)c[i]).getElement() != elements[i]) {
                            aOkay = false;
                            break;
                        }
                    } else {
                        aOkay = false;
                        break;
                    }
                }
                if (c[i] instanceof ComponentElementPanel) {
                    if (i < elements.length) {
                        if (((ComponentElementPanel)c[i]).getElement() != elements[i]) {
                            aOkay = false;
                            break;
                        }
                    } else {
                        aOkay = false;
                        break;
                    }
                }
                ++i;
            }
        }
        return aOkay;
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent propertyEvent) {
        if (shouldReact && !this.invalidEvent) {
            boolean successful = true;
            Element eventElement = (Element)propertyEvent.getItem();
            int index = propertyEvent.getNewIndex();
            if (propertyEvent.getChangeType() == 1) {
                Component toInsert = s_componentPanelMoved;
                s_componentPanelMoved = null;
                boolean isCorrectPanel = false;
                if (toInsert == null) {
                    toInsert = this.makeGUI(eventElement);
                    isCorrectPanel = true;
                }
                if (toInsert instanceof CompositeElementPanel && !isCorrectPanel) {
                    if (((CompositeElementPanel)toInsert).getElement() == eventElement) {
                        isCorrectPanel = true;
                    }
                } else if (toInsert instanceof ComponentElementPanel && !isCorrectPanel && ((ComponentElementPanel)toInsert).getElement() == eventElement) {
                    isCorrectPanel = true;
                }
                if (!isCorrectPanel) {
                    toInsert = this.makeGUI(eventElement);
                }
                if (toInsert != null) {
                    this.addElementPanel(toInsert, index);
                } else {
                    successful = false;
                }
            }
            if (propertyEvent.getChangeType() == 3) {
                s_componentPanelMoved = this.getComponent(eventElement);
                if (s_componentPanelMoved != null) {
                    this.removeContainerListener(GUIElementContainerListener.getStaticListener());
                    this.remove(s_componentPanelMoved);
                    this.addContainerListener(GUIElementContainerListener.getStaticListener());
                } else {
                    successful = false;
                }
            }
            if (propertyEvent.getChangeType() == 2) {
                s_componentPanelMoved = null;
                Component c = this.getComponent(eventElement);
                if (c != null) {
                    this.removeContainerListener(GUIElementContainerListener.getStaticListener());
                    this.remove(c);
                    this.addElementPanel(c, index);
                    this.addContainerListener(GUIElementContainerListener.getStaticListener());
                } else {
                    successful = false;
                }
            }
            boolean bl = successful = successful && this.checkGUI();
            if (successful) {
                this.revalidate();
                this.repaint();
            } else {
                this.clean();
                this.updateGUI();
                this.wakeUp();
            }
        }
    }

    public void addElementPanel(Component toAdd, int position) {
        if (this.getComponentCount() != 0 && this.getComponent(0) == this.insertPanel) {
            this.remove(this.insertPanel);
        }
        if (position > this.getElementComponentCount() || position < 0) {
            this.panelConstraints.gridy = position = this.getElementComponentCount();
        }
        this.add(toAdd, this.panelConstraints, position);
        this.restoreLayout();
        this.doLayout();
        if (toAdd instanceof JComponent) {
            if (this.topLevelScrollPane != null) {
                Rectangle rect = toAdd.getBounds();
                int horizValue = this.topLevelScrollPane.getHorizontalScrollBar().getValue();
                ((JComponent)toAdd).scrollRectToVisible(rect);
                this.topLevelScrollPane.getHorizontalScrollBar().setValue(horizValue);
            } else {
                ((JComponent)toAdd).scrollRectToVisible(toAdd.getBounds());
            }
        }
        this.repaint();
        this.revalidate();
    }

    protected Component getComponent(Element element) {
        int i = 0;
        while (i < this.getComponentCount()) {
            DnDGroupingPanel c;
            if (this.getComponent(i) instanceof ComponentElementPanel ? ((ComponentElementPanel)(c = (ComponentElementPanel)this.getComponent(i))).getElement() == element : this.getComponent(i) instanceof CompositeElementPanel && ((CompositeElementPanel)(c = (CompositeElementPanel)this.getComponent(i))).getElement() == element) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.insertPanel != null) {
            this.insertPanel.setBackground(color);
        }
    }

    protected void restoreLayout() {
        int i = 0;
        while (i < this.getComponentCount()) {
            Component current = this.getComponent(i);
            GridBagConstraints c = this.panelLayout.getConstraints(current);
            if (c.gridy != i) {
                c.gridy = i;
                this.panelLayout.setConstraints(current, c);
            }
            ++i;
        }
    }

    public void remove(Component c) {
        super.remove(c);
        if ((c instanceof CompositeElementPanel || c instanceof ComponentElementPanel) && this.componentElements != null && this.componentsIsEmpty()) {
            this.addDropTrough();
            return;
        }
        this.restoreLayout();
    }

    public InsertPanel getDropPanel() {
        return this.insertPanel;
    }

    public void setEmptyString(String emptyString) {
        this.insertPanel.m_doNothingLabel = emptyString;
        this.insertPanel.m_label.setText(this.insertPanel.m_doNothingLabel);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.m_owner.isExpanded() && this.m_owner.getParent() instanceof CompositeComponentElementPanel) {
            ((CompositeComponentElementPanel)this.m_owner.getParent()).dragEnter(dtde);
            return;
        }
        CompositeComponentElementPanel.stopAllTimers();
        AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.variableReferenceFlavor);
        dtde.acceptDrag(dtde.getDropAction());
    }

    public abstract void dragOver(DropTargetDragEvent var1);

    protected Component getContainingComponentPanel(Component c) {
        if (c == this.m_owner.getGrip()) {
            return c;
        }
        if (c == null) {
            return null;
        }
        if (c.getParent() instanceof CompositeComponentElementPanel) {
            return c;
        }
        if (c.getParent() == null) {
            return null;
        }
        return this.getContainingComponentPanel(c.getParent());
    }

    public ObjectArrayProperty getComponentProperty() {
        return this.componentElements;
    }

    protected boolean checkDropLocation(int i, Element toDrop) {
        return true;
    }

    protected int getInsertLocation(Point panelSpacePoint) {
        int position = -1;
        int i = 0;
        while (i < this.componentElements.size()) {
            Component c = this.getComponent(i);
            int point = c.getY() + (int)((double)c.getHeight() / 2.0);
            if (panelSpacePoint.getY() < (double)point) {
                position = i;
                break;
            }
            ++i;
        }
        return position;
    }

    private static void drawRect(Container container, Color color, Rectangle rect) {
        Graphics g = container.getGraphics();
        if (g != null && color != null) {
            g.setColor(color);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.dispose();
        }
    }

    private static void drawFeedback(Container container, Rectangle rect) {
        if (container != null && container.equals(s_prevContainer) && rect != null && rect.equals(s_prevRect)) {
            return;
        }
        if (s_prevContainer != null) {
            CompositeComponentElementPanel.drawRect(s_prevContainer, s_prevContainer.getBackground(), s_prevRect);
            if (s_prevContainer instanceof CompositeComponentElementPanel) {
                ((CompositeComponentElementPanel)CompositeComponentElementPanel.s_prevContainer).shouldDrawLine = false;
            }
        }
        if (container != null && container instanceof CompositeComponentElementPanel) {
            ((CompositeComponentElementPanel)container).shouldDrawLine = true;
        }
        s_prevContainer = container;
        s_prevRect = rect;
    }

    protected void paintLine(Container toPaint, int location) {
        if (location == -1 || location >= toPaint.getComponentCount()) {
            int lastSpot;
            int i = lastSpot = toPaint.getComponentCount() - 1;
            while (i >= 0) {
                if (toPaint.getComponent(i) instanceof GroupingPanel) {
                    lastSpot = i;
                    break;
                }
                lastSpot = i--;
            }
            if (lastSpot < 0) {
                lastSpot = 0;
            }
            Rectangle bounds = toPaint.getComponent(lastSpot).getBounds();
            this.lineLocation = bounds.y + bounds.height;
        } else {
            Rectangle bounds = toPaint.getComponent(location).getBounds();
            this.lineLocation = bounds.y - 2;
        }
        Rectangle toPaintBounds = toPaint.getBounds();
        CompositeComponentElementPanel.drawFeedback(toPaint, new Rectangle(2, this.lineLocation, toPaintBounds.width - 4, 2));
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.shouldDrawLine) {
            this.paintLine(this, this.insertLocation);
        }
    }

    protected boolean componentsIsEmpty() {
        return this.componentElements.size() == 0;
    }

    protected void scrollIt(Point hoverPoint) {
        Dimension scrollSpace = this.topLevelScrollPane.getSize();
        int currentValue = this.topLevelScrollPane.getVerticalScrollBar().getValue();
        int maxValue = this.topLevelScrollPane.getVerticalScrollBar().getMaximum();
        int minValue = this.topLevelScrollPane.getVerticalScrollBar().getMinimum();
        int amountToScroll = SCROLL_AMOUNT;
        if (hoverPoint.y < 8) {
            if (currentValue > minValue) {
                currentValue = currentValue - amountToScroll >= minValue ? (currentValue -= amountToScroll) : minValue;
                this.topLevelScrollPane.getVerticalScrollBar().setValue(currentValue);
                if (++SCROLL_AMOUNT > 10) {
                    SCROLL_AMOUNT = 10;
                }
            }
        } else if ((double)hoverPoint.y > scrollSpace.getHeight() - 8.0) {
            if (currentValue < maxValue) {
                currentValue = currentValue + amountToScroll <= maxValue ? (currentValue += amountToScroll) : maxValue;
                this.topLevelScrollPane.getVerticalScrollBar().setValue(currentValue);
                if (++SCROLL_AMOUNT > 10) {
                    SCROLL_AMOUNT = 10;
                }
            }
        } else {
            SCROLL_AMOUNT = 3;
        }
    }

    protected boolean isMyParent(Element currentParent, Element toSearchFor) {
        if (currentParent == toSearchFor) {
            return true;
        }
        if (currentParent == null) {
            return false;
        }
        return this.isMyParent(currentParent.getParent(), toSearchFor);
    }

    protected void insertDropPanel(DropTargetDragEvent dtde) {
        Component dropComponent = dtde.getDropTargetContext().getComponent();
        Transferable currentTransferable = DnDManager.getCurrentTransferable();
        Element currentElement = null;
        if (this.topLevelScrollPane == null) {
            this.setTopLevelScrollPanel();
        }
        if (this != s_currentComponentPanel) {
            s_currentComponentPanel = this;
        }
        Point panelSpacePoint = dtde.getLocation();
        if (this.topLevelScrollPane != null) {
            Point mainSpacePoint = SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), panelSpacePoint, this.topLevelScrollPane);
            this.scrollIt(mainSpacePoint);
        }
        if (dropComponent != this) {
            dropComponent = this.getContainingComponentPanel(dropComponent);
            panelSpacePoint = SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), this);
        }
        if (this.componentsIsEmpty()) {
            CompositeComponentElementPanel.drawFeedback(null, null);
            return;
        }
        if (currentTransferable != null) {
            try {
                currentElement = (Element)currentTransferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
            }
            catch (Exception exception) {}
        } else {
            this.insertLocation = -1;
            return;
        }
        int position = this.getInsertLocation(panelSpacePoint);
        if (this.checkDropLocation(position, currentElement)) {
            this.insertLocation = position;
            this.paintLine(this, this.insertLocation);
        }
    }

    public void removeDropPanelFromCurrentComponent() {
        this.shouldDrawLine = false;
        CompositeComponentElementPanel.drawFeedback(null, null);
        this.dropPanelLocation = -2;
    }

    protected void unhook(Element element) {
        element.removeFromParent();
    }

    protected void addToElement(Element toAdd, ObjectArrayProperty toAddTo, int location) {
        String newName = AuthoringToolResources.getNameForNewChild(toAdd.name.getStringValue(), toAddTo.getOwner());
        toAdd.name.set(newName);
        toAdd.setParent(toAddTo.getOwner());
        toAddTo.add(location, toAdd);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        this.inserting = false;
        this.removeDropPanelFromCurrentComponent();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.inserting = false;
        this.removeDropPanelFromCurrentComponent();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    protected boolean isValidDrop(Element current, Element toCheck) {
        if (toCheck == current) {
            return false;
        }
        if (current.getParent() != null) {
            return this.isValidDrop(current.getParent(), toCheck);
        }
        return true;
    }

    public abstract void drop(DropTargetDropEvent var1);

    protected int getLastElementLocation() {
        return this.componentElements.size();
    }

    protected boolean isRecursive(Element toDrop) {
        Element potentialParent = null;
        if (toDrop instanceof CallToUserDefinedResponse) {
            potentialParent = ((CallToUserDefinedResponse)toDrop).userDefinedResponse.getUserDefinedResponseValue();
        } else if (toDrop instanceof CallToUserDefinedQuestion) {
            potentialParent = ((CallToUserDefinedQuestion)toDrop).userDefinedQuestion.getUserDefinedQuestionValue();
        }
        if (potentialParent != null) {
            return this.isMyParent(this.componentElements.getOwner(), potentialParent);
        }
        return false;
    }

    protected boolean canFindOwner(Element lookingFor, Element current) {
        if (current == null) {
            return false;
        }
        if (lookingFor == current) {
            return true;
        }
        return this.canFindOwner(lookingFor, current.getParent());
    }

    protected boolean checkLoop(Element e) {
        Variable v;
        if (e instanceof Variable && ((v = (Variable)e).getParent() instanceof ForEach || v.getParent() instanceof edu.cmu.cs.stage3.alice.core.question.userdefined.ForEach)) {
            return this.canFindOwner(v.getParent(), this.componentElements.getOwner());
        }
        return true;
    }

    protected void performDrop(Element toDrop, DropTargetDropEvent dtde) {
        Object[] options;
        int recursionReturn;
        if (this.isRecursive(toDrop) && (recursionReturn = DialogManager.showOptionDialog("The code you have just dropped in creates a \"recursive method call\". We recommend that you understand\nwhat recursion is before making a call like this.  Are you sure you want to do this?", "Recursion Warning", 0, 2, null, options = new Object[]{"Yes, I understand what I am doing.", "No, I made this call accidentally."}, options[1])) == 1) {
            return;
        }
        if (this.authoringTool != null) {
            this.authoringTool.getUndoRedoStack().startCompound();
        }
        int dropPanelLocationTemp = this.getInsertLocation(SwingUtilities.convertPoint(dtde.getDropTargetContext().getComponent(), dtde.getLocation(), this));
        if (this.isInverted()) {
            dropPanelLocationTemp = dropPanelLocationTemp == -1 ? 0 : this.componentElements.size() - dropPanelLocationTemp;
        }
        this.inserting = false;
        boolean isCopy = false;
        DnDManager.getCurrentDragComponent();
        this.removeDropPanelFromCurrentComponent();
        if ((dtde.getDropAction() & 1) > 0) {
            toDrop = toDrop.HACK_createCopy(null, null, dropPanelLocationTemp, null, this.componentElements.getOwner());
            isCopy = true;
        }
        this.insertingElement = true;
        boolean alreadyDone = false;
        if (!isCopy && this.componentElements.contains(toDrop)) {
            int oldIndex = this.componentElements.indexOf(toDrop);
            if (dropPanelLocationTemp <= -1 || dropPanelLocationTemp >= this.getLastElementLocation()) {
                dropPanelLocationTemp = this.componentElements.size() == 0 ? 0 : this.getLastElementLocation() - 1;
            } else if (dropPanelLocationTemp > oldIndex) {
                --dropPanelLocationTemp;
            }
            int dif = Math.abs(oldIndex - dropPanelLocationTemp);
            if (dif > 0) {
                this.componentElements.shift(oldIndex, dropPanelLocationTemp);
            }
            alreadyDone = true;
        }
        if (!alreadyDone) {
            this.unhook(toDrop);
            if (dropPanelLocationTemp >= -1 && dropPanelLocationTemp <= this.getLastElementLocation()) {
                this.addToElement(toDrop, this.componentElements, dropPanelLocationTemp);
            } else {
                this.addToElement(toDrop, this.componentElements, -1);
            }
        }
        this.insertingElement = false;
        if (this.authoringTool != null) {
            this.authoringTool.getUndoRedoStack().stopCompound();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void dragExit(DropTargetEvent dte) {
        this.HACK_timer.restart();
        this.HACK_timer.start();
        timers.add(this.HACK_timer);
    }
}

