/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.AliceWorldFilter;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceTabbedPaneUI;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StartUpContentPane
extends ContentPane {
    public static final int DO_NOT_CHANGE_TAB_ID = -1;
    public static final int OPEN_TAB_ID = 1;
    private static final String OPEN_STRING = "Open a world";
    private final int WIDTH = 480;
    private final int HEIGHT = 470;
    private static final Color SELECTED_COLOR = new Color(10, 10, 100);
    private static final Color SELECTED_TEXT_COLOR = new Color(255, 255, 255);
    private static final Color BACKGROUND_COLOR = new Color(0, 0, 0);
    private AliceWorldFilter aliceFilter;
    private javax.swing.filechooser.FileFilter worldFilter;
    private StartUpIcon currentlySelected;
    private ImageIcon headerImage;
    private ImageIcon basicIcon;
    private ImageIcon directoryIcon;
    private ImageIcon upDirectoryIcon;
    private JTabbedPane mainTabPane = new JTabbedPane();
    private JButton openButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton refreshButton = new JButton();
    private JCheckBox stopShowingCheckBox = new JCheckBox();
    private JLabel headerLabel = new JLabel();
    private JFileChooser fileChooser = new JFileChooser(){

        public void setSelectedFile(File file) {
            super.setSelectedFile(file);
            StartUpContentPane.this.handleFileSelectionChange(file);
        }
    };
    private JPanel buttonPanel = new JPanel();
    protected int currentTab = 1;

    public StartUpContentPane(AuthoringTool authoringTool) {
        this.headerImage = new ImageIcon(JAlice.class.getResource("images/startUpDialog/StartupScreen.png"));
        this.basicIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/aliceIcon.png"));
        this.directoryIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/directoryIcon.png"));
        this.upDirectoryIcon = new ImageIcon(JAlice.class.getResource("images/startUpDialog/upDirectoryIcon.png"));
        this.worldFilter = authoringTool.getWorldFileFilter();
        this.aliceFilter = new AliceWorldFilter(this.worldFilter);
        this.jbInit();
        this.guiInit();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
            }
        });
    }

    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
        this.mainTabPane.setSelectedComponent(this.getTabForID(this.currentTab));
    }

    private void handleFileSelectionChange(File file) {
        this.openButton.setEnabled(file != null && file.exists() && !file.isDirectory());
    }

    public String getTitle() {
        return "Welcome to Alice!";
    }

    public void addOKActionListener(ActionListener l) {
        this.openButton.addActionListener(l);
    }

    public void removeOKActionListener(ActionListener l) {
        this.openButton.removeActionListener(l);
    }

    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    public boolean isSaveNeeded() {
        if (this.currentlySelected != null) {
            return this.currentlySelected.needToSave;
        }
        return true;
    }

    public File getFile() {
        if (this.getTabID() == 1) {
            return this.fileChooser.getSelectedFile();
        }
        if (this.currentlySelected != null) {
            return new File(this.currentlySelected.file);
        }
        return null;
    }

    private int getIDForTab(Component tab) {
        if (tab == this.fileChooser) {
            return 1;
        }
        return 0;
    }

    private Component getTabForID(int tabID) {
        return this.fileChooser;
    }

    private int getTabID() {
        return this.getIDForTab(this.mainTabPane.getSelectedComponent());
    }

    public void setTabID(int tabID) {
        if (tabID == 1) {
            this.fileChooser.rescanCurrentDirectory();
        }
        if (tabID != -1) {
            this.currentTab = tabID;
            this.mainTabPane.setSelectedComponent(this.getTabForID(this.currentTab));
        }
    }

    private String makeNameFromFilename(String filename) {
        String name = filename.substring(0, filename.length() - 4);
        int last = name.lastIndexOf(File.separator);
        if (last >= 0 && last < name.length()) {
            name = name.substring(last + 1);
        }
        return name;
    }

    private String makeDirectoryNameFromFilename(String filename) {
        int last;
        String name = new String(filename);
        if (filename.endsWith(File.separator)) {
            filename = filename.substring(filename.length());
        }
        if ((last = filename.lastIndexOf(File.separator)) >= 0 && last < filename.length()) {
            name = filename.substring(last + 1);
        }
        return name;
    }

    private Vector buildVectorFromDirectory(File dir, FileFilter f) {
        Vector<StringObjectPair> toReturn = null;
        if (dir != null && dir.isDirectory()) {
            File[] files;
            toReturn = new Vector<StringObjectPair>();
            File[] fileArray = files = dir.listFiles(f);
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File file = fileArray[n];
                String name = "";
                name = file.isDirectory() ? this.makeDirectoryNameFromFilename(file.getName()) : this.makeNameFromFilename(file.getName());
                StringObjectPair sop = new StringObjectPair(name, file.getAbsolutePath());
                toReturn.add(sop);
                ++n;
            }
        }
        return toReturn;
    }

    private ImageIcon getIconFromFile(File file) {
        String filename = file.getAbsolutePath();
        ImageIcon icon = null;
        try {
            ZipFile zip;
            ZipEntry entry;
            Node n;
            DocumentBuilderFactory factory;
            DocumentBuilder builder;
            Document document;
            NodeList nl;
            if (filename.endsWith(".stl") && (nl = (document = (builder = (factory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(file)).getElementsByTagName("stencilStack")) != null && nl.getLength() > 0 && (n = nl.item(0)) instanceof Element) {
                String worldFileName = ((Element)n).getAttribute("world");
                file = new File(worldFileName);
            }
            if ((entry = (zip = new ZipFile(file)).getEntry("thumbnail.png")) != null) {
                zip.getInputStream(entry);
            }
            zip.close();
        }
        catch (Exception e) {
            return null;
        }
        return icon;
    }

    protected Component getTopContainer(Component innerContainer) {
        return null;
    }

    protected String getBaseDirString(Component topLevelOwner) {
        return "";
    }

    private int buildPanel(JPanel toBuild, Vector toAdd, boolean needToSave, File parentDir, int type) {
        int count = 0;
        if (parentDir != null || toAdd != null) {
            toBuild.removeAll();
        }
        if (parentDir != null) {
            String parentDirName = "Back";
            StartUpIcon parentDirIcon = new StartUpIcon(parentDirName, this.upDirectoryIcon, parentDir.getAbsolutePath(), false, 3, this.getTopContainer(toBuild));
            toBuild.add(parentDirIcon);
            ++count;
        }
        if (toAdd != null) {
            int i = 0;
            while (i < toAdd.size()) {
                StringObjectPair sop = (StringObjectPair)toAdd.get(i);
                String name = sop.getString();
                String filename = (String)sop.getObject();
                File file = new File(filename);
                ImageIcon icon = this.basicIcon;
                if (file.exists() && file.canRead()) {
                    filename = file.getAbsolutePath();
                    if (file.isDirectory()) {
                        StartUpIcon dirIcon = new StartUpIcon(name, this.directoryIcon, filename, false, 3, this.getTopContainer(toBuild));
                        toBuild.add(dirIcon);
                        ++count;
                    } else {
                        boolean worldIsThere = true;
                        if (file.exists() && file.canRead()) {
                            icon = this.getIconFromFile(file);
                            if (icon == null) {
                                icon = this.basicIcon;
                            }
                        } else {
                            worldIsThere = false;
                        }
                        if (worldIsThere) {
                            StartUpIcon sui = new StartUpIcon(name, icon, filename, needToSave, type, this.getTopContainer(toBuild));
                            toBuild.add(sui);
                            ++count;
                        }
                    }
                }
                ++i;
            }
        }
        toBuild.revalidate();
        return count;
    }

    private void initializeFileChooser() {
        this.mainTabPane.remove(this.fileChooser);
        File currentDir = this.fileChooser.getCurrentDirectory();
        this.fileChooser = new JFileChooser(){

            public void setSelectedFile(File file) {
                super.setSelectedFile(file);
                StartUpContentPane.this.handleFileSelectionChange(file);
            }
        };
        int i = 0;
        while (i < this.fileChooser.getComponentCount()) {
            this.setButtonBackgroundColors(this.fileChooser.getComponent(i), this.fileChooser.getBackground());
            ++i;
        }
        if (currentDir.exists()) {
            this.fileChooser.setCurrentDirectory(currentDir);
        }
        this.fileChooser.setFileFilter(this.worldFilter);
        this.fileChooser.setBackground(Color.white);
        this.fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartUpContentPane.this.fileChooser_actionPerformed(e);
            }
        });
        this.fileChooser.setFileSelectionMode(0);
        this.mainTabPane.add((Component)this.fileChooser, OPEN_STRING);
    }

    private void guiInit() {
        this.setPreferredSize(new Dimension(480, 470));
        this.headerLabel.setIcon(this.headerImage);
        this.mainTabPane.setUI(new AliceTabbedPaneUI());
        this.mainTabPane.setOpaque(false);
        this.initializeFileChooser();
    }

    private void setButtonBackgroundColors(Component c, Color color) {
        if (!(c instanceof Button)) {
            c.setBackground(color);
        }
        if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                this.setButtonBackgroundColors(cont.getComponent(i), color);
                ++i;
            }
        }
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        Box.createGlue();
        Box.createGlue();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.mainTabPane.setMinimumSize(new Dimension(480, 310));
        this.mainTabPane.setPreferredSize(new Dimension(480, 310));
        this.mainTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                StartUpContentPane.this.mainTabPane_stateChanged(e);
            }
        });
        this.buttonPanel.setOpaque(false);
        this.openButton.setMaximumSize(new Dimension(95, 27));
        this.openButton.setMinimumSize(new Dimension(95, 27));
        this.openButton.setPreferredSize(new Dimension(95, 27));
        this.openButton.setText("Open");
        this.cancelButton.setMaximumSize(new Dimension(95, 27));
        this.cancelButton.setMinimumSize(new Dimension(95, 27));
        this.cancelButton.setPreferredSize(new Dimension(95, 27));
        this.cancelButton.setText("Cancel");
        this.refreshButton.setMaximumSize(new Dimension(90, 22));
        this.refreshButton.setMinimumSize(new Dimension(90, 22));
        this.refreshButton.setPreferredSize(new Dimension(90, 22));
        this.refreshButton.setOpaque(false);
        this.refreshButton.setText("Refresh");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartUpContentPane.this.refreshButton_actionPerformed(e);
            }
        });
        this.stopShowingCheckBox.setOpaque(false);
        this.stopShowingCheckBox.setText("Show this dialog at start");
        this.stopShowingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StartUpContentPane.this.stopShowingCheckBox_actionPerformed(e);
            }
        });
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.openButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 0, 0, 4), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 0, 0, 4), 0, 0));
        this.buttonPanel.add(Box.createGlue(), new GridBagConstraints(0, 1, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.mainTabPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainTabPane.add((Component)this.fileChooser, OPEN_STRING);
        this.add((Component)this.stopShowingCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.add((Component)this.headerLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setFileChooserButtons() {
        this.add((Component)this.refreshButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 2, 1, 1), 0, 0));
        this.remove(this.buttonPanel);
    }

    private void setRegularButtons() {
        this.remove(this.refreshButton);
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void mainTabPane_stateChanged(ChangeEvent e) {
        if (this.currentlySelected != null) {
            this.currentlySelected.deSelect();
            this.currentlySelected = null;
        }
        if (this.mainTabPane.getSelectedComponent() == this.fileChooser) {
            this.setFileChooserButtons();
            this.handleFileSelectionChange(this.fileChooser.getSelectedFile());
        } else {
            this.setRegularButtons();
            this.openButton.setEnabled(false);
        }
    }

    private void stopShowingCheckBox_actionPerformed(ActionEvent e) {
    }

    private void fileChooser_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("ApproveSelection")) {
            this.openButton.enable();
            this.openButton.doClick();
        } else if (actionCommand.equals("CancelSelection")) {
            this.cancelButton.doClick();
        }
    }

    private void refreshButton_actionPerformed(ActionEvent e) {
        this.initializeFileChooser();
        this.setTabID(1);
    }

    protected class StartUpIcon
    extends JLabel
    implements MouseListener {
        protected static final int STANDARD = 1;
        protected static final int DIRECTORY = 3;
        protected boolean isSelected;
        protected String file;
        protected boolean needToSave;
        protected int type;
        protected Component owner;

        public StartUpIcon(String name, ImageIcon icon, String file, boolean needToSave, int type, Component owner) {
            super(name, icon, 0);
            this.isSelected = false;
            this.needToSave = false;
            this.file = file;
            this.needToSave = needToSave;
            this.type = type;
            this.owner = owner;
            this.setBackground(BACKGROUND_COLOR);
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            Dimension size = new Dimension(icon.getIconWidth() + 4, icon.getIconHeight() + 24);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
            this.setMaximumSize(size);
            if (type == 3) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
            this.setOpaque(false);
            this.addMouseListener(this);
        }

        protected JPanel getContainer(Component topLevelOwner) {
            return null;
        }

        protected JLabel getJLabel(Component topLevelOwner) {
            return null;
        }

        protected String getRootPath(Component topLevelOwner) {
            return null;
        }

        protected String getRelativePath(String current, String root) {
            return current.substring(root.length());
        }

        protected void changeDirectory(String newDirectory) {
            File newDir = new File(newDirectory);
            File parentDir = newDir.getParentFile();
            JLabel labelToSet = this.getJLabel(this.owner);
            String baseDir = StartUpContentPane.this.getBaseDirString(this.owner);
            if (this.owner instanceof JScrollPane) {
                ((JScrollPane)this.owner).getVerticalScrollBar().setValue(0);
            }
            StartUpContentPane.this.buildPanel(this.getContainer(this.owner), StartUpContentPane.this.buildVectorFromDirectory(newDir, StartUpContentPane.this.aliceFilter), this.needToSave, parentDir, 1);
            labelToSet.setText(String.valueOf(baseDir) + this.getRelativePath(newDir.getAbsolutePath(), this.getRootPath(this.owner)));
        }

        public void deSelect() {
            if (this.isSelected) {
                StartUpContentPane.this.currentlySelected = null;
                this.isSelected = false;
                this.setBackground(BACKGROUND_COLOR);
                this.setOpaque(false);
                this.repaint();
                this.setForeground((Color)UIManager.get("Label.foreground"));
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (this.type == 3) {
                this.changeDirectory(this.file);
            } else {
                if (!this.isSelected) {
                    this.isSelected = true;
                    if (StartUpContentPane.this.currentlySelected != null) {
                        StartUpContentPane.this.currentlySelected.deSelect();
                    }
                    if (!StartUpContentPane.this.openButton.isEnabled()) {
                        StartUpContentPane.this.openButton.setEnabled(true);
                    }
                    this.setBackground(SELECTED_COLOR);
                    this.setOpaque(true);
                    this.setForeground(SELECTED_TEXT_COLOR);
                    StartUpContentPane.this.currentlySelected = this;
                    StartUpContentPane.this.currentlySelected.repaint();
                }
                if (e.getClickCount() == 2) {
                    StartUpContentPane.this.openButton.doClick();
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }
    }
}

