/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.SimulationException;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SimulationExceptionPanel
extends JPanel {
    private AuthoringTool m_authoringTool;
    private JLabel m_descriptionLabel = new JLabel();

    public SimulationExceptionPanel(AuthoringTool authoringTool) {
        this.m_authoringTool = authoringTool;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        this.add((Component)new JLabel("Alice has detected a problem with your world:"), gbc);
        gbc.insets.left = 8;
        this.add((Component)this.m_descriptionLabel, gbc);
    }

    public void setSimulationException(SimulationException simulationException) {
        Element[] userDefinedResponses;
        this.m_descriptionLabel.setText(simulationException.getMessage());
        Element element = simulationException.getElement();
        World world = this.m_authoringTool.getWorld();
        Element ancestor = null;
        Element[] elementArray = userDefinedResponses = world.getDescendants(UserDefinedResponse.class);
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            Element userDefinedResponse = elementArray[n];
            if (userDefinedResponse.isAncestorOf(element)) {
                ancestor = userDefinedResponse;
                break;
            }
            ++n;
        }
        if (ancestor == null) {
            Element[] userDefinedQuestions;
            Element[] elementArray2 = userDefinedQuestions = world.getDescendants(edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class);
            n2 = 0;
            int n3 = elementArray2.length;
            while (n2 < n3) {
                Element userDefinedQuestion = elementArray2[n2];
                if (userDefinedQuestion.isAncestorOf(element)) {
                    ancestor = userDefinedQuestion;
                    break;
                }
                ++n2;
            }
        }
    }
}

