/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.OutputComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RenderContentPane
extends ContentPane {
    protected JPanel renderPanel = new JPanel(new BorderLayout());
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JSplitPane stdOutSplitPane = new JSplitPane(0);
    protected double aspectRatio;
    protected AuthoringTool authoringTool;
    protected boolean showStdOut = false;
    protected int stdOutHeight = 100;
    protected int watcherWidth = 200;
    protected OutputComponent stdOutOutputComponent;
    protected WatcherPanel watcherPanel;
    protected JScrollPane watcherScrollPane;
    protected JSplitPane watcherSplitPane = new JSplitPane(1);
    protected JButton pauseButton;
    protected JButton resumeButton;
    protected JButton restartButton;
    protected JButton stopButton;
    protected RenderCanvasFocusListener renderCanvasFocusListener = new RenderCanvasFocusListener();
    protected boolean shiftIsDown = false;
    protected JScrollPane textScrollPane;
    protected StyledStreamTextPane detailTextPane = new StyledStreamTextPane();
    protected boolean doNotListenToResize = false;
    protected final int dividerSize = 8;
    protected String title;
    protected ActionListener okActionListener;
    protected TextOutputDocumentListener textListener = new TextOutputDocumentListener();
    protected RenderComponentListener renderResizeListener = new RenderComponentListener();

    public RenderContentPane(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.stdOutOutputComponent = AuthoringTool.getStdOutOutputComponent();
        this.watcherPanel = authoringTool.getWatcherPanel();
        this.guiInit();
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    protected void setRenderWindowSizeBasedOnSavedBounds() {
        this.renderPanel.setPreferredSize(new Dimension(500, 10));
    }

    public void preDialogShow(JDialog parentDialog) {
        super.preDialogShow(parentDialog);
        final Component renderCanvas = this.getRenderCanvas();
        if (renderCanvas != null) {
            renderCanvas.addFocusListener(this.renderCanvasFocusListener);
            Timer focusTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    renderCanvas.requestFocus();
                }
            });
            focusTimer.setRepeats(false);
            focusTimer.start();
        }
        this.stdOutOutputComponent.stdOutStream.println("*****Running World*****");
        this.stdOutOutputComponent.stdOutStream.flush();
        this.stdOutOutputComponent.getTextPane().getDocument().addDocumentListener(this.textListener);
        this.renderPanel.setPreferredSize(new Dimension(500, 10));
        parentDialog.setLocation(170, 170);
        this.showStdOut = false;
        this.keyMapInit();
        this.updateGUI();
    }

    public void postDialogShow(JDialog parentDialog) {
        super.postDialogShow(parentDialog);
        this.authoringTool.worldStopRunning();
        this.saveRenderBounds();
        this.showStdOut = false;
        Component renderCanvas = this.getRenderCanvas();
        if (renderCanvas != null) {
            renderCanvas.removeFocusListener(this.renderCanvasFocusListener);
        }
        this.stdOutOutputComponent.getTextPane().getDocument().removeDocumentListener(this.textListener);
        this.stdOutOutputComponent.stdOutStream.println("*****Stopping World*****");
        this.stdOutOutputComponent.stdOutStream.flush();
    }

    public void addOKActionListener(ActionListener l) {
        this.okActionListener = l;
        this.stopButton.addActionListener(l);
    }

    public void removeOKActionListener(ActionListener l) {
        this.okActionListener = null;
        this.stopButton.removeActionListener(l);
    }

    private void guiInit() {
        this.title = "World Running...";
        this.setRenderWindowSizeBasedOnSavedBounds();
        this.renderPanel.addComponentListener(this.renderResizeListener);
        this.watcherScrollPane = new JScrollPane(this.watcherPanel, 20, 30);
        this.textScrollPane = new JScrollPane(this.detailTextPane, 20, 30);
        this.detailTextPane.setEditable(false);
        this.pauseButton = new JButton(this.authoringTool.getActions().pauseWorldAction);
        this.resumeButton = new JButton(this.authoringTool.getActions().resumeWorldAction);
        this.restartButton = new JButton(this.authoringTool.getActions().restartWorldAction);
        this.stopButton = new JButton(this.authoringTool.getActions().stopWorldAction);
        this.pauseButton.setMargin(new Insets(3, 2, 3, 2));
        this.resumeButton.setMargin(new Insets(3, 2, 3, 2));
        this.restartButton.setMargin(new Insets(3, 2, 3, 2));
        this.stopButton.setMargin(new Insets(3, 2, 3, 2));
        this.buttonPanel.add((Component)this.pauseButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.resumeButton, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.restartButton, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.stopButton, new GridBagConstraints(7, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.watcherSplitPane = new JSplitPane(1);
        this.watcherSplitPane.setContinuousLayout(true);
        this.watcherSplitPane.setDividerSize(0);
        this.watcherSplitPane.setResizeWeight(1.0);
        this.watcherSplitPane.setLeftComponent(this.renderPanel);
        this.stdOutSplitPane = new JSplitPane(0);
        this.stdOutSplitPane.setContinuousLayout(true);
        this.stdOutSplitPane.setDividerSize(0);
        this.stdOutSplitPane.setResizeWeight(1.0);
        this.stdOutSplitPane.setTopComponent(this.watcherSplitPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.stdOutSplitPane, "Center");
        this.updateGUI();
    }

    private void keyMapInit() {
        for (Action action : this.authoringTool.getActions().renderActions) {
            Component root;
            String commandKey;
            KeyStroke keyStroke;
            try {
                keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                commandKey = (String)action.getValue("ActionCommandKey");
            }
            catch (ClassCastException e) {
                continue;
            }
            if (keyStroke == null || commandKey == null || !((root = SwingUtilities.getRoot(this)) instanceof JDialog)) continue;
            ((JDialog)root).getRootPane().registerKeyboardAction(action, commandKey, keyStroke, 2);
        }
    }

    public void saveRenderBounds() {
        Point pos = new Point(0, 0);
        Component root = SwingUtilities.getRoot(this);
        if (root instanceof JDialog) {
            SwingUtilities.convertPointToScreen(pos, root);
        } else {
            SwingUtilities.convertPointToScreen(pos, this.renderPanel);
        }
    }

    public void saveRenderBounds(Rectangle newBounds) {
    }

    protected boolean shouldConstrainAspectOnResize() {
        return !this.showStdOut && !this.authoringTool.getWatcherPanel().isThereSomethingToWatch();
    }

    public JPanel getRenderPanel() {
        return this.renderPanel;
    }

    public void constrainToAspectRatio(Rectangle bounds, boolean stretchHorizontally) {
        if (this.aspectRatio > 0.0) {
            if (stretchHorizontally) {
                bounds.width = (int)Math.round((double)bounds.height * this.aspectRatio);
            } else {
                bounds.height = (int)Math.round((double)bounds.width / this.aspectRatio);
            }
        }
    }

    public void stopWorld() {
        if (this.okActionListener != null) {
            this.okActionListener.actionPerformed(null);
        }
    }

    public void updateGUI() {
        int renderWidth = this.renderPanel.getWidth();
        int renderHeight = this.renderPanel.getHeight();
        if (this.showStdOut) {
            this.textScrollPane.setPreferredSize(new Dimension(renderWidth, this.stdOutHeight));
            this.stdOutSplitPane.setBottomComponent(this.textScrollPane);
            this.stdOutSplitPane.setDividerSize(8);
        } else {
            this.stdOutSplitPane.setBottomComponent(null);
            this.stdOutSplitPane.setDividerLocation(0);
            this.stdOutSplitPane.setDividerSize(0);
        }
        if (this.authoringTool.getWatcherPanel().isThereSomethingToWatch()) {
            this.watcherScrollPane.setPreferredSize(new Dimension(this.watcherWidth, renderHeight));
            this.watcherSplitPane.setRightComponent(this.watcherScrollPane);
            this.watcherSplitPane.setDividerSize(8);
        } else {
            this.watcherSplitPane.setRightComponent(null);
            this.watcherSplitPane.setDividerLocation(0);
            this.watcherSplitPane.setDividerSize(0);
        }
        this.packDialog();
    }

    public void addNotify() {
        super.addNotify();
        this.showStdOut = false;
        this.updateGUI();
    }

    public Component getRenderCanvas() {
        Component authoringToolRenderPanel = this.renderPanel.getComponent(0);
        if (authoringToolRenderPanel instanceof Container) {
            try {
                return ((Container)authoringToolRenderPanel).getComponent(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected class TextOutputDocumentListener
    implements DocumentListener {
        protected TextOutputDocumentListener() {
        }

        public void insertUpdate(final DocumentEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        String textUpdate = ev.getDocument().getText(ev.getOffset(), ev.getLength());
                        ((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.detailTextPane.getDocument().insertString(((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.detailTextPane.getDocument().getLength(), textUpdate, ((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.detailTextPane.stdOutStyle);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    TextOutputDocumentListener.this.update();
                }
            });
        }

        public void removeUpdate(DocumentEvent ev) {
            this.update();
        }

        public void changedUpdate(DocumentEvent ev) {
            this.update();
        }

        private void update() {
            if (!RenderContentPane.this.showStdOut) {
                RenderContentPane.this.saveRenderBounds();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RenderContentPane.this.updateGUI();
                        ((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.showStdOut = true;
                        Component renderCanvas = RenderContentPane.this.getRenderCanvas();
                        if (renderCanvas != null) {
                            renderCanvas.requestFocus();
                        }
                    }
                });
            }
        }
    }

    protected class RenderComponentListener
    extends ComponentAdapter {
        protected RenderComponentListener() {
        }

        public void componentResized(ComponentEvent ev) {
            if (RenderContentPane.this.shouldConstrainAspectOnResize() && !RenderContentPane.this.doNotListenToResize) {
                RenderContentPane.this.packDialog();
                RenderContentPane.this.doNotListenToResize = false;
            }
        }
    }

    public class RenderCanvasFocusListener
    extends FocusAdapter {
        public void focusLost() {
            Component renderCanvas = RenderContentPane.this.getRenderCanvas();
            if (renderCanvas != null && renderCanvas.isShowing()) {
                renderCanvas.requestFocus();
            }
        }
    }
}

