/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.ImagePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyleStream;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AliceAlertContentPane
extends ContentPane {
    public static final int LESS_DETAIL_MODE = 0;
    public static final int MORE_DETAIL_MODE = 1;
    protected int mode = -1;
    protected ImagePanel errorIconPanel = new ImagePanel();
    protected StyledStreamTextPane detailTextPane = new StyledStreamTextPane();
    protected StyleStream detailStream;
    protected JPanel buttonPanel = new JPanel();
    protected JPanel messagePanel = new JPanel();
    protected JPanel detailPanel = new JPanel();
    protected JScrollPane detailScrollPane = new JScrollPane();
    protected JTextArea messageLabel = new JTextArea();
    protected JButton submitBugButton = new JButton();
    protected JButton copyButton = new JButton();
    protected JButton cancelButton = new JButton();
    protected JButton detailButton = new JButton();
    protected GridBagConstraints buttonConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0);
    protected GridBagConstraints glueConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
    protected Component buttonGlue;

    public AliceAlertContentPane() {
        this.init();
    }

    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
    }

    public void postDialogShow(JDialog dialog) {
        super.postDialogShow(dialog);
    }

    public String getTitle() {
        return "Alice - Alert";
    }

    public void addOKActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    protected void init() {
        this.jbInit();
        this.setMode(0);
    }

    public void setSubmitBugButtonEnabled(boolean b) {
        if (b != this.buttonPanel.isAncestorOf(this.submitBugButton)) {
            if (b) {
                this.buttonPanel.add((Component)this.submitBugButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 8, 0), 0, 0));
            } else {
                this.buttonPanel.remove(this.submitBugButton);
            }
        }
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return preferredSize;
    }

    protected void setLessDetail() {
        this.detailButton.setText("More Detail >>");
        this.remove(this.detailScrollPane);
        this.add((Component)this.detailPanel, "Center");
        this.buttonPanel.removeAll();
        this.buttonConstraints.gridx = 0;
        this.buttonPanel.add((Component)this.submitBugButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.cancelButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.glueConstraints.gridx = this.buttonConstraints.gridx++;
        this.buttonPanel.add(this.buttonGlue, this.glueConstraints);
        this.buttonPanel.add((Component)this.detailButton, this.buttonConstraints);
    }

    protected void setMoreDetail() {
        this.detailButton.setText("Less Detail <<");
        this.remove(this.detailPanel);
        this.add((Component)this.detailScrollPane, "Center");
        this.buttonPanel.removeAll();
        this.buttonConstraints.gridx = 0;
        this.buttonPanel.add((Component)this.submitBugButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.copyButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.cancelButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.glueConstraints.gridx = this.buttonConstraints.gridx++;
        this.buttonPanel.add(this.buttonGlue, this.glueConstraints);
        this.buttonPanel.add((Component)this.detailButton, this.buttonConstraints);
    }

    protected void handleModeSwitch(int mode) {
        if (mode == 0) {
            this.setLessDetail();
        } else if (mode == 1) {
            this.setMoreDetail();
        } else {
            throw new IllegalArgumentException("Illegal mode: " + mode);
        }
    }

    public void setMode(int mode) {
        if (this.mode != mode) {
            this.mode = mode;
            this.handleModeSwitch(mode);
            this.packDialog();
        }
    }

    public void toggleMode() {
        if (this.mode == 0) {
            this.setMode(1);
        } else {
            this.setMode(0);
        }
    }

    protected void writeAliceHeaderToTextPane() {
        String[] systemProperties;
        this.detailTextPane.setText("");
        this.detailStream.println(String.valueOf(this.messageLabel.getText()) + "\n");
        this.detailStream.println();
        this.detailStream.println("");
        String[] stringArray = systemProperties = new String[]{"os.name", "os.version", "os.arch", "java.vm.name", "java.vm.version", "user.dir"};
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String systemPropertie = stringArray[n];
            this.detailStream.println(String.valueOf(systemPropertie) + ": " + System.getProperty(systemPropertie));
            ++n;
        }
        this.detailStream.println();
    }

    protected void submitBug() {
        String stacktraceID = this.postStacktrace();
        String urlString = "http://alice.org/bugreport/submit.php";
        try {
            AuthoringToolResources.openURL(String.valueOf(urlString) + "&pasteStacktrace=" + stacktraceID);
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Unable to open bug report web page.", t);
        }
    }

    protected String postStacktrace() {
        try {
            URL url = new URL("http://www.alice.org/bugreport/stacktrace.php");
            URLConnection connection = url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String stacktrace = URLEncoder.encode(this.detailTextPane.getText());
            while (stacktrace.indexOf("%0D") > -1) {
                int i = stacktrace.indexOf("%0D");
                stacktrace = String.valueOf(stacktrace.substring(0, i)) + stacktrace.substring(i + 3);
            }
            String content = "stacktrace=" + stacktrace;
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(connection.getOutputStream()));
            output.writeBytes(content);
            output.flush();
            output.close();
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String stacktraceIDString = input.readLine();
            input.close();
            return stacktraceIDString;
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Error posting stacktrace to bug database.", t);
            return "0";
        }
    }

    protected void copyDetailText() {
        String detailText = this.detailTextPane.getText();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(detailText), AuthoringTool.getHack());
    }

    void detailButton_actionPerformed(ActionEvent e) {
        this.toggleMode();
    }

    void submitBugButton_actionPerformed(ActionEvent e) {
        this.submitBug();
    }

    void copyButton_actionPerformed(ActionEvent e) {
        this.copyDetailText();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonGlue = Box.createHorizontalGlue();
        this.messageLabel.setEditable(false);
        this.messageLabel.setLineWrap(true);
        this.messageLabel.setOpaque(false);
        this.messageLabel.setPreferredSize(new Dimension(402, 1));
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.messageLabel.setText("An unknown error has occurred.");
        this.cancelButton.setText("Cancel");
        this.detailButton.setText("More Detail >>");
        this.detailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliceAlertContentPane.this.detailButton_actionPerformed(e);
            }
        });
        this.submitBugButton.setText("Submit Bug");
        this.submitBugButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliceAlertContentPane.this.submitBugButton_actionPerformed(e);
            }
        });
        this.copyButton.setText("Copy Error to Clipboard");
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliceAlertContentPane.this.copyButton_actionPerformed(e);
            }
        });
        this.messagePanel.setLayout(new BorderLayout());
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.detailPanel.setLayout(new BorderLayout());
        this.detailPanel.setBorder(null);
        this.detailPanel.setPreferredSize(new Dimension(492, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.buttonPanel.setLayout(new GridBagLayout());
        URL errorImageResources = JAlice.class.getResource("images/errorDialogueIcon.png");
        this.errorIconPanel.setImage(Toolkit.getDefaultToolkit().createImage(errorImageResources));
        this.messagePanel.add((Component)this.errorIconPanel, "West");
        this.messagePanel.add((Component)this.messageLabel, "Center");
        this.detailTextPane.setEditable(false);
        this.detailStream = this.detailTextPane.getNewStyleStream(this.detailTextPane.stdErrStyle);
        this.detailScrollPane.setViewportView(this.detailTextPane);
        this.detailScrollPane.setPreferredSize(new Dimension(490, 400));
        this.add((Component)this.messagePanel, "North");
        this.add((Component)this.detailPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
    }
}

