/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.SplashScreen;
import edu.cmu.cs.stage3.alice.core.AppletWorldStorer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JApplet;

public class JAlice
extends JApplet {
    static File aliceHomeDirectory = null;
    static File aliceUserDirectory = null;
    static SplashScreen splashScreen;
    static boolean stdOutToConsole;
    static boolean stdErrToConsole;
    static String defaultRendererClassname;
    public static AuthoringTool authoringTool;
    static boolean mainHasFinished;
    public static boolean isApplet;

    static {
        stdOutToConsole = false;
        stdErrToConsole = false;
        defaultRendererClassname = null;
        mainHasFinished = false;
        isApplet = false;
    }

    public static void main(String[] args) {
        isApplet = false;
        JAlice.principal();
    }

    public void init() {
        isApplet = true;
        JAlice.principal();
        String exString = this.getParameter("MA_PARAM_Proposition");
        authoringTool.loadAppletWorld(exString);
        this.setJMenuBar(authoringTool.getJAliceFrame().getJMenuBar());
        this.add(authoringTool.getJAliceFrame().getContentPane());
    }

    public static String getAnswer() {
        return AppletWorldStorer.getWorldXml(authoringTool.getWorld());
    }

    private static void principal() {
        try {
            splashScreen = JAlice.initSplashScreen();
            if (!isApplet) {
                splashScreen.showSplash();
                try {
                    File aliceHasNotExitedFile = new File(JAlice.getAliceUserDirectory(), "aliceHasNotExited.txt");
                    if (aliceHasNotExitedFile.exists()) {
                        aliceHasNotExitedFile.delete();
                    }
                    aliceHasNotExitedFile.createNewFile();
                    OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(aliceHasNotExitedFile));
                    writer.write("Alice has not exited propertly yet.");
                    writer.flush();
                    writer.close();
                }
                catch (Exception aliceHasNotExitedFile) {
                    // empty catch block
                }
            }
            authoringTool = new AuthoringTool(stdOutToConsole, stdErrToConsole);
            splashScreen.hideSplash();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        mainHasFinished = true;
    }

    private static SplashScreen initSplashScreen() {
        return new SplashScreen();
    }

    public static boolean isMainFinished() {
        return mainHasFinished;
    }

    public static void setAliceHomeDirectory(File file) {
        aliceHomeDirectory = file;
    }

    public static File getAliceHomeDirectory() {
        if (aliceHomeDirectory == null) {
            if (System.getProperty("alice.home") != null) {
                JAlice.setAliceHomeDirectory(new File(System.getProperty("alice.home")).getAbsoluteFile());
            } else {
                JAlice.setAliceHomeDirectory(new File(System.getProperty("user.dir")).getAbsoluteFile());
            }
        }
        return aliceHomeDirectory;
    }

    public static void setAliceUserDirectory(File file) {
        aliceUserDirectory = file;
    }

    public static File getAliceUserDirectory() {
        if (aliceUserDirectory == null) {
            File dirFromProperties = null;
            if (System.getProperty("alice.userDir") != null) {
                dirFromProperties = new File(System.getProperty("alice.userDir")).getAbsoluteFile();
            }
            File userHome = new File(System.getProperty("user.home")).getAbsoluteFile();
            File aliceHome = JAlice.getAliceHomeDirectory();
            File aliceUser = null;
            if (dirFromProperties != null) {
                aliceUser = dirFromProperties;
            } else if (userHome.exists() && userHome.canRead() && userHome.canWrite()) {
                aliceUser = new File(userHome, ".alice");
            } else if (aliceHome != null && aliceHome.exists() && aliceHome.canRead() && aliceHome.canWrite()) {
                aliceUser = new File(aliceHome, ".alice");
            }
            if (aliceUser != null) {
                if (aliceUser.exists()) {
                    JAlice.setAliceUserDirectory(aliceUser);
                } else if (aliceUser.mkdir()) {
                    JAlice.setAliceUserDirectory(aliceUser);
                }
            }
        }
        return aliceUserDirectory;
    }
}

