/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.io.ZipFileTreeLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class ZipFileTreeStorer
implements DirectoryTreeStorer {
    private static final int ENDSIG = 101010256;
    private static final int HEADSIG = 33639248;
    private static final int LOCHEADSIG = 67324752;
    private static final int DATADESCSIG = 134695760;
    private static final int SIG = 1;
    private static final int MADEBY = 2;
    private static final int VERNEEDED = 3;
    private static final int BITFLAG = 4;
    private static final int COMPMETH = 5;
    private static final int MODTIME = 6;
    private static final int CRC32 = 8;
    private static final int COMPSIZE = 9;
    private static final int UNCOMPSIZE = 10;
    private static final int NAMELENGTH = 11;
    private static final int EXTRALENGTH = 12;
    private static final int COMLENGTH = 13;
    private static final int DISKSTART = 14;
    private static final int INTATTRIB = 15;
    private static final int EXTATTRIB = 16;
    private static final int OFFSET = 17;
    private static final int FILENAME = 18;
    private static final int EXTRAFIELD = 19;
    private static final int COMMENT = 20;
    private static final int compressionBitFlag = 0;
    private static final int compressionMethodValue = 8;
    private static final int BITFLAG_DEFAULT = 0;
    private byte[] endHeader;
    private Vector centralDirectory;
    private int centralDirectoryLocation;
    private String currentFile = null;
    private File rootFile;
    private CRC32 crc = new CRC32();
    private Vector holes;
    private Vector toWrite = new Vector();
    private ByteArrayOutputStream m_currentlyOpenStream = null;
    private boolean outputStreamOpen = false;
    private RandomAccessFile m_randomAccessFile = null;
    private HashMap filenameToHeaderMap;
    private boolean newZip = false;
    private boolean allOpen = false;
    private boolean shouldCompressCurrent = true;
    private int lastEntry = -1;
    private int timeStamp = -1;
    private String currentDirectory;
    private HoleComparator holeComparator = new HoleComparator();
    private HeaderSizeComparator headerSizeComparator = new HeaderSizeComparator();
    private HeaderLocationComparator headerLocationComparator = new HeaderLocationComparator();

    private static long getCurrentDosTime() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        if (n < 1980) {
            return 0x210000L;
        }
        return n - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
    }

    private void writeInt(int n, int n2, int n3) throws IOException {
        int n4 = 255;
        this.m_randomAccessFile.seek(n);
        for (int i = 0; i < n3; ++i) {
            this.m_randomAccessFile.writeByte(n4 & n2);
            n2 >>= 8;
        }
    }

    private void writeString(int n, String string) throws IOException {
        this.m_randomAccessFile.seek(n);
        this.m_randomAccessFile.write(string.getBytes());
    }

    public void setCurrentDirectory(String string) throws IllegalArgumentException {
        if (string == null) {
            string = "";
        } else if (string.length() > 0) {
            int n;
            string = string.replace('\\', '/');
            while ((n = string.indexOf("//")) != -1) {
                string = string.substring(0, n + 1) + string.substring(n + 2);
            }
            if (!(string = string.charAt(0) == '/' ? string.substring(1) : this.currentDirectory + string).endsWith("/")) {
                string = string + "/";
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
        }
        this.currentDirectory = string;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    protected boolean isCompressed() {
        return true;
    }

    public void openForUpdate(Object object) throws IllegalArgumentException, IOException {
        this.open(object);
        for (int i = 0; i < this.centralDirectory.size(); ++i) {
            ((CentralDirectoryHeader)this.centralDirectory.get((int)i)).shouldDelete = false;
        }
    }

    public void open(Object object) throws IllegalArgumentException, IOException {
        if (this.allOpen) {
            this.close();
        }
        if (object instanceof String) {
            this.m_randomAccessFile = new RandomAccessFile((String)object, "rw");
            this.rootFile = new File((String)object);
        } else if (object instanceof File) {
            this.m_randomAccessFile = new RandomAccessFile((File)object, "rw");
            this.rootFile = (File)object;
        } else {
            if (object instanceof OutputStream) {
                throw new IllegalArgumentException("pathname must be an instance of String or java.io.File");
            }
            if (object == null) {
                throw new IllegalArgumentException("pathname is null");
            }
            throw new IllegalArgumentException("pathname must be an instance of String or java.io.File");
        }
        if (this.m_randomAccessFile.length() <= 0L) {
            this.newZip = true;
        }
        this.currentDirectory = "";
        this.m_currentlyOpenStream = null;
        if (!this.newZip) {
            try {
                this.setAtEndSig();
            }
            catch (IOException iOException) {
                this.newZip = true;
            }
        }
        this.timeStamp = (int)ZipFileTreeStorer.getCurrentDosTime();
        this.initCentralDirectory();
        this.setEnd();
        this.allOpen = true;
    }

    private void findHoles() {
        this.lastEntry = -1;
        if (this.centralDirectory != null) {
            this.holes = new Vector();
            for (int i = 0; i < this.centralDirectory.size() - 1; ++i) {
                CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)this.centralDirectory.get(i);
                CentralDirectoryHeader centralDirectoryHeader2 = (CentralDirectoryHeader)this.centralDirectory.get(i + 1);
                int n = 30 + centralDirectoryHeader.fileNameLength + centralDirectoryHeader.extraFieldLength + centralDirectoryHeader.compressedSize;
                int n2 = centralDirectoryHeader.relativeOffset + n;
                if (n2 >= centralDirectoryHeader2.relativeOffset) continue;
                LocalizedVacuity localizedVacuity = new LocalizedVacuity(n2, centralDirectoryHeader2.relativeOffset - n2);
                this.holes.add(localizedVacuity);
            }
            if (this.centralDirectory.size() == 0) {
                this.lastEntry = 0;
            } else {
                int n;
                CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)this.centralDirectory.get(this.centralDirectory.size() - 1);
                int n3 = 30 + centralDirectoryHeader.fileNameLength + centralDirectoryHeader.extraFieldLength + centralDirectoryHeader.compressedSize;
                this.lastEntry = n = centralDirectoryHeader.relativeOffset + n3;
                Collections.sort(this.holes, this.holeComparator);
            }
        }
    }

    private void fillHoles() {
        this.findHoles();
        for (int i = 0; i < this.holes.size(); ++i) {
            LocalizedVacuity localizedVacuity = (LocalizedVacuity)this.holes.get(i);
            byte[] byArray = new byte[localizedVacuity.size];
            try {
                this.writeValue(byArray, 0, localizedVacuity.size, localizedVacuity.pos);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setEnd() {
        this.lastEntry = 0;
        if (this.centralDirectory != null && this.centralDirectory.size() > 0) {
            int n;
            CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)this.centralDirectory.get(this.centralDirectory.size() - 1);
            int n2 = centralDirectoryHeader.getLocalHeaderSpace();
            this.lastEntry = n = centralDirectoryHeader.relativeOffset + n2;
        }
    }

    private void updateHeader(CentralDirectoryHeader centralDirectoryHeader, byte[] byArray, boolean bl) throws IOException {
        int n = 0;
        int n2 = centralDirectoryHeader.compressedSize;
        int n3 = 0;
        if (byArray != null) {
            n3 = byArray.length;
            this.crc.reset();
            this.crc.update(byArray);
            if (centralDirectoryHeader.shouldCompress) {
                byArray = this.compressData(byArray);
            }
            n = byArray.length;
        }
        centralDirectoryHeader.crc32 = (int)this.crc.getValue();
        centralDirectoryHeader.compressedSize = n;
        centralDirectoryHeader.uncompressedSize = n3;
        if (centralDirectoryHeader.localHeaderReference != null) {
            centralDirectoryHeader.localHeaderReference.crc32 = (int)this.crc.getValue();
            centralDirectoryHeader.localHeaderReference.compressedSize = n;
            centralDirectoryHeader.localHeaderReference.uncompressedSize = n3;
        }
        if (n > n2 && !bl) {
            centralDirectoryHeader.setShouldDelete(true);
            centralDirectoryHeader.data = byArray;
            this.toWrite.add(centralDirectoryHeader);
            this.centralDirectory.remove(centralDirectoryHeader);
        } else {
            centralDirectoryHeader.data = null;
            if (bl) {
                centralDirectoryHeader.localHeaderReference.writeAll();
            } else {
                centralDirectoryHeader.localHeaderReference.writeData(8);
                centralDirectoryHeader.localHeaderReference.writeData(9);
                centralDirectoryHeader.localHeaderReference.writeData(10);
                centralDirectoryHeader.localHeaderReference.writeData(6);
            }
            this.writeValue(byArray, 0, n, centralDirectoryHeader.relativeOffset + centralDirectoryHeader.localHeaderReference.getThisHeaderSpace());
            if (centralDirectoryHeader.localHeaderReference.needsDataDescriptor() && centralDirectoryHeader.localHeaderReference.hasDataDescriptor) {
                centralDirectoryHeader.localHeaderReference.writeDataDescriptor();
            }
        }
    }

    private byte[] compressData(byte[] byArray) {
        int n;
        Deflater deflater = new Deflater(-1, true);
        deflater.setInput(byArray);
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[512];
        while (!deflater.needsInput()) {
            n = deflater.deflate(byArray2, 0, byArray2.length);
            if (n > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            n2 += n;
        }
        deflater.finish();
        while (!deflater.finished()) {
            n = deflater.deflate(byArray2, 0, byArray2.length);
            if (n > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            n2 += n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int getUnsigned(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    private long getValue(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = n2 - 1; i >= 0; --i) {
            int n3 = this.getUnsigned(byArray[n + i]);
            l += (long)n3;
            if (i == 0) continue;
            l <<= 8;
        }
        return l;
    }

    private void writeValue(byte[] byArray, int n, int n2, int n3) throws IOException {
        if (byArray != null) {
            try {
                this.m_randomAccessFile.seek(n3);
                this.m_randomAccessFile.write(byArray, n, n2);
            }
            catch (Exception exception) {
                throw new IOException("An error occurred while writing to the zip file. The file may not have been saved properly.");
            }
        }
    }

    private String getString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append((char)this.getUnsigned(byArray[n + i]));
        }
        return stringBuffer.toString();
    }

    private void initCentralDirectory() throws IOException {
        this.centralDirectory = new Vector();
        this.filenameToHeaderMap = new HashMap();
        if (this.newZip) {
            return;
        }
        int n = (int)this.getValue(this.endHeader, 12, 4);
        long l = this.getValue(this.endHeader, 16, 4);
        int n2 = 0;
        this.centralDirectoryLocation = (int)l;
        byte[] byArray = new byte[n];
        try {
            this.m_randomAccessFile.seek(l);
            this.m_randomAccessFile.readFully(byArray, 0, n);
        }
        catch (IOException iOException) {
            this.newZip = true;
            return;
        }
        n2 = 0;
        int n3 = 46;
        while (n2 < byArray.length) {
            if (n2 + 46 >= byArray.length) {
                n2 = byArray.length;
                break;
            }
            CentralDirectoryHeader centralDirectoryHeader = null;
            try {
                centralDirectoryHeader = new CentralDirectoryHeader(n2, this.centralDirectoryLocation, byArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.centralDirectory = new Vector();
                this.filenameToHeaderMap = new HashMap();
                this.newZip = true;
                return;
            }
            n2 += centralDirectoryHeader.size;
            centralDirectoryHeader.setShouldDelete(true);
            this.centralDirectory.add(centralDirectoryHeader);
            this.filenameToHeaderMap.put(centralDirectoryHeader.fileName, centralDirectoryHeader);
            try {
                centralDirectoryHeader.localHeaderReference = this.initLocalHeader(centralDirectoryHeader);
            }
            catch (IOException iOException) {
                this.centralDirectory = new Vector();
                this.filenameToHeaderMap = new HashMap();
                this.newZip = true;
                return;
            }
            if (n2 + 46 >= byArray.length) {
                n2 = byArray.length;
                break;
            }
            if (this.getValue(byArray, n2, 4) == 33639248L) continue;
            n2 -= n3 + 1;
            while (n2 + 3 < byArray.length && this.getValue(byArray, n2, 4) != 33639248L) {
                ++n2;
            }
        }
        Collections.sort(this.centralDirectory, this.headerLocationComparator);
    }

    private LocalHeader initLocalHeader(CentralDirectoryHeader centralDirectoryHeader) throws IOException {
        int n = centralDirectoryHeader.relativeOffset;
        int n2 = centralDirectoryHeader.fileNameLength + centralDirectoryHeader.extraFieldLength + 30;
        byte[] byArray = new byte[n2];
        LocalHeader localHeader = null;
        this.m_randomAccessFile.seek(n);
        this.m_randomAccessFile.readFully(byArray, 0, n2);
        localHeader = new LocalHeader(n, centralDirectoryHeader, byArray);
        this.m_randomAccessFile.seek(localHeader.getThisHeaderSpace() + localHeader.compressedSize);
        byte[] byArray2 = new byte[4];
        this.m_randomAccessFile.readFully(byArray2, 0, 4);
        if (this.getValue(byArray2, 0, 4) == 134695760L) {
            localHeader.hasDataDescriptor = true;
        }
        return localHeader;
    }

    private void setAtEndSig() throws IOException {
        long l;
        long l2 = l = this.m_randomAccessFile.length();
        int n = 22;
        int n2 = 65535;
        byte[] byArray = new byte[n * 2];
        Arrays.fill(byArray, (byte)0);
        while (l2 - l < (long)n2) {
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                byArray[n3 + n] = byArray[n3];
            }
            this.m_randomAccessFile.seek(l -= (long)n);
            this.m_randomAccessFile.readFully(byArray, 0, n);
            for (n3 = 0; n3 < n * 2 - 3; ++n3) {
                int n4;
                long l3;
                if (this.getValue(byArray, n3, 4) != 101010256L || (l3 = l + (long)n3) + (long)(n4 = (int)this.getValue(byArray, n3 + 20, 2)) + (long)n != l2) continue;
                this.endHeader = new byte[n4 + n];
                this.m_randomAccessFile.seek(l3);
                this.m_randomAccessFile.readFully(this.endHeader, n3, n4 + n);
                return;
            }
        }
        throw new IOException("End header not found");
    }

    private CentralDirectoryHeader getHeader(String string) {
        if (this.newZip) {
            return null;
        }
        return (CentralDirectoryHeader)this.filenameToHeaderMap.get(string);
    }

    private void writeHeader(CentralDirectoryHeader centralDirectoryHeader, int n) throws IOException {
        centralDirectoryHeader.relativeOffset = n;
        centralDirectoryHeader.localHeaderReference.position = n;
        if (centralDirectoryHeader.data != null) {
            this.crc.reset();
            this.crc.update(centralDirectoryHeader.data);
        }
        centralDirectoryHeader.localHeaderReference.writeAll();
        if (centralDirectoryHeader.data != null) {
            this.writeValue(centralDirectoryHeader.data, 0, centralDirectoryHeader.data.length, centralDirectoryHeader.localHeaderReference.position + centralDirectoryHeader.localHeaderReference.getThisHeaderSpace());
        }
        if (centralDirectoryHeader.localHeaderReference.needsDataDescriptor()) {
            centralDirectoryHeader.localHeaderReference.writeDataDescriptor();
        }
    }

    private boolean placeHeader(CentralDirectoryHeader centralDirectoryHeader) throws IOException {
        for (int i = 0; i < this.holes.size(); ++i) {
            LocalizedVacuity localizedVacuity = (LocalizedVacuity)this.holes.get(i);
            if (localizedVacuity.size < centralDirectoryHeader.getLocalHeaderSpace()) continue;
            this.writeHeader(centralDirectoryHeader, localizedVacuity.pos);
            this.holes.remove(localizedVacuity);
            return true;
        }
        return false;
    }

    private void placeHeaders() throws IOException {
        Collections.sort(this.toWrite, this.headerSizeComparator);
        this.findHoles();
        boolean bl = true;
        for (int i = 0; i < this.toWrite.size(); ++i) {
            CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)this.toWrite.get(i);
            if (bl) {
                bl = this.placeHeader(centralDirectoryHeader);
            }
            if (!bl) {
                int n = centralDirectoryHeader.getLocalHeaderSpace();
                this.writeHeader(centralDirectoryHeader, this.lastEntry);
                this.lastEntry += n;
            }
            if (this.centralDirectory.contains(centralDirectoryHeader)) continue;
            this.centralDirectory.add(centralDirectoryHeader);
        }
        if (this.toWrite.size() > 0) {
            Collections.sort(this.centralDirectory, this.headerLocationComparator);
        }
    }

    private void writeCentralDirectoryAndEndHeader() throws IOException {
        int n;
        this.newZip = false;
        this.setEnd();
        int n2 = n = this.lastEntry;
        int n3 = 0;
        int n4 = this.centralDirectory.size();
        for (int i = 0; i < n4; ++i) {
            CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)this.centralDirectory.get(i);
            centralDirectoryHeader.position = n2;
            centralDirectoryHeader.writeAll();
            n2 += centralDirectoryHeader.getThisHeaderSpace();
            n3 += centralDirectoryHeader.getThisHeaderSpace();
        }
        this.writeInt(n2, 101010256, 4);
        this.writeInt(n2 + 4, 0, 2);
        this.writeInt(n2 + 6, 0, 2);
        this.writeInt(n2 + 8, n4, 2);
        this.writeInt(n2 + 10, n4, 2);
        this.writeInt(n2 + 12, n3, 4);
        this.writeInt(n2 + 16, n, 4);
        this.writeInt(n2 + 20, 0, 2);
        this.m_randomAccessFile.setLength(n2 + 22);
    }

    private void deleteDirectories() {
        Iterator iterator = this.centralDirectory.iterator();
        while (iterator.hasNext()) {
            CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)iterator.next();
            if (!centralDirectoryHeader.shouldDelete) continue;
            iterator.remove();
        }
    }

    public void close() throws IOException {
        if (this.outputStreamOpen) {
            this.closeCurrentFile();
        }
        this.deleteDirectories();
        this.placeHeaders();
        this.writeCentralDirectoryAndEndHeader();
        this.fillHoles();
        this.allOpen = false;
        this.m_randomAccessFile.close();
        this.endHeader = null;
        this.centralDirectory = null;
    }

    public OutputStream createFile(String string) throws IllegalArgumentException, IOException {
        return this.createFile(string, true);
    }

    public OutputStream createFile(String string, boolean bl) throws IllegalArgumentException, IOException {
        this.shouldCompressCurrent = bl;
        if (this.m_randomAccessFile != null) {
            if (this.outputStreamOpen) {
                this.closeCurrentFile();
            }
        } else {
            throw new IOException("No zip file currently open");
        }
        this.m_currentlyOpenStream = new ByteArrayOutputStream();
        this.currentFile = string;
        this.outputStreamOpen = true;
        return this.m_currentlyOpenStream;
    }

    public void keepFile(String string) throws KeepFileNotSupportedException {
        if (this.newZip) {
            throw new KeepFileNotSupportedException();
        }
        String string2 = this.currentDirectory + string;
        CentralDirectoryHeader centralDirectoryHeader = this.getHeader(string2);
        if (centralDirectoryHeader == null) {
            throw new RuntimeException("Could not keep file \"" + string2 + "\"");
        }
        centralDirectoryHeader.setShouldDelete(false);
    }

    public boolean isKeepFileSupported() {
        return !this.newZip;
    }

    public void createDirectory(String string) throws IllegalArgumentException, IOException {
        if (string.indexOf(47) != -1 || string.indexOf(92) != -1) {
            throw new IllegalArgumentException("pathname cannot contain path separators");
        }
        if (string.length() <= 0) {
            throw new IllegalArgumentException("pathname has no length");
        }
    }

    public void checkAndUpdateHeader(String string, byte[] byArray) throws IOException {
        CentralDirectoryHeader centralDirectoryHeader = this.getHeader(string);
        if (centralDirectoryHeader != null) {
            centralDirectoryHeader.setShouldDelete(false);
            if (byArray != null) {
                centralDirectoryHeader.lastModTime = this.timeStamp;
                centralDirectoryHeader.localHeaderReference.lastModTime = this.timeStamp;
                this.updateHeader(centralDirectoryHeader, byArray, false);
            }
        } else {
            centralDirectoryHeader = new CentralDirectoryHeader();
            centralDirectoryHeader.localHeaderReference = new LocalHeader();
            centralDirectoryHeader.setCompression(this.shouldCompressCurrent);
            centralDirectoryHeader.lastModTime = this.timeStamp;
            centralDirectoryHeader.localHeaderReference.lastModTime = this.timeStamp;
            centralDirectoryHeader.setFileName(string);
            if (this.newZip) {
                centralDirectoryHeader.position = this.lastEntry;
                centralDirectoryHeader.relativeOffset = this.lastEntry;
                centralDirectoryHeader.localHeaderReference.position = this.lastEntry;
                this.updateHeader(centralDirectoryHeader, byArray, true);
                this.centralDirectory.add(centralDirectoryHeader);
                this.lastEntry += centralDirectoryHeader.getLocalHeaderSpace();
            } else {
                this.updateHeader(centralDirectoryHeader, byArray, false);
            }
        }
    }

    public void closeCurrentFile() throws IOException {
        String string = this.currentDirectory + this.currentFile;
        this.outputStreamOpen = false;
        this.checkAndUpdateHeader(string, this.m_currentlyOpenStream.toByteArray());
        this.m_currentlyOpenStream.close();
    }

    private boolean doesFileExist(String string) {
        for (int i = 0; i < this.centralDirectory.size(); ++i) {
            CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)this.centralDirectory.get(i);
            if (!centralDirectoryHeader.fileName.equals(this.currentDirectory + string)) continue;
            return true;
        }
        return false;
    }

    public Object getKeepKey(String string) {
        if (this.newZip || !this.doesFileExist(string)) {
            return null;
        }
        return ZipFileTreeLoader.getKeepKey(this.rootFile, this.currentDirectory, string);
    }

    public void inspectZipFile() {
        this.findHoles();
    }

    private class HeaderLocationComparator
    implements Comparator {
        private HeaderLocationComparator() {
        }

        public int compare(Object object, Object object2) {
            CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)object;
            CentralDirectoryHeader centralDirectoryHeader2 = (CentralDirectoryHeader)object2;
            return centralDirectoryHeader.relativeOffset - centralDirectoryHeader2.relativeOffset;
        }
    }

    private class HeaderSizeComparator
    implements Comparator {
        private HeaderSizeComparator() {
        }

        public int compare(Object object, Object object2) {
            CentralDirectoryHeader centralDirectoryHeader = (CentralDirectoryHeader)object;
            CentralDirectoryHeader centralDirectoryHeader2 = (CentralDirectoryHeader)object2;
            int n = centralDirectoryHeader.getLocalHeaderSpace();
            int n2 = centralDirectoryHeader2.getLocalHeaderSpace();
            return n - n2;
        }
    }

    private class HoleComparator
    implements Comparator {
        private HoleComparator() {
        }

        public int compare(Object object, Object object2) {
            LocalizedVacuity localizedVacuity = (LocalizedVacuity)object;
            LocalizedVacuity localizedVacuity2 = (LocalizedVacuity)object2;
            return localizedVacuity.size - localizedVacuity2.size;
        }
    }

    private class LocalizedVacuity {
        public int pos;
        public int size;

        public LocalizedVacuity(int n, int n2) {
            this.pos = n;
            this.size = n2;
        }

        public String toString() {
            return "position: " + String.valueOf(this.pos) + ", size: " + String.valueOf(this.size);
        }
    }

    private class LocalHeader {
        public int position;
        public int size;
        public int sig = 67324752;
        public int versionNeededToExtract = 20;
        public int bitFlag = 0;
        public int compressionMethod = 8;
        public int lastModTime = 0;
        public int crc32 = 0;
        public int compressedSize = -1;
        public int uncompressedSize = -1;
        public int fileNameLength = 0;
        public int extraFieldLength = 0;
        public String fileName = "";
        public String extraField = "";
        public boolean hasDataDescriptor = false;

        public LocalHeader() {
        }

        public LocalHeader(int n, CentralDirectoryHeader centralDirectoryHeader, byte[] byArray) throws IllegalArgumentException {
            this.position = n;
            if (byArray != null && byArray.length > 30) {
                this.sig = (int)ZipFileTreeStorer.this.getValue(byArray, 0, 4);
                if (this.sig != 67324752) {
                    throw new IllegalArgumentException();
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.versionNeededToExtract = (int)ZipFileTreeStorer.this.getValue(byArray, 4, 2);
            this.bitFlag = (int)ZipFileTreeStorer.this.getValue(byArray, 6, 2);
            this.compressionMethod = (int)ZipFileTreeStorer.this.getValue(byArray, 8, 2);
            this.lastModTime = (int)ZipFileTreeStorer.this.getValue(byArray, 10, 4);
            this.crc32 = (int)ZipFileTreeStorer.this.getValue(byArray, 14, 4);
            this.compressedSize = (int)ZipFileTreeStorer.this.getValue(byArray, 18, 4);
            this.uncompressedSize = (int)ZipFileTreeStorer.this.getValue(byArray, 22, 4);
            this.fileNameLength = (int)ZipFileTreeStorer.this.getValue(byArray, 26, 2);
            this.extraFieldLength = (int)ZipFileTreeStorer.this.getValue(byArray, 28, 2);
            this.fileName = ZipFileTreeStorer.this.getString(byArray, 30, this.fileNameLength);
            this.extraField = ZipFileTreeStorer.this.getString(byArray, 30 + this.fileNameLength, this.extraFieldLength);
            this.size = this.fileNameLength + this.extraFieldLength + 30;
            this.hasDataDescriptor = false;
        }

        public int getThisHeaderSpace() {
            return 30 + this.fileNameLength + this.extraFieldLength;
        }

        public boolean needsDataDescriptor() {
            return (this.bitFlag & 8) > 0;
        }

        public void writeData(int n) throws IOException {
            switch (n) {
                case 1: {
                    ZipFileTreeStorer.this.writeInt(this.position + 0, this.sig, 4);
                    break;
                }
                case 3: {
                    ZipFileTreeStorer.this.writeInt(this.position + 4, this.versionNeededToExtract, 2);
                    break;
                }
                case 4: {
                    ZipFileTreeStorer.this.writeInt(this.position + 6, this.bitFlag, 2);
                    break;
                }
                case 5: {
                    ZipFileTreeStorer.this.writeInt(this.position + 8, this.compressionMethod, 2);
                    break;
                }
                case 6: {
                    ZipFileTreeStorer.this.writeInt(this.position + 10, this.lastModTime, 4);
                    break;
                }
                case 8: {
                    ZipFileTreeStorer.this.writeInt(this.position + 14, this.crc32, 4);
                    break;
                }
                case 9: {
                    ZipFileTreeStorer.this.writeInt(this.position + 18, this.compressedSize, 4);
                    break;
                }
                case 10: {
                    ZipFileTreeStorer.this.writeInt(this.position + 22, this.uncompressedSize, 4);
                    break;
                }
                case 11: {
                    ZipFileTreeStorer.this.writeInt(this.position + 26, this.fileNameLength, 2);
                    break;
                }
                case 12: {
                    ZipFileTreeStorer.this.writeInt(this.position + 28, this.extraFieldLength, 2);
                    break;
                }
                case 18: {
                    ZipFileTreeStorer.this.writeString(this.position + 30, this.fileName);
                    break;
                }
                case 19: {
                    ZipFileTreeStorer.this.writeString(this.position + 30 + this.fileName.length(), this.extraField);
                    break;
                }
            }
        }

        public void writeAll() throws IOException {
            for (int i = 1; i <= 20; ++i) {
                this.writeData(i);
            }
        }

        public void writeDataDescriptor() throws IOException {
            int n = this.position + this.getThisHeaderSpace() + this.compressedSize;
            ZipFileTreeStorer.this.writeInt(n, 134695760, 4);
            ZipFileTreeStorer.this.writeInt(n + 4, this.crc32, 4);
            ZipFileTreeStorer.this.writeInt(n + 8, this.compressedSize, 4);
            ZipFileTreeStorer.this.writeInt(n + 12, this.uncompressedSize, 4);
        }

        public String toString() {
            String string = "";
            string = string + "position in file: " + String.valueOf(this.position) + "\n";
            string = string + "size: " + String.valueOf(this.size) + "\n";
            string = string + "sig: " + String.valueOf(this.sig) + "\n";
            string = string + "version made: " + String.valueOf(this.versionNeededToExtract) + "\n";
            string = string + "bit flag: " + String.valueOf(this.bitFlag) + "\n";
            string = string + "compression method: " + String.valueOf(this.compressionMethod) + "\n";
            string = string + "las mod time: " + String.valueOf(this.lastModTime) + "\n";
            string = string + "crc-32: " + String.valueOf(this.crc32) + "\n";
            string = string + "compressed size: " + String.valueOf(this.compressedSize) + "\n";
            string = string + "uncompressed size: " + String.valueOf(this.uncompressedSize) + "\n";
            string = string + "file name length: " + String.valueOf(this.fileNameLength) + "\n";
            string = string + "extra field length: " + String.valueOf(this.extraFieldLength) + "\n";
            string = string + "local header file name: " + this.fileName + " spans from " + String.valueOf(this.position) + " to " + String.valueOf(this.position + this.getThisHeaderSpace() + this.compressedSize) + "\n";
            string = string + "extra field: " + this.extraField + "\n";
            string = this.hasDataDescriptor ? string + "There IS a data descriptor\n" : string + "There ISN'T a data descriptor\n";
            return string;
        }
    }

    private class CentralDirectoryHeader {
        public int position;
        public int size;
        boolean shouldDelete = false;
        public LocalHeader localHeaderReference;
        public boolean shouldCompress = true;
        public byte[] data = null;
        public int sig = 33639248;
        public int versionMadeBy = 20;
        public int versionNeededToExtract = 20;
        public int bitFlag = 0;
        public int compressionMethod = 8;
        public int lastModTime = 0;
        public int crc32 = 0;
        public int compressedSize = -1;
        public int uncompressedSize = -1;
        public int fileNameLength = 0;
        public int extraFieldLength = 0;
        public int fileCommentLength = 0;
        public int diskNumberStart = 0;
        public int internalFileAttributes = 0;
        public int externalFileAttributes = 0;
        public int relativeOffset = 0;
        public String fileName = "";
        public String extraField = "";
        public String comment = "";

        public CentralDirectoryHeader() {
        }

        public CentralDirectoryHeader(int n, int n2, byte[] byArray) throws IllegalArgumentException {
            this.position = n2 + n;
            if (byArray != null && byArray.length > 42 + n) {
                this.sig = (int)ZipFileTreeStorer.this.getValue(byArray, n, 4);
                if (this.sig != 33639248) {
                    throw new IllegalArgumentException();
                }
            } else {
                throw new IllegalArgumentException();
            }
            this.versionMadeBy = (int)ZipFileTreeStorer.this.getValue(byArray, n + 4, 2);
            this.versionNeededToExtract = (int)ZipFileTreeStorer.this.getValue(byArray, n + 6, 2);
            this.bitFlag = (int)ZipFileTreeStorer.this.getValue(byArray, n + 8, 2);
            this.compressionMethod = (int)ZipFileTreeStorer.this.getValue(byArray, n + 10, 2);
            this.lastModTime = (int)ZipFileTreeStorer.this.getValue(byArray, n + 12, 4);
            this.crc32 = (int)ZipFileTreeStorer.this.getValue(byArray, n + 16, 4);
            this.compressedSize = (int)ZipFileTreeStorer.this.getValue(byArray, n + 20, 4);
            this.uncompressedSize = (int)ZipFileTreeStorer.this.getValue(byArray, n + 24, 4);
            this.fileNameLength = (int)ZipFileTreeStorer.this.getValue(byArray, n + 28, 2);
            this.extraFieldLength = (int)ZipFileTreeStorer.this.getValue(byArray, n + 30, 2);
            this.fileCommentLength = (int)ZipFileTreeStorer.this.getValue(byArray, n + 32, 2);
            this.diskNumberStart = (int)ZipFileTreeStorer.this.getValue(byArray, n + 34, 2);
            this.internalFileAttributes = (int)ZipFileTreeStorer.this.getValue(byArray, n + 36, 2);
            this.externalFileAttributes = (int)ZipFileTreeStorer.this.getValue(byArray, n + 38, 4);
            this.relativeOffset = (int)ZipFileTreeStorer.this.getValue(byArray, n + 42, 4);
            this.fileName = ZipFileTreeStorer.this.getString(byArray, n + 46, this.fileNameLength);
            this.extraField = ZipFileTreeStorer.this.getString(byArray, n + 46 + this.fileNameLength, this.extraFieldLength);
            this.comment = ZipFileTreeStorer.this.getString(byArray, n + 46 + this.fileNameLength + this.extraFieldLength, this.fileCommentLength);
            this.size = this.fileNameLength + this.extraFieldLength + this.fileCommentLength + 46;
            this.shouldCompress = this.compressionMethod != 0;
        }

        public void setCompression(boolean bl) {
            this.shouldCompress = bl;
            if (this.shouldCompress) {
                this.bitFlag = 0;
                this.compressionMethod = 8;
                if (this.localHeaderReference != null) {
                    this.localHeaderReference.bitFlag = this.bitFlag;
                    this.localHeaderReference.compressionMethod = this.compressionMethod;
                }
            } else {
                this.bitFlag = 0;
                this.compressionMethod = 0;
                if (this.localHeaderReference != null) {
                    this.localHeaderReference.bitFlag = 0;
                    this.localHeaderReference.compressionMethod = 0;
                }
            }
        }

        public int getLocalHeaderSpace() {
            if ((this.bitFlag & 8) > 0 && this.localHeaderReference != null && this.localHeaderReference.hasDataDescriptor) {
                return 30 + this.fileNameLength + this.extraFieldLength + this.compressedSize + 16;
            }
            return 30 + this.fileNameLength + this.extraFieldLength + this.compressedSize;
        }

        public int getThisHeaderSpace() {
            return 46 + this.fileNameLength + this.extraFieldLength + this.fileCommentLength;
        }

        public void writeData(int n) throws IOException {
            switch (n) {
                case 1: {
                    ZipFileTreeStorer.this.writeInt(this.position + 0, this.sig, 4);
                    break;
                }
                case 2: {
                    ZipFileTreeStorer.this.writeInt(this.position + 4, this.versionMadeBy, 2);
                    break;
                }
                case 3: {
                    ZipFileTreeStorer.this.writeInt(this.position + 6, this.versionNeededToExtract, 2);
                    break;
                }
                case 4: {
                    ZipFileTreeStorer.this.writeInt(this.position + 8, this.bitFlag, 2);
                    break;
                }
                case 5: {
                    ZipFileTreeStorer.this.writeInt(this.position + 10, this.compressionMethod, 2);
                    break;
                }
                case 6: {
                    ZipFileTreeStorer.this.writeInt(this.position + 12, this.lastModTime, 4);
                    break;
                }
                case 8: {
                    ZipFileTreeStorer.this.writeInt(this.position + 16, this.crc32, 4);
                    break;
                }
                case 9: {
                    ZipFileTreeStorer.this.writeInt(this.position + 20, this.compressedSize, 4);
                    break;
                }
                case 10: {
                    ZipFileTreeStorer.this.writeInt(this.position + 24, this.uncompressedSize, 4);
                    break;
                }
                case 11: {
                    ZipFileTreeStorer.this.writeInt(this.position + 28, this.fileNameLength, 2);
                    break;
                }
                case 12: {
                    ZipFileTreeStorer.this.writeInt(this.position + 30, this.extraFieldLength, 2);
                    break;
                }
                case 13: {
                    ZipFileTreeStorer.this.writeInt(this.position + 32, this.fileCommentLength, 2);
                    break;
                }
                case 14: {
                    ZipFileTreeStorer.this.writeInt(this.position + 34, this.diskNumberStart, 2);
                    break;
                }
                case 15: {
                    ZipFileTreeStorer.this.writeInt(this.position + 36, this.internalFileAttributes, 2);
                    break;
                }
                case 16: {
                    ZipFileTreeStorer.this.writeInt(this.position + 38, this.externalFileAttributes, 4);
                    break;
                }
                case 17: {
                    ZipFileTreeStorer.this.writeInt(this.position + 42, this.relativeOffset, 4);
                    break;
                }
                case 18: {
                    ZipFileTreeStorer.this.writeString(this.position + 46, this.fileName);
                    break;
                }
                case 19: {
                    ZipFileTreeStorer.this.writeString(this.position + 46 + this.fileName.length(), this.extraField);
                    break;
                }
                case 20: {
                    ZipFileTreeStorer.this.writeString(this.position + 46 + this.fileName.length() + this.extraField.length(), this.comment);
                    break;
                }
            }
        }

        public void writeAll() throws IOException {
            for (int i = 1; i <= 20; ++i) {
                this.writeData(i);
            }
        }

        public void setShouldDelete(boolean bl) {
            this.shouldDelete = bl;
        }

        public void setFileName(String string) {
            this.fileName = new String(string);
            this.fileNameLength = this.fileName.length();
            if (this.localHeaderReference != null) {
                this.localHeaderReference.fileName = new String(this.fileName);
                this.localHeaderReference.fileNameLength = this.fileName.length();
            }
        }

        public String toString() {
            String string = "";
            string = string + "position in file: " + String.valueOf(this.position) + "\n";
            string = string + "size: " + String.valueOf(this.size) + "\n";
            string = string + "sig: " + String.valueOf(this.sig) + "\n";
            string = string + "version made: " + String.valueOf(this.versionMadeBy) + "\n";
            string = string + "version needed: " + String.valueOf(this.versionNeededToExtract) + "\n";
            string = string + "bit flag: " + String.valueOf(this.bitFlag) + "\n";
            string = string + "compression method: " + String.valueOf(this.compressionMethod) + "\n";
            string = string + "las mod time: " + String.valueOf(this.lastModTime) + "\n";
            string = string + " crc-32: " + String.valueOf(this.crc32) + "\n";
            string = string + "compressed size: " + String.valueOf(this.compressedSize) + "\n";
            string = string + "uncompressed size: " + String.valueOf(this.uncompressedSize) + "\n";
            string = string + "file name length: " + String.valueOf(this.fileNameLength) + "\n";
            string = string + "extra field length: " + String.valueOf(this.extraFieldLength) + "\n";
            string = string + "comment length: " + String.valueOf(this.fileCommentLength) + "\n";
            string = string + "disk number start: " + String.valueOf(this.diskNumberStart) + "\n";
            string = string + "internal attrib: " + String.valueOf(this.internalFileAttributes) + "\n";
            string = string + "external attrib: " + String.valueOf(this.externalFileAttributes) + "\n";
            string = string + "relative offset for local header: " + String.valueOf(this.relativeOffset) + "\n";
            string = string + "file name: " + this.fileName + ", spans from " + String.valueOf(this.position) + " to " + String.valueOf(this.position + this.getThisHeaderSpace()) + "\n";
            string = string + "extra field: " + this.extraField + "\n";
            string = string + "comment: " + this.comment;
            return string;
        }
    }
}

