/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileTreeLoader
implements DirectoryTreeLoader {
    private Hashtable m_pathnameToZipEntryMap = new Hashtable();
    private File m_rootFile = null;
    private ZipFile m_zipFile = null;
    private String m_currentDirectory = null;
    private InputStream m_currentlyOpenStream = null;

    private static String getCanonicalPathname(String string) {
        int n;
        string = string.replace('\\', '/');
        while ((n = string.indexOf("//")) != -1) {
            string = string.substring(0, n + 1) + string.substring(n + 2);
        }
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    public void open(Object object) throws IllegalArgumentException, IOException {
        if (this.m_zipFile != null) {
            this.close();
        }
        if (object instanceof String) {
            this.m_rootFile = new File((String)object);
        } else if (object instanceof File) {
            this.m_rootFile = (File)object;
        } else {
            if (object == null) {
                throw new IllegalArgumentException("pathname is null");
            }
            throw new IllegalArgumentException("pathname must be an instance of String or java.io.File");
        }
        this.m_zipFile = new ZipFile(this.m_rootFile);
        this.m_currentDirectory = "";
        this.m_currentlyOpenStream = null;
        this.m_pathnameToZipEntryMap.clear();
        Enumeration<? extends ZipEntry> enumeration = this.m_zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            this.m_pathnameToZipEntryMap.put(ZipFileTreeLoader.getCanonicalPathname(zipEntry.getName()), zipEntry);
        }
    }

    public void close() throws IOException {
        if (this.m_zipFile != null) {
            this.closeCurrentFile();
            this.m_zipFile.close();
            this.m_zipFile = null;
        }
    }

    public void setCurrentDirectory(String string) throws IllegalArgumentException {
        if (string == null) {
            string = "";
        } else if (string.length() > 0) {
            if (string.charAt(0) != '/' && string.charAt(0) != '\\') {
                string = this.m_currentDirectory + string;
            }
            if (!(string = ZipFileTreeLoader.getCanonicalPathname(string)).endsWith("/")) {
                string = string + "/";
            }
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
        }
        this.m_currentDirectory = string;
    }

    public String getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    public InputStream readFile(String string) throws IllegalArgumentException, IOException {
        this.closeCurrentFile();
        String string2 = ZipFileTreeLoader.getCanonicalPathname(this.m_currentDirectory + string);
        ZipEntry zipEntry = (ZipEntry)this.m_pathnameToZipEntryMap.get(string2);
        if (zipEntry != null) {
            this.m_currentlyOpenStream = this.m_zipFile.getInputStream(zipEntry);
            return this.m_currentlyOpenStream;
        }
        throw new FileNotFoundException("Not Found: " + string2);
    }

    public void closeCurrentFile() throws IOException {
        if (this.m_currentlyOpenStream != null) {
            this.m_currentlyOpenStream.close();
            this.m_currentlyOpenStream = null;
        }
    }

    public String[] getFilesInCurrentDirectory() {
        throw new RuntimeException("not implemented");
    }

    public String[] getDirectoriesInCurrentDirectory() {
        throw new RuntimeException("not implemented");
    }

    public boolean isKeepFileSupported() {
        return true;
    }

    static Object getKeepKey(File file, String string, String string2) {
        return file.getAbsolutePath() + "____" + string + string2;
    }

    public Object getKeepKey(String string) {
        return ZipFileTreeLoader.getKeepKey(this.m_rootFile, this.m_currentDirectory, string);
    }
}

