/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FileSystemTreeLoader
implements DirectoryTreeLoader {
    protected File root = null;
    protected File currentDirectory = null;
    protected InputStream currentlyOpenStream = null;

    public void open(Object object) throws IllegalArgumentException, FileNotFoundException, IOException {
        if (this.root != null) {
            this.close();
        }
        if (object instanceof String) {
            this.root = new File((String)object);
        } else if (object instanceof File) {
            this.root = (File)object;
        } else {
            throw new IllegalArgumentException("pathname must be an instance of String or java.io.File");
        }
        if (this.root.exists()) {
            if (!this.root.canRead()) {
                throw new IOException("cannot read " + this.root);
            }
        } else {
            throw new FileNotFoundException(this.root + " does not exist");
        }
        this.currentDirectory = this.root;
    }

    public void close() throws IOException {
        this.closeCurrentFile();
        this.root = null;
        this.currentDirectory = null;
    }

    public void setCurrentDirectory(String string) throws IllegalArgumentException {
        File file = string.length() == 0 || string.charAt(0) == '/' || string.charAt(0) == '\\' ? new File(this.root.getAbsolutePath() + string) : new File(this.currentDirectory.getAbsolutePath() + "/" + string);
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " doesn't exist");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " isn't a directory");
        }
        this.currentDirectory = file;
    }

    public String getCurrentDirectory() {
        return this.getRelativePathname(this.currentDirectory);
    }

    public InputStream readFile(String string) throws FileNotFoundException, IOException {
        this.closeCurrentFile();
        File file = new File(this.currentDirectory, string);
        if (!file.exists()) {
            throw new FileNotFoundException(file + " does not exist");
        }
        if (!file.canRead()) {
            throw new IOException("cannot read " + file);
        }
        this.currentlyOpenStream = new FileInputStream(file);
        return this.currentlyOpenStream;
    }

    public void closeCurrentFile() throws IOException {
        if (this.currentlyOpenStream != null) {
            this.currentlyOpenStream.close();
            this.currentlyOpenStream = null;
        }
    }

    public String[] getFilesInCurrentDirectory() {
        File[] fileArray = this.currentDirectory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isFile();
            }
        });
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = this.getRelativePathname(fileArray[i]);
        }
        return stringArray;
    }

    public String[] getDirectoriesInCurrentDirectory() {
        File[] fileArray = this.currentDirectory.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = this.getRelativePathname(fileArray[i]);
        }
        return stringArray;
    }

    protected String getRelativePathname(File file) {
        StringBuffer stringBuffer = new StringBuffer(file.getAbsolutePath());
        stringBuffer.delete(0, this.root.getAbsolutePath().length());
        return stringBuffer.toString();
    }

    public boolean isKeepFileSupported() {
        return true;
    }

    static Object getKeepKey(File file, String string) {
        return new File(file, string).getAbsolutePath();
    }

    public Object getKeepKey(String string) throws KeepFileNotSupportedException {
        return FileSystemTreeLoader.getKeepKey(this.currentDirectory, string);
    }
}

