/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.visualization;

import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.Visualization;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import java.util.Vector;

public abstract class CollectionOfModelsVisualization
extends Visualization {
    private Vector m_bins = new Vector();
    private Variable m_itemsVariable = null;

    public void unhook(Model model) {
        int n = this.indexOf(model, 0);
        if (n != -1) {
            this.set(n, null);
        }
    }

    protected String getItemsName() {
        return "items";
    }

    private Variable getItemsVariable() {
        if (this.m_itemsVariable == null) {
            this.m_itemsVariable = (Variable)this.getChildNamed(this.getItemsName());
        }
        return this.m_itemsVariable;
    }

    public Collection getItemsCollection() {
        return (Collection)this.getItemsVariable().value.getValue();
    }

    public Model[] getItems() {
        return (Model[])this.getItemsCollection().values.getArrayValue();
    }

    public void setItems(Model[] modelArray) {
        this.getItemsCollection().values.set(modelArray);
    }

    private Model getPrototype() {
        return (Model)this.getChildNamed("BinPrototype");
    }

    private int getBinCount() {
        return this.m_bins.size();
    }

    private Model getBinAt(int n) {
        return (Model)this.m_bins.get(n);
    }

    private void setBinAt(int n, Model model) {
        if (this.m_bins.size() == n) {
            this.m_bins.addElement(model);
        } else {
            if (this.m_bins.size() < n) {
                this.m_bins.ensureCapacity(n + 1);
            }
            this.m_bins.set(n, model);
        }
    }

    private void synchronize(Model[] modelArray) {
        int n = this.getBinCount();
        for (int i = n - 1; i >= modelArray.length; --i) {
            Model model = this.getBinAt(i);
            this.m_bins.remove(model);
        }
        Model model = this.getPrototype();
        if (model != null) {
            for (int i = n; i < modelArray.length; ++i) {
                Class[] classArray = new Class[]{};
                String string = "Sub" + i;
                Model model2 = (Model)this.getChildNamed(string);
                if (model2 == null) {
                    model2 = (Model)model.HACK_createCopy(string, this, -1, classArray, null);
                }
                this.setBinAt(i, model2);
            }
            n = this.getBinCount();
        }
    }

    public Model get(int n) {
        return (Model)this.getItemsCollection().values.get(n);
    }

    public void set(int n, Model model) {
        this.getItemsCollection().values.set(n, model);
    }

    public int indexOf(Model model, int n) {
        return this.getItemsCollection().values.indexOf(model, n);
    }

    public int lastIndexOf(Model model, int n) {
        return this.getItemsCollection().values.lastIndexOf(model, n);
    }

    public boolean contains(Model model) {
        return this.getItemsCollection().values.contains(model);
    }

    public int size() {
        return this.getItemsCollection().values.size();
    }

    public boolean isEmpty() {
        return this.getItemsCollection().values.isEmpty();
    }

    protected void loadCompleted() {
        super.loadCompleted();
        Collection collection = this.getItemsCollection();
        if (collection != null) {
            collection.values.addPropertyListener(new PropertyListener(){

                public void propertyChanging(PropertyEvent propertyEvent) {
                }

                public void propertyChanged(PropertyEvent propertyEvent) {
                    CollectionOfModelsVisualization.this.synchronize((Model[])propertyEvent.getValue());
                }
            });
            this.synchronize(this.getItems());
        } else {
            System.err.println("WARNING: collection is null " + this);
        }
    }
}

