/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;

public abstract class WorldListener {
    private World m_world;
    private ChildrenListener m_childrenListener = new ChildrenListener(){

        public void childrenChanging(ChildrenEvent childrenEvent) {
            WorldListener.this.handleChildrenChanging(childrenEvent);
        }

        public void childrenChanged(ChildrenEvent childrenEvent) {
            if (childrenEvent.getChangeType() == 1) {
                WorldListener.this.hookUp(childrenEvent.getChild());
            } else if (childrenEvent.getChangeType() == 3) {
                WorldListener.this.unhookUp(childrenEvent.getChild());
            }
            WorldListener.this.handleChildrenChanged(childrenEvent);
        }
    };
    private PropertyListener m_propertyListener = new PropertyListener(){

        public void propertyChanging(PropertyEvent propertyEvent) {
            WorldListener.this.handlePropertyChanging(propertyEvent);
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            WorldListener.this.handlePropertyChanged(propertyEvent);
        }
    };
    private ObjectArrayPropertyListener m_objectArrayPropertyListener = new ObjectArrayPropertyListener(){

        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
            WorldListener.this.handleObjectArrayPropertyChanging(objectArrayPropertyEvent);
        }

        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
            WorldListener.this.handleObjectArrayPropertyChanged(objectArrayPropertyEvent);
        }
    };

    protected abstract void handleChildrenChanging(ChildrenEvent var1);

    protected abstract void handleChildrenChanged(ChildrenEvent var1);

    protected abstract void handlePropertyChanging(PropertyEvent var1);

    protected abstract void handlePropertyChanged(PropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanging(ObjectArrayPropertyEvent var1);

    protected abstract void handleObjectArrayPropertyChanged(ObjectArrayPropertyEvent var1);

    protected abstract boolean isPropertyListeningRequired(Property var1);

    protected abstract boolean isObjectArrayPropertyListeningRequired(ObjectArrayProperty var1);

    public World getWorld() {
        return this.m_world;
    }

    public void setWorld(World world) {
        if (this.m_world != world) {
            if (this.m_world != null) {
                this.unhookUp(this.m_world);
            }
            this.m_world = world;
            if (this.m_world != null) {
                this.hookUp(this.m_world);
            }
        }
    }

    private boolean isChildrenListenerHookedUp(Element element) {
        ChildrenListener[] childrenListenerArray = element.getChildrenListeners();
        int n = childrenListenerArray != null ? childrenListenerArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (childrenListenerArray[i] != this.m_childrenListener) continue;
            return true;
        }
        return false;
    }

    private boolean isPropertyListenerHookedUp(Property property) {
        PropertyListener[] propertyListenerArray = property.getPropertyListeners();
        int n = propertyListenerArray != null ? propertyListenerArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (propertyListenerArray[i] != this.m_propertyListener) continue;
            return true;
        }
        return false;
    }

    private boolean isObjectArrayPropertyListenerHookedUp(ObjectArrayProperty objectArrayProperty) {
        ObjectArrayPropertyListener[] objectArrayPropertyListenerArray = objectArrayProperty.getObjectArrayPropertyListeners();
        int n = objectArrayPropertyListenerArray != null ? objectArrayPropertyListenerArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (objectArrayPropertyListenerArray[i] != this.m_objectArrayPropertyListener) continue;
            return true;
        }
        return false;
    }

    private void unhookUp(Element element) {
        Property[] propertyArray;
        if (this.isChildrenListenerHookedUp(element)) {
            element.removeChildrenListener(this.m_childrenListener);
        }
        int n = (propertyArray = element.getProperties()) != null ? propertyArray.length : 0;
        for (int i = 0; i < n; ++i) {
            ObjectArrayProperty objectArrayProperty;
            if (this.isPropertyListeningRequired(propertyArray[i]) && this.isPropertyListenerHookedUp(propertyArray[i])) {
                propertyArray[i].removePropertyListener(this.m_propertyListener);
            }
            if (!(propertyArray[i] instanceof ObjectArrayProperty) || !this.isObjectArrayPropertyListeningRequired(objectArrayProperty = (ObjectArrayProperty)propertyArray[i]) || !this.isObjectArrayPropertyListenerHookedUp(objectArrayProperty)) continue;
            objectArrayProperty.removeObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
        }
        Element[] elementArray = element.getChildren();
        n = elementArray != null ? elementArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.unhookUp(elementArray[i]);
        }
    }

    private void hookUp(Element element) {
        if (!this.isChildrenListenerHookedUp(element)) {
            element.addChildrenListener(this.m_childrenListener);
        }
        Property[] propertyArray = element.getProperties();
        int n = propertyArray != null ? propertyArray.length : 0;
        for (int i = 0; i < n; ++i) {
            ObjectArrayProperty objectArrayProperty;
            if (this.isPropertyListeningRequired(propertyArray[i]) && !this.isPropertyListenerHookedUp(propertyArray[i])) {
                propertyArray[i].addPropertyListener(this.m_propertyListener);
            }
            if (!(propertyArray[i] instanceof ObjectArrayProperty) || !this.isObjectArrayPropertyListeningRequired(objectArrayProperty = (ObjectArrayProperty)propertyArray[i]) || this.isObjectArrayPropertyListenerHookedUp(objectArrayProperty)) continue;
            objectArrayProperty.addObjectArrayPropertyListener(this.m_objectArrayPropertyListener);
        }
        Element[] elementArray = element.getChildren();
        n = elementArray != null ? elementArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.hookUp(elementArray[i]);
        }
    }
}

