/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.reference;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceResolver;
import edu.cmu.cs.stage3.alice.core.UnresolvableReferenceException;
import edu.cmu.cs.stage3.alice.core.criterion.ElementKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.ExternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.InternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.util.Criterion;

public class DefaultReferenceResolver
implements ReferenceResolver {
    private Element m_internalRoot;
    private Element m_externalRoot;

    public DefaultReferenceResolver(Element element, Element element2) {
        this.m_internalRoot = element;
        this.m_externalRoot = element2;
    }

    public Element getInternalRoot() {
        return this.m_internalRoot;
    }

    public void setInternalRoot(Element element) {
        this.m_internalRoot = element;
    }

    public Element getExternalRoot() {
        return this.m_externalRoot;
    }

    public void setExternalRoot(Element element) {
        this.m_externalRoot = element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element resolveReference(Criterion criterion) throws UnresolvableReferenceException {
        if (!(criterion instanceof ElementKeyedCriterion)) throw new UnresolvableReferenceException(criterion, "must be ElementKeyedCriterion");
        String string = ((ElementKeyedCriterion)criterion).getKey();
        Element element = null;
        if (criterion instanceof InternalReferenceKeyedCriterion) {
            element = this.m_internalRoot.getDescendantKeyedIgnoreCase(string);
        } else if (criterion instanceof ExternalReferenceKeyedCriterion) {
            if (this.m_externalRoot == null) throw new UnresolvableReferenceException(criterion, "external root is null");
            element = this.m_externalRoot.getDescendantKeyedIgnoreCase(string);
        } else {
            Element element2 = this.m_externalRoot != null ? this.m_externalRoot : this.m_internalRoot;
            int n = string.indexOf(46);
            String string2 = n == -1 ? "" : string.substring(n + 1);
            element = element2.getDescendantKeyedIgnoreCase(string2);
        }
        if (element == null) throw new UnresolvableReferenceException(criterion, "internal root: " + this.m_internalRoot + " external root: " + this.m_externalRoot);
        return element;
    }
}

