/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceResolver;
import edu.cmu.cs.stage3.alice.core.UnresolvableReferenceException;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceResolver;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.util.StrUtilities;
import java.io.StringReader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class AppletWorldLoader {
    public static final String URL_ENCODE = "ISO-8859-1";
    private static final int MAX_DATA = 1000;
    public static final String _CDATA = "_CDATA_";
    public static final String _CDATA_INIT = "_CDATA_INIT";
    public static final String _CDATA_END = "_CDATA_END";
    public static final String FIRST_CDATA_INIT = "1_CDATA_INIT";
    public static final String FIRST_CDATA_END = "1_CDATA_END";

    private static Element loadElement(String string, Vector vector) throws Exception {
        String string2;
        if (string == null || string.length() < 2) {
            return null;
        }
        string = string.replaceAll(FIRST_CDATA_INIT, "<![CDATA[");
        string = string.replaceAll(FIRST_CDATA_END, "]]>");
        int n = -1;
        for (int i = 2; i < 1000 && (n = string.indexOf(i + _CDATA)) >= 0; ++i) {
            string = string.replaceAll(i + _CDATA, i - 1 + _CDATA);
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inputSource = new InputSource();
        inputSource.setCharacterStream(new StringReader(string));
        Document document = null;
        try {
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            String string3 = "";
            if (exception instanceof SAXParseException) {
                string3 = "lin=" + ((SAXParseException)exception).getLineNumber() + ": col=" + ((SAXParseException)exception).getColumnNumber();
            }
            System.err.println("Error: AppletWorldLoader.java: loadElement(...): failed to load some iVprog content: " + string3 + "\n" + exception.toString());
            return null;
        }
        org.w3c.dom.Element element = null;
        try {
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            string2 = "";
            if (exception instanceof SAXParseException) {
                string2 = "lin=" + ((SAXParseException)exception).getLineNumber() + ": col=" + ((SAXParseException)exception).getColumnNumber();
            }
            System.err.println("Error: AppletWorldLoader.java: loadElement(...): failed to get some object " + document + ": " + string2 + "\n" + exception.toString());
        }
        element.normalize();
        String string4 = element.getAttribute("class");
        string2 = element.getAttribute("name");
        Class<?> clazz = null;
        Element element2 = null;
        try {
            String string5;
            Object object;
            Object object2;
            clazz = Class.forName(string4);
            String string6 = clazz.toString();
            element2 = (Element)clazz.newInstance();
            if (string2.length() > 0) {
                element2.name.set(string2);
            }
            NodeList nodeList = element.getElementsByTagName("property");
            int n2 = nodeList.getLength();
            for (int i = 0; i < n2; ++i) {
                org.w3c.dom.Element element3 = (org.w3c.dom.Element)nodeList.item(i);
                object2 = element3.getAttribute("name").trim();
                object = element2.getPropertyNamed((String)object2);
                if (object == null || element3 == null) continue;
                try {
                    ((Property)object).decode(element3, vector);
                    continue;
                }
                catch (Exception exception) {
                    string5 = element3.getLocalName() + "," + element3.getNodeName() + "," + element3.getNodeValue();
                    System.err.println("Error: AppletWorldLoader.java: loadElement(...): property " + i + "/" + n2 + ": propertyNode=" + element3 + ": " + string5 + ": " + exception.toString());
                }
            }
            NodeList nodeList2 = element.getElementsByTagName("child");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                try {
                    object2 = (org.w3c.dom.Element)nodeList2.item(i);
                    object = object2.getChildNodes().item(0).getNodeValue();
                    Element element4 = AppletWorldLoader.loadElement((String)object, vector);
                    if (element4 == null) continue;
                    string5 = element4.name.getStringValue();
                    if (string5 != null && element2.getChildNamed(string5) != null) {
                        System.err.println("Error: AppletWorldLoader.java: " + element2 + " already has child named \"" + string5 + "\".  skipping.");
                        element4 = null;
                    }
                    if (element4 == null) continue;
                    element2.addChild(element4);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Error: AppletWorldLoader.java: loadElement(...): propertyNodeList=" + StrUtilities.getComponentName(nodeList2) + ": " + exception.toString());
                    exception.printStackTrace();
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionWrapper(classNotFoundException, "ClassNotFoundException: " + string4);
        }
        catch (InstantiationException instantiationException) {
            throw new ExceptionWrapper(instantiationException, "InstantiationException: " + string4);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExceptionWrapper(illegalAccessException, "IllegalAccessException: " + string4);
        }
        return element2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element loadWorld(String string) throws Exception {
        Object[] objectArray;
        string = URLDecoder.decode(string, URL_ENCODE);
        Vector vector = new Vector();
        Vector<PropertyReference> vector2 = new Vector<PropertyReference>();
        Element element = null;
        string = string.replaceAll(FIRST_CDATA_INIT, "<![CDATA[");
        string = string.replaceAll(FIRST_CDATA_END, "]]>");
        try {
            element = AppletWorldLoader.loadElement(string, vector);
            if (element == null) {
                System.err.println("Error: AppletWorldLoader.java: loadWorld(String): 'element' vazio, try: " + element);
            }
            objectArray = new DefaultReferenceResolver(element, element);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                PropertyReference propertyReference = (PropertyReference)enumeration.nextElement();
                try {
                    if (propertyReference == null || objectArray == null) continue;
                    propertyReference.resolve((ReferenceResolver)objectArray);
                }
                catch (UnresolvableReferenceException unresolvableReferenceException) {
                    vector2.add(propertyReference);
                    System.err.println("Error: AppletWorldLoader.java: loadWorld(String): element=" + element + ", propertyReference=" + propertyReference);
                }
                catch (Throwable throwable) {
                    System.err.println(propertyReference);
                    throwable.printStackTrace();
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        if (vector2.size() == 0) {
            if (element != null) {
                element.loadCompleted();
            }
            return element;
        }
        try {
            objectArray = new PropertyReference[vector2.size()];
            vector2.copyInto(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }
}

