/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class VariablesViewController
extends GroupingPanel
implements GUIElement,
Releasable {
    protected ObjectArrayProperty variables;
    protected RefreshListener refreshListener = new RefreshListener();
    protected boolean sleeping = false;

    public VariablesViewController() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(null);
    }

    public void set(ObjectArrayProperty objectArrayProperty) {
        this.clean();
        this.variables = objectArrayProperty;
        if (!this.sleeping) {
            this.startListening();
        }
        this.refreshGUI();
    }

    public void goToSleep() {
        if (!this.sleeping) {
            this.stopListening();
            this.sleeping = true;
        }
    }

    public void wakeUp() {
        if (this.sleeping) {
            this.startListening();
            this.sleeping = false;
        }
    }

    public void die() {
        this.clean();
    }

    public void clean() {
        this.stopListening();
        this.removeAll();
        this.variables = null;
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }

    public void refreshGUI() {
        this.removeAll();
        Object[] objectArray = this.variables.getArrayValue();
        int n = objectArray != null ? objectArray.length : 0;
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)objectArray[i];
            if (variable == null) continue;
            JComponent jComponent = null;
            SetPropertyImmediatelyFactory setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(variable.value);
            jComponent = GUIFactory.getPropertyViewController(variable.value, true, true, false, setPropertyImmediatelyFactory);
            this.add(jComponent);
        }
    }

    protected void startListening() {
        if (this.variables != null) {
            this.variables.addObjectArrayPropertyListener(this.refreshListener);
            Object[] objectArray = this.variables.getArrayValue();
            int n = objectArray != null ? objectArray.length : 0;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) continue;
                ((Variable)objectArray[i]).name.addPropertyListener(this.refreshListener);
            }
        }
    }

    protected void stopListening() {
        if (this.variables != null) {
            this.variables.removeObjectArrayPropertyListener(this.refreshListener);
            Object[] objectArray = this.variables.getArrayValue();
            int n = objectArray != null ? objectArray.length : 0;
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) continue;
                ((Variable)objectArray[i]).name.removePropertyListener(this.refreshListener);
            }
        }
    }

    class RefreshListener
    implements ObjectArrayPropertyListener,
    PropertyListener {
        RefreshListener() {
        }

        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        }

        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
            Variable variable;
            if (objectArrayPropertyEvent.getChangeType() == 1) {
                Variable variable2 = (Variable)objectArrayPropertyEvent.getItem();
                if (variable2 != null) {
                    variable2.name.addPropertyListener(this);
                }
            } else if (objectArrayPropertyEvent.getChangeType() == 3 && (variable = (Variable)objectArrayPropertyEvent.getItem()) != null) {
                variable.name.removePropertyListener(this);
            }
            VariablesViewController.this.refreshGUI();
        }

        public void propertyChanging(PropertyEvent propertyEvent) {
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            VariablesViewController.this.refreshGUI();
        }
    }
}

