/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.alice.core.IllegalNameValueException;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class VariableDnDPanel
extends DnDGroupingPanel
implements GUIElement,
Releasable {
    protected AuthoringTool authoringTool;
    protected Variable variable;
    protected JLabel nameLabel = new JLabel();
    protected JTextField textField = new JTextField();
    protected FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            VariableDnDPanel.this.stopEditing();
        }
    };
    protected Vector popupStructure = new Vector();
    protected NamePropertyListener namePropertyListener = new NamePropertyListener();
    static /* synthetic */ Class class$edu$cmu$cs$stage3$alice$core$List;

    public String getNameLabel() {
        return "<name=" + this.nameLabel.getName() + ",text=" + this.nameLabel.getText() + ": " + this.textField.getText() + ">";
    }

    public VariableDnDPanel() {
        this.setBackground(AuthoringToolResources.getColor("variableDnDPanel"));
        this.add((Component)this.nameLabel, "Center");
        this.addDragSourceComponent(this.nameLabel);
        CustomMouseAdapter customMouseAdapter = new CustomMouseAdapter(){

            public void popupResponse(MouseEvent mouseEvent) {
                VariableDnDPanel.this.updatePopupStructure();
                PopupMenuUtilities.createAndShowPopupMenu(VariableDnDPanel.this.popupStructure, VariableDnDPanel.this, mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.addMouseListener(customMouseAdapter);
        this.nameLabel.addMouseListener(customMouseAdapter);
        this.grip.addMouseListener(customMouseAdapter);
        this.textField.setColumns(5);
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableDnDPanel.this.stopEditing();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    VariableDnDPanel.this.cancelEditing();
                }
            }
        });
    }

    public void set(AuthoringTool authoringTool, Variable variable) {
        if (this.variable != null) {
            this.variable.name.removePropertyListener(this.namePropertyListener);
        }
        this.authoringTool = authoringTool;
        this.variable = variable;
        this.nameLabel.setText(AuthoringToolResources.getReprForValue(variable));
        if (variable != null) {
            Object object;
            String string = (class$edu$cmu$cs$stage3$alice$core$List == null ? (class$edu$cmu$cs$stage3$alice$core$List = VariableDnDPanel.class$("edu.cmu.cs.stage3.alice.core.List")) : class$edu$cmu$cs$stage3$alice$core$List).isAssignableFrom(variable.getValueClass()) ? ((object = (List)variable.getValue()) != null ? "types/lists/" + ((List)object).valueClass.getClassValue().getName() : "types/lists") : "types/" + variable.getValueClass().getName();
            object = AuthoringToolResources.getIconForValue(string);
            if (object == null) {
                object = (class$edu$cmu$cs$stage3$alice$core$List == null ? (class$edu$cmu$cs$stage3$alice$core$List = VariableDnDPanel.class$("edu.cmu.cs.stage3.alice.core.List")) : class$edu$cmu$cs$stage3$alice$core$List).isAssignableFrom(variable.getValueClass()) ? AuthoringToolResources.getIconForValue("types/lists/other") : AuthoringToolResources.getIconForValue("types/other");
            }
            if (object != null) {
                this.nameLabel.setIcon((Icon)object);
            }
            Transferable transferable = TransferableFactory.createTransferable(variable);
            this.setTransferable(transferable);
            DnDManager.setCurrentTransferable(transferable);
            variable.name.addPropertyListener(this.namePropertyListener);
        } else {
            this.setTransferable(null);
        }
    }

    public void editName() {
        if (this.variable.name.getStringValue() != null) {
            this.textField.setText(this.variable.name.getStringValue());
        }
        if (this.isAncestorOf(this.nameLabel)) {
            this.remove(this.nameLabel);
        }
        if (!this.isAncestorOf(this.textField)) {
            this.add((Component)this.textField, "Center");
        }
        this.textField.requestFocus();
        this.textField.addFocusListener(this.focusListener);
        this.revalidate();
    }

    public void stopEditing() {
        String string = this.variable.name.getStringValue();
        this.textField.removeFocusListener(this.focusListener);
        String string2 = this.textField.getText();
        try {
            this.variable.name.set(string2);
            this.remove(this.textField);
            this.add((Component)this.nameLabel, "Center");
            this.nameLabel.requestFocus();
        }
        catch (IllegalNameValueException illegalNameValueException) {
            DialogManager.showMessageDialog(illegalNameValueException.getMessage(), "Error setting name", 0);
            this.textField.setText(string);
        }
        this.revalidate();
    }

    public void cancelEditing() {
        this.textField.removeFocusListener(this.focusListener);
        this.remove(this.textField);
        this.add((Component)this.nameLabel, "Center");
        this.revalidate();
    }

    public void updatePopupStructure() {
        this.popupStructure.clear();
        if (this.variable != null) {
            this.popupStructure.add(new StringObjectPair(I18n.getString("msg_rename"), new Runnable(){

                public void run() {
                    VariableDnDPanel.this.editName();
                }
            }));
            final WatcherPanel watcherPanel = this.authoringTool.getWatcherPanel();
            if (watcherPanel.isVariableBeingWatched(this.variable)) {
                this.popupStructure.add(new StringObjectPair(I18n.getString("varDnD_stopWatching"), new Runnable(){

                    public void run() {
                        watcherPanel.removeVariableBeingWatched(VariableDnDPanel.this.variable);
                    }
                }));
            } else {
                this.popupStructure.add(new StringObjectPair(I18n.getString("varDnD_watchThis"), new Runnable(){

                    public void run() {
                        watcherPanel.addVariableToWatch(VariableDnDPanel.this.variable);
                    }
                }));
            }
            this.popupStructure.add(new StringObjectPair(I18n.getString("msg_del"), new Runnable(){

                public void run() {
                    ElementPopupUtilities.DeleteRunnable deleteRunnable = new ElementPopupUtilities.DeleteRunnable(VariableDnDPanel.this.variable);
                    deleteRunnable.run();
                }
            }));
        }
    }

    public void goToSleep() {
    }

    public void wakeUp() {
    }

    public void clean() {
        this.setTransferable(null);
    }

    public void die() {
        this.clean();
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class NamePropertyListener
    implements PropertyListener {
        NamePropertyListener() {
        }

        public void propertyChanging(PropertyEvent propertyEvent) {
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            VariableDnDPanel.this.nameLabel.setText(VariableDnDPanel.this.variable.name.getStringValue());
        }
    }
}

