/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ObjectArrayPropertyItemTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyItem;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TrashComponent
extends JPanel
implements DropTargetListener {
    protected ImageIcon trashOpenIcon = AuthoringToolResources.getIconForValue("trashOpen");
    protected ImageIcon trashClosedIcon = AuthoringToolResources.getIconForValue("trashClosed");
    protected JLabel trashLabel = new JLabel(this.trashClosedIcon);
    protected AuthoringTool authoringTool;
    protected boolean paintDropPotential = false;
    protected DropPotentialFeedbackListener dropPotentialFeedbackListener = new DropPotentialFeedbackListener();
    protected boolean beingDroppedOn = false;

    public TrashComponent(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.add((Component)this.trashLabel, "Center");
        this.setDropTarget(new DropTarget(this, this));
        this.trashLabel.setDropTarget(new DropTarget(this.trashLabel, this));
        DnDManager.addListener(this.dropPotentialFeedbackListener);
        this.setToolTipText("<html><font face=arial size=-1>Trash<p><p>Drag and drop tiles here to delete them.</font></html>");
        this.addMouseListener(new CustomMouseAdapter(){

            public void singleClickResponse(MouseEvent mouseEvent) {
                DialogManager.showMessageDialog(TrashComponent.this.getToolTipText());
            }
        });
    }

    public Dimension getMaximumSize() {
        return this.trashLabel.getMaximumSize();
    }

    public void paintComponent(Graphics graphics) {
        if (this.paintDropPotential) {
            Dimension dimension = this.getSize();
            if (this.beingDroppedOn) {
                graphics.setColor(AuthoringToolResources.getColor("dndHighlight2"));
            } else {
                graphics.setColor(AuthoringToolResources.getColor("dndHighlight"));
            }
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        }
        super.paintComponent(graphics);
    }

    protected boolean checkTransferable(Transferable transferable) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            bl = AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.elementReferenceFlavor);
        }
        catch (Exception exception) {
            System.err.println("Error: TrashComponent.java: " + exception.toString());
        }
        try {
            bl2 = AuthoringToolResources.safeIsDataFlavorSupported(transferable, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor);
        }
        catch (Exception exception) {
            System.err.println("Error: TrashComponent.java: " + exception.toString());
        }
        try {
            bl3 = AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor);
        }
        catch (Exception exception) {
            System.err.println("Error: TrashComponent.java: " + exception.toString());
        }
        try {
            bl4 = AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
        }
        catch (Exception exception) {
            System.err.println("Error: TrashComponent.java: " + exception.toString());
        }
        return bl || bl2 || bl3 || bl4;
    }

    protected boolean checkDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ElementReferenceTransferable.elementReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
            dropTargetDragEvent.acceptDrag(2);
            this.trashLabel.setIcon(this.trashOpenIcon);
            return true;
        }
        dropTargetDragEvent.rejectDrag();
        return false;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        System.out.println("\n\nTrashComponent.java: dragEnter(DropTargeDragEvent): checkDrag=" + this.checkDrag(dropTargetDragEvent));
        if (this.checkDrag(dropTargetDragEvent)) {
            this.beingDroppedOn = true;
            this.repaint();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.beingDroppedOn) {
            this.beingDroppedOn = false;
            this.repaint();
        }
        this.trashLabel.setIcon(this.trashClosedIcon);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.checkDrag(dropTargetDragEvent)) {
            this.beingDroppedOn = false;
            this.repaint();
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, ElementReferenceTransferable.elementReferenceFlavor)) {
                dropTargetDropEvent.acceptDrop(2);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                Element element = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
                ElementPopupUtilities.DeleteRunnable deleteRunnable = new ElementPopupUtilities.DeleteRunnable(element);
                deleteRunnable.run();
                dropTargetDropEvent.dropComplete(true);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                dropTargetDropEvent.acceptDrop(2);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype = (CallToUserDefinedResponsePrototype)transferable.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor);
                ElementPopupUtilities.DeleteRunnable deleteRunnable = new ElementPopupUtilities.DeleteRunnable(callToUserDefinedResponsePrototype.getActualResponse());
                deleteRunnable.run();
                dropTargetDropEvent.dropComplete(true);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                dropTargetDropEvent.acceptDrop(2);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype = (CallToUserDefinedQuestionPrototype)transferable.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
                ElementPopupUtilities.DeleteRunnable deleteRunnable = new ElementPopupUtilities.DeleteRunnable(callToUserDefinedQuestionPrototype.getActualQuestion());
                deleteRunnable.run();
                dropTargetDropEvent.dropComplete(true);
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
                dropTargetDropEvent.acceptDrop(2);
                Transferable transferable = dropTargetDropEvent.getTransferable();
                ObjectArrayPropertyItem objectArrayPropertyItem = (ObjectArrayPropertyItem)transferable.getTransferData(ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor);
                objectArrayPropertyItem.objectArrayProperty.remove(objectArrayPropertyItem.getIndex());
                dropTargetDropEvent.dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
                dropTargetDropEvent.dropComplete(false);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
            dropTargetDropEvent.dropComplete(false);
        }
        catch (IOException iOException) {
            AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
            dropTargetDropEvent.dropComplete(false);
        }
        catch (Throwable throwable) {
            AuthoringTool.getInstance().showErrorDialog("Drop didn't work.", throwable);
            dropTargetDropEvent.dropComplete(false);
        }
        this.trashLabel.setIcon(this.trashClosedIcon);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.checkDrag(dropTargetDragEvent);
    }

    protected class DropPotentialFeedbackListener
    implements DnDManagerListener {
        protected DropPotentialFeedbackListener() {
        }

        private void doCheck() {
            Transferable transferable = DnDManager.getCurrentTransferable();
            boolean bl = TrashComponent.this.checkTransferable(transferable);
            if (TrashComponent.this.paintDropPotential != bl) {
                TrashComponent.this.paintDropPotential = bl;
                TrashComponent.this.repaint();
            }
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        }

        public void dragStarted() {
            this.doCheck();
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            this.doCheck();
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
            this.doCheck();
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            this.doCheck();
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            TrashComponent.this.paintDropPotential = false;
            TrashComponent.this.repaint();
        }
    }
}

