/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.JWindow;

public class RectangleAnimator
extends JWindow
implements Runnable {
    protected AuthoringTool authoringTool;
    protected Rectangle sourceBounds;
    protected Rectangle targetBounds;
    protected long duration = 300L;
    protected long startTime;

    public RectangleAnimator(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public Color getColor() {
        return this.getBackground();
    }

    public void setColor(Color color) {
        this.setBackground(color);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.duration = l;
    }

    public Rectangle getSourceBounds() {
        return this.sourceBounds;
    }

    public void setSourceBounds(Rectangle rectangle) {
        this.sourceBounds = rectangle;
    }

    public Rectangle gettargetBounds() {
        return this.targetBounds;
    }

    public void setTargetBounds(Rectangle rectangle) {
        this.targetBounds = rectangle;
    }

    public void animate(Rectangle rectangle, Rectangle rectangle2) {
        this.setSourceBounds(rectangle);
        this.setTargetBounds(rectangle2);
        this.setBounds(rectangle);
        this.setVisible(true);
        this.startTime = System.currentTimeMillis();
        this.authoringTool.getScheduler().addEachFrameRunnable(this);
    }

    public void animate(Rectangle rectangle, Rectangle rectangle2, Color color) {
        this.setColor(color);
        this.animate(rectangle, rectangle2);
    }

    public void run() {
        long l = System.currentTimeMillis();
        long l2 = l - this.startTime;
        if (l2 <= this.duration) {
            double d = (double)l2 / (double)this.duration;
            int n = this.sourceBounds.x + (int)(d * (double)(this.targetBounds.x - this.sourceBounds.x));
            int n2 = this.sourceBounds.y + (int)(d * (double)(this.targetBounds.y - this.sourceBounds.y));
            int n3 = this.sourceBounds.width + (int)(d * (double)(this.targetBounds.width - this.sourceBounds.width));
            int n4 = this.sourceBounds.height + (int)(d * (double)(this.targetBounds.height - this.sourceBounds.height));
            this.setBounds(n, n2, n3, n4);
            this.repaint();
        } else {
            this.setVisible(false);
            this.authoringTool.getScheduler().removeEachFrameRunnable(this);
        }
    }
}

