/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    protected Image image;
    protected MediaTracker tracker;
    protected Dimension size;

    public ImagePanel() {
        this.setOpaque(false);
        this.tracker = new MediaTracker(this);
        this.size = new Dimension();
    }

    public void setImage(Image image) {
        if (this.image != image) {
            if (this.image != null) {
                this.tracker.removeImage(this.image);
            }
            this.image = image;
            if (image != null) {
                this.tracker.addImage(this.image, 0);
            }
            try {
                this.tracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                AuthoringTool.getInstance().showErrorDialog("Interrupted while waiting for image to load.", interruptedException);
            }
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, null);
        }
    }

    protected Dimension getImageSize() {
        if (this.image != null) {
            this.size.setSize(this.image.getWidth(null), this.image.getHeight(null));
        } else {
            this.size.setSize(0, 0);
        }
        return this.size;
    }

    public Dimension getMinimumSize() {
        return this.getImageSize();
    }

    public Dimension getMaximumSize() {
        return this.getImageSize();
    }

    public Dimension getPreferredSize() {
        return this.getImageSize();
    }
}

