/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementTreeCellRenderer;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.IllegalNameValueException;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;

public class ElementTreeCellEditor
extends ElementTreeCellRenderer
implements TreeCellEditor {
    protected JTextField textField;
    protected HashSet cellEditorListeners;
    protected Element element;
    protected long lastClickTime;
    protected long editDelay = 500L;

    protected synchronized void initializeIfNecessary() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.cellEditorListeners = new HashSet();
            this.elementPanel.remove(this.elementLabel);
            this.elementPanel.add((Component)this.textField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
            this.textField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ElementTreeCellEditor.this.stopCellEditing();
                }
            });
            this.textField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        ElementTreeCellEditor.this.cancelCellEditing();
                    }
                }
            });
            this.textField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        ElementTreeCellEditor.this.stopCellEditing();
                    }
                }
            });
            this.dndPanel.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    ElementTreeCellEditor.this.stopCellEditing();
                }
            });
        }
    }

    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.initializeIfNecessary();
        if (object instanceof Element) {
            this.element = (Element)object;
            this.iconLabel.setIcon(AuthoringToolResources.getIconForValue(this.element));
            this.textField.setText(this.element.name.getStringValue());
        } else {
            AuthoringTool.getInstance().showErrorDialog("Error: not an Element: " + object, null);
        }
        return this;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.initializeIfNecessary();
        this.cellEditorListeners.add(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.initializeIfNecessary();
        this.cellEditorListeners.remove(cellEditorListener);
    }

    public void cancelCellEditing() {
        this.initializeIfNecessary();
        this.textField.setText(this.element.name.getStringValue());
        this.fireCellEditingCancelled();
    }

    public boolean stopCellEditing() {
        this.initializeIfNecessary();
        try {
            this.element.name.set(this.textField.getText());
            this.fireCellEditingStopped();
            return true;
        }
        catch (IllegalNameValueException illegalNameValueException) {
            DialogManager.showMessageDialog(illegalNameValueException.getMessage(), "Error setting name", 0);
            return false;
        }
    }

    public Object getCellEditorValue() {
        this.initializeIfNecessary();
        return this.textField.getText();
    }

    public synchronized boolean isCellEditable(EventObject eventObject) {
        boolean bl = false;
        if (eventObject instanceof MouseEvent && eventObject.getSource() instanceof JTree) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            JTree jTree = (JTree)eventObject.getSource();
            int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            bl = jTree.isRowSelected(n);
        }
        if (eventObject instanceof MouseEvent) {
            long l = System.currentTimeMillis();
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (mouseEvent.getClickCount() > 2) {
                    return true;
                }
                if (bl && l - this.lastClickTime > this.editDelay) {
                    return true;
                }
            }
            this.lastClickTime = l;
        } else if (eventObject == null) {
            return true;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    protected void fireCellEditingCancelled() {
        this.initializeIfNecessary();
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.cellEditorListeners.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingCanceled(changeEvent);
        }
    }

    protected void fireCellEditingStopped() {
        this.initializeIfNecessary();
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator iterator = this.cellEditorListeners.iterator();
        while (iterator.hasNext()) {
            ((CellEditorListener)iterator.next()).editingStopped(changeEvent);
        }
    }
}

