/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.EditorPanelEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.EditorPanelListener;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JPanel;

public class EditorPanel
extends JPanel
implements AuthoringToolStateListener {
    protected Editor activeEditor = null;
    protected Method activeEditorSetMethod = null;
    protected HashMap cachedEditors = new HashMap();
    protected EditStack editStack = new EditStack();
    protected HashSet listenerSet = new HashSet();
    protected AuthoringTool authoringTool;
    protected final ChildrenListener deletionListener = new ChildrenListener(){

        public void childrenChanging(ChildrenEvent childrenEvent) {
        }

        public void childrenChanged(ChildrenEvent childrenEvent) {
            if (childrenEvent.getChangeType() == 3 && childrenEvent.getChild() == EditorPanel.this.getElementBeingEdited()) {
                EditorPanel.this.editElement(null);
                childrenEvent.getParent().removeChildrenListener(this);
            }
        }
    };
    public final AbstractAction backAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.back();
        }
    };
    public final AbstractAction forwardAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPanel.this.forward();
        }
    };

    public Editor loadEditor(Class clazz) {
        Editor editor = null;
        if (clazz != null && (editor = (Editor)this.cachedEditors.get(clazz)) == null) {
            try {
                editor = EditorUtilities.getEditorFromClass(clazz);
                if (editor == null) {
                    AuthoringTool.getInstance().showErrorDialog("Can't create editor of type " + clazz.getName(), null);
                } else {
                    this.cachedEditors.put(clazz, editor);
                    this.authoringTool.addAuthoringToolStateListener(editor);
                    editor.setAuthoringTool(this.authoringTool);
                }
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Error creating editor for type " + clazz.getName(), throwable);
            }
        }
        return editor;
    }

    public void editElement(Element element) {
        this.editElement(element, true);
    }

    protected void editElement(Element element, boolean bl) {
        if (element == null) {
            this.editElement(null, null, bl);
        } else {
            Class clazz = EditorUtilities.getBestEditor(element.getClass());
            if (clazz == null) {
                AuthoringTool.getInstance().showErrorDialog("No editor found for " + element.getClass(), null);
            }
            this.editElement(element, clazz, bl);
        }
    }

    protected void editElement(Element element, Class clazz, boolean bl) {
        EditorPanelEvent editorPanelEvent;
        Iterator iterator;
        Editor editor;
        if (this.getElementBeingEdited() != null && this.getElementBeingEdited().getParent() != null) {
            this.getElementBeingEdited().getParent().removeChildrenListener(this.deletionListener);
        }
        if (this.activeEditor != (editor = this.loadEditor(clazz))) {
            if (this.activeEditor != null) {
                try {
                    this.activeEditorSetMethod.invoke((Object)this.activeEditor, new Object[]{null});
                }
                catch (InvocationTargetException invocationTargetException) {
                    AuthoringTool.getInstance().showErrorDialog("Error cleaning editor.", invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    AuthoringTool.getInstance().showErrorDialog("Error cleaning editor.", illegalAccessException);
                }
            }
            this.removeAll();
            this.activeEditor = editor;
            if (this.activeEditor != null) {
                this.activeEditorSetMethod = EditorUtilities.getSetMethodFromClass(clazz);
                this.add("Center", this.activeEditor.getJComponent());
            } else {
                this.activeEditorSetMethod = null;
                iterator = this.listenerSet.iterator();
                while (iterator.hasNext()) {
                    editorPanelEvent = new EditorPanelEvent(null);
                    ((EditorPanelListener)iterator.next()).elementChanged(editorPanelEvent);
                }
            }
            this.revalidate();
            this.repaint();
        }
        if (this.activeEditor != null && this.activeEditor.getObject() != element) {
            try {
                this.activeEditorSetMethod.invoke((Object)this.activeEditor, element);
                if (bl && element != null) {
                    this.editStack.push(new EditItem(element, clazz));
                    this.updateActions();
                }
                iterator = this.listenerSet.iterator();
                while (iterator.hasNext()) {
                    editorPanelEvent = new EditorPanelEvent(element);
                    ((EditorPanelListener)iterator.next()).elementChanged(editorPanelEvent);
                }
                if (element != null && element.getParent() != null) {
                    element.getParent().addChildrenListener(this.deletionListener);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                AuthoringTool.getInstance().showErrorDialog("Error intializing editor.", invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                AuthoringTool.getInstance().showErrorDialog("Error intializing editor.", illegalAccessException);
            }
        }
    }

    public Element getElementBeingEdited() {
        if (this.activeEditor != null) {
            return (Element)this.activeEditor.getObject();
        }
        return null;
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public void back() {
        this.editStack.undo();
        this.updateActions();
    }

    public void forward() {
        this.editStack.redo();
        this.updateActions();
    }

    public boolean canGoBack() {
        return this.editStack.getCurrentUndoableRedoableIndex() > 0;
    }

    public boolean canGoForward() {
        return this.editStack.getCurrentUndoableRedoableIndex() != this.editStack.size() - 1;
    }

    protected void updateActions() {
        this.backAction.setEnabled(this.canGoBack());
        this.forwardAction.setEnabled(this.canGoForward());
    }

    public void stateChanging(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void stateChanged(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldLoaded(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
        this.editStack.clear();
    }

    public void worldStarted(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    class EditItem
    implements UndoableRedoable {
        protected Element element;
        protected Class editorClass;

        public EditItem(Element element, Class clazz) {
            this.element = element;
            this.editorClass = clazz;
        }

        public void undo() {
        }

        public void redo() {
        }

        public Object getAffectedObject() {
            return this.element;
        }

        public Object getContext() {
            return EditorPanel.this;
        }

        public Element getElement() {
            return this.element;
        }

        public Class getEditorClass() {
            return this.editorClass;
        }
    }

    class EditStack
    extends DefaultUndoRedoStack {
        EditStack() {
        }

        public UndoableRedoable undo() {
            UndoableRedoable undoableRedoable = super.undo();
            UndoableRedoable undoableRedoable2 = EditorPanel.this.editStack.getCurrentUndoableRedoable();
            if (undoableRedoable != null) {
                EditorPanel.this.editElement(((EditItem)undoableRedoable2).getElement(), ((EditItem)undoableRedoable2).getEditorClass(), false);
            }
            return undoableRedoable;
        }

        public UndoableRedoable redo() {
            UndoableRedoable undoableRedoable = super.redo();
            if (undoableRedoable != null) {
                EditorPanel.this.editElement(((EditItem)undoableRedoable).getElement(), ((EditItem)undoableRedoable).getEditorClass(), false);
            }
            return undoableRedoable;
        }
    }
}

