/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.UndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import java.util.LinkedList;
import java.util.ListIterator;

public class DefaultUndoRedoStack
extends LinkedList
implements UndoRedoStack {
    private int currentIndex = -1;

    public synchronized void push(UndoableRedoable undoableRedoable) {
        if (this.currentIndex < this.size() - 1) {
            this.removeRange(this.currentIndex + 1, this.size());
        }
        this.addLast(undoableRedoable);
        this.currentIndex = this.size() - 1;
    }

    public synchronized UndoableRedoable pop() {
        if (this.currentIndex == this.size() - 1) {
            --this.currentIndex;
        }
        return (UndoableRedoable)this.removeLast();
    }

    public synchronized UndoableRedoable undo() {
        if (this.currentIndex > -1) {
            UndoableRedoable undoableRedoable = (UndoableRedoable)this.get(this.currentIndex);
            undoableRedoable.undo();
            --this.currentIndex;
            return undoableRedoable;
        }
        return null;
    }

    public synchronized UndoableRedoable redo() {
        if (this.currentIndex < this.size() - 1) {
            ++this.currentIndex;
            UndoableRedoable undoableRedoable = (UndoableRedoable)this.get(this.currentIndex);
            undoableRedoable.redo();
            return undoableRedoable;
        }
        return null;
    }

    public synchronized UndoableRedoable removeUndoable(int n) {
        UndoableRedoable undoableRedoable;
        if (n < 0 || n > this.size() - 1) {
            return null;
        }
        if (n > this.currentIndex) {
            return (UndoableRedoable)this.remove(n);
        }
        UndoableRedoable undoableRedoable2 = null;
        ListIterator listIterator = this.listIterator();
        while (listIterator.nextIndex() <= this.currentIndex) {
            listIterator.next();
        }
        while (listIterator.previousIndex() >= n) {
            undoableRedoable = (UndoableRedoable)listIterator.previous();
            undoableRedoable.undo();
            undoableRedoable2 = undoableRedoable;
        }
        listIterator.remove();
        --this.currentIndex;
        while (listIterator.nextIndex() <= this.currentIndex) {
            undoableRedoable = (UndoableRedoable)listIterator.next();
            undoableRedoable.redo();
        }
        return undoableRedoable2;
    }

    public synchronized int getCurrentUndoableRedoableIndex() {
        return this.currentIndex;
    }

    public synchronized UndoableRedoable getCurrentUndoableRedoable() {
        return (UndoableRedoable)this.get(this.currentIndex);
    }

    public synchronized void clear() {
        super.clear();
        this.currentIndex = -1;
    }
}

