/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.util.StrUtilities;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class CustomMouseAdapter
extends MouseAdapter {
    protected double clickDistMargin = 5.0;
    protected long clickTimeMargin = 300L;
    protected long multipleClickTimeMargin = 600L;
    protected Point pressPoint = new Point();
    protected long pressTime = 0L;
    protected int clickCount = 0;

    public double getClickDistanceMargin() {
        return this.clickDistMargin;
    }

    public void setClickDistanceMargin(double d) {
        this.clickDistMargin = d;
    }

    public long getClickTimeMargin() {
        return this.clickTimeMargin;
    }

    public void setClickTimeMargin(long l) {
        this.clickTimeMargin = l;
    }

    public long getMultipleClickTimeMargin() {
        return this.multipleClickTimeMargin;
    }

    public void setMultipleClickTimeMargin(long l) {
        this.multipleClickTimeMargin = l;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        String string = "" + mouseEvent.getClickCount() + " " + mouseEvent.getModifiers();
        long l = System.currentTimeMillis() - this.pressTime;
        if (l > this.multipleClickTimeMargin) {
            this.clickCount = 0;
        }
        string = string + " " + this.clickCount + " em (" + mouseEvent.getX() + "," + mouseEvent.getY() + "): source=" + StrUtilities.getComponentNameTitle(mouseEvent.getSource());
        System.out.println("CustomMouseAdapter.java: mousePressed: " + string);
        this.pressPoint.setLocation(mouseEvent.getPoint());
        this.pressTime = System.currentTimeMillis();
        if (mouseEvent.isPopupTrigger()) {
            this.popupResponse(mouseEvent);
        } else {
            this.mouseDownResponse(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupResponse(mouseEvent);
        } else {
            this.mouseUpResponse(mouseEvent);
        }
        double d = this.pressPoint.distance(mouseEvent.getPoint());
        long l = System.currentTimeMillis() - this.pressTime;
        if (d < this.clickDistMargin && l < this.clickTimeMargin) {
            ++this.clickCount;
            if (this.clickCount == 1) {
                this.singleClickResponse(mouseEvent);
            } else if (this.clickCount == 2) {
                this.doubleClickResponse(mouseEvent);
            } else if (this.clickCount == 3) {
                this.tripleClickResponse(mouseEvent);
            }
        }
    }

    protected void singleClickResponse(MouseEvent mouseEvent) {
    }

    protected void doubleClickResponse(MouseEvent mouseEvent) {
    }

    protected void tripleClickResponse(MouseEvent mouseEvent) {
    }

    protected void mouseUpResponse(MouseEvent mouseEvent) {
    }

    protected void mouseDownResponse(MouseEvent mouseEvent) {
    }

    protected void popupResponse(MouseEvent mouseEvent) {
    }
}

