/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicMenuUI;

public class AliceMenuUI
extends BasicMenuUI {
    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new AliceMouseInputHandler();
    }

    protected void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new AlicePostAction(jMenu));
        timer.setRepeats(false);
        timer.start();
    }

    public MenuElement[] getPath() {
        Vector<JMenuItem> vector = new Vector<JMenuItem>();
        MenuElement menuElement = this.menuItem;
        while (menuElement instanceof MenuElement) {
            Component component;
            vector.add(0, (JMenuItem)menuElement);
            if (menuElement instanceof JPopupMenu) {
                component = ((JPopupMenu)menuElement).getInvoker();
                if (component instanceof MenuElement && component != menuElement) {
                    menuElement = (MenuElement)((Object)component);
                    continue;
                }
                menuElement = null;
                continue;
            }
            if (menuElement instanceof JMenuItem) {
                component = menuElement.getParent();
                if (component instanceof MenuElement && component != menuElement) {
                    menuElement = (MenuElement)((Object)component);
                    continue;
                }
                menuElement = null;
                continue;
            }
            menuElement = null;
        }
        return vector.toArray(new MenuElement[0]);
    }

    private static class AlicePostAction
    extends AbstractAction {
        JMenu menu;

        AlicePostAction(JMenu jMenu) {
            this.menu = jMenu;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = ((BasicMenuUI)this.menu.getUI()).getPath();
            MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
            menuElementArray[menuElementArray.length] = this.menu.getPopupMenu();
            menuSelectionManager.setSelectedPath(menuElementArray2);
        }

        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }

    protected class AliceMouseInputHandler
    implements MouseInputListener {
        protected AliceMouseInputHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuElement[] menuElementArray;
            Object object;
            JMenu jMenu = (JMenu)AliceMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (jMenu.isTopLevelMenu()) {
                if (jMenu.isSelected()) {
                    menuSelectionManager.clearSelectedPath();
                } else {
                    object = jMenu.getParent();
                    if (object != null && object instanceof JMenuBar) {
                        menuElementArray = new MenuElement[]{(MenuElement)object, jMenu};
                        menuSelectionManager.setSelectedPath(menuElementArray);
                    }
                }
            }
            if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length <= 0 || object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
                if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                    menuElementArray = new MenuElement[((MenuElement[])object).length + 1];
                    System.arraycopy(object, 0, menuElementArray, 0, ((MenuElement[])object).length);
                    menuElementArray[((MenuElement[])object).length] = jMenu.getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    AliceMenuUI.this.setupPostTimer(jMenu);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)AliceMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.processMouseEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)AliceMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (jMenu.getDelay() == 0) {
                    MenuElement[] menuElementArray2 = AliceMenuUI.this.getPath();
                    MenuElement[] menuElementArray3 = new MenuElement[AliceMenuUI.this.getPath().length + 1];
                    System.arraycopy(menuElementArray2, 0, menuElementArray3, 0, menuElementArray2.length);
                    menuElementArray3[menuElementArray2.length] = jMenu.getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray3);
                } else {
                    menuSelectionManager.setSelectedPath(AliceMenuUI.this.getPath());
                    AliceMenuUI.this.setupPostTimer(jMenu);
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray4 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray4);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)AliceMenuUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

