/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.AlicePopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class AliceMenu
extends JMenu
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuUI";
    private AlicePopupMenu popupMenu;
    private ChangeListener menuChangeListener = null;
    private MenuEvent menuEvent = null;
    private int delay;
    private boolean receivedKeyPressed;
    static /* synthetic */ Class class$javax$swing$event$MenuListener;

    public AliceMenu() {
        this("");
    }

    public AliceMenu(String string) {
        super(string);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setModel(ButtonModel buttonModel) {
        ButtonModel buttonModel2 = this.getModel();
        super.setModel(buttonModel);
        if (buttonModel2 != null && this.menuChangeListener != null) {
            buttonModel2.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = buttonModel;
        if (buttonModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            buttonModel.addChangeListener(this.menuChangeListener);
        }
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public void setSelected(boolean bl) {
        ButtonModel buttonModel = this.getModel();
        boolean bl2 = buttonModel.isSelected();
        if (this.accessibleContext != null && bl2 != bl) {
            if (bl) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (bl != buttonModel.isSelected()) {
            this.getModel().setSelected(bl);
        }
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean bl) {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl2 = this.isPopupMenuVisible();
        if (bl != bl2) {
            this.ensurePopupMenuCreated();
            if (bl && this.isShowing()) {
                Point point = this.getPopupMenuOrigin();
                this.getPopupMenu().show(this, point.x, point.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        int n = 0;
        int n2 = 0;
        JPopupMenu jPopupMenu = this.getPopupMenu();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        dimension.height -= 28;
        Dimension dimension2 = this.getSize();
        Dimension dimension3 = jPopupMenu.getSize();
        if (dimension3.width == 0) {
            dimension3 = jPopupMenu.getPreferredSize();
        }
        Point point = this.getLocationOnScreen();
        Container container = this.getParent();
        if (container instanceof JPopupMenu) {
            n = this.getComponentOrientation().isLeftToRight() ? (point.x + dimension2.width + dimension3.width < dimension.width ? dimension2.width : 0 - dimension3.width) : (point.x < dimension3.width ? dimension2.width : 0 - dimension3.width);
            n2 = point.y + dimension3.height < dimension.height ? 0 : dimension2.height - dimension3.height;
        } else {
            n = this.getComponentOrientation().isLeftToRight() ? (point.x + dimension3.width < dimension.width ? 0 : dimension2.width - dimension3.width) : (point.x + dimension2.width < dimension3.width ? 0 : dimension2.width - dimension3.width);
            n2 = point.y + dimension2.height + dimension3.height < dimension.height ? dimension2.height : 0 - dimension3.height;
        }
        return new Point(n, n2);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Delay must be a positive integer");
        }
        this.delay = n;
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            this.popupMenu = new AlicePopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    AliceMenu.this.fireMenuCanceled();
                }
            });
        }
    }

    public void setMenuLocation(int n, int n2) {
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(n, n2);
        }
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(jMenuItem);
    }

    public Component add(Component component) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component);
        return component;
    }

    public Component add(Component component, int n) {
        AccessibleContext accessibleContext;
        if (component instanceof JComponent && (accessibleContext = ((JComponent)component).getAccessibleContext()) != null) {
            accessibleContext.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(component, n);
        return component;
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    protected JMenuItem createActionComponent(Action action) {
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = AliceMenu.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        return jMenuItem;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return new ActionChangedListener(jMenuItem);
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    public void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(string), n);
    }

    public JMenuItem insert(JMenuItem jMenuItem, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext accessibleContext = jMenuItem.getAccessibleContext();
        accessibleContext.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public JMenuItem insert(Action action, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem jMenuItem = new JMenuItem((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        jMenuItem.setHorizontalTextPosition(4);
        jMenuItem.setVerticalTextPosition(0);
        jMenuItem.setEnabled(action.isEnabled());
        jMenuItem.setAction(action);
        this.popupMenu.insert(jMenuItem, n);
        return jMenuItem;
    }

    public void insertSeparator(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), n);
    }

    public JMenuItem getItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        Component component = this.getMenuComponent(n);
        if (component instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)component;
            return jMenuItem;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("boolean isTearOff() {} not yet implemented");
    }

    public void remove(JMenuItem jMenuItem) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(jMenuItem);
        }
    }

    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(n);
        }
    }

    public void remove(Component component) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(component);
        }
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public int getMenuComponentCount() {
        int n = 0;
        if (this.popupMenu != null) {
            n = this.popupMenu.getComponentCount();
        }
        return n;
    }

    public Component getMenuComponent(int n) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n);
        }
        return null;
    }

    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        JPopupMenu jPopupMenu;
        if (component == this) {
            return true;
        }
        if (component instanceof JPopupMenu && (jPopupMenu = (JPopupMenu)component) == this.getPopupMenu()) {
            return true;
        }
        int n = this.getMenuComponentCount();
        Component[] componentArray = this.getMenuComponents();
        for (int i = 0; i < n; ++i) {
            AliceMenu aliceMenu;
            Component component2 = componentArray[i];
            if (component2 == component) {
                return true;
            }
            if (!(component2 instanceof AliceMenu) || !(aliceMenu = (AliceMenu)component2).isMenuComponent(component)) continue;
            return true;
        }
        return false;
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener menuListener) {
        this.listenerList.add(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = AliceMenu.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener, menuListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.listenerList.remove(class$javax$swing$event$MenuListener == null ? (class$javax$swing$event$MenuListener = AliceMenu.class$("javax.swing.event.MenuListener")) : class$javax$swing$event$MenuListener, menuListener);
    }

    protected void fireMenuSelected() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$MenuListener == null ? AliceMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this.menuEvent == null) {
                this.menuEvent = new MenuEvent(this);
            }
            ((MenuListener)objectArray[i + 1]).menuSelected(this.menuEvent);
        }
    }

    protected void fireMenuDeselected() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$MenuListener == null ? AliceMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this.menuEvent == null) {
                this.menuEvent = new MenuEvent(this);
            }
            ((MenuListener)objectArray[i + 1]).menuDeselected(this.menuEvent);
        }
    }

    protected void fireMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$MenuListener == null ? AliceMenu.class$("javax.swing.event.MenuListener") : class$javax$swing$event$MenuListener)) continue;
            if (objectArray[i + 1] == null) {
                throw new Error(this.getText() + " has a NULL Listener!! " + i);
            }
            if (this.menuEvent == null) {
                this.menuEvent = new MenuEvent(this);
            }
            ((MenuListener)objectArray[i + 1]).menuCanceled(this.menuEvent);
        }
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener();
    }

    protected JMenu.WinListener createWinListener(JPopupMenu jPopupMenu) {
        return new JMenu.WinListener(this, jPopupMenu);
    }

    public void menuSelectionChanged(boolean bl) {
        this.setSelected(bl);
    }

    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] menuElementArray = new MenuElement[]{this.popupMenu};
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for AliceMenu.  Use setMnemonic() instead.");
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        switch (focusEvent.getID()) {
            case 1005: {
                this.receivedKeyPressed = false;
                break;
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        switch (keyEvent.getID()) {
            case 401: {
                if (this.isSelected()) {
                    this.receivedKeyPressed = true;
                    bl = true;
                    break;
                }
                this.receivedKeyPressed = false;
                break;
            }
            case 402: {
                if (!this.receivedKeyPressed) break;
                this.receivedKeyPressed = false;
                bl = true;
                break;
            }
            default: {
                bl = this.receivedKeyPressed;
            }
        }
        if (bl) {
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this.isSelected() && (keyEvent.getKeyCode() == 9 || keyEvent.getKeyChar() == '\t')) {
            if ((Boolean)UIManager.get("Menu.consumesTabs") == Boolean.TRUE) {
                keyEvent.consume();
                return;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        super.processKeyEvent(keyEvent);
    }

    public void doClick(int n) {
        MenuElement[] menuElementArray = this.buildMenuElementArray(this);
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
    }

    private MenuElement[] buildMenuElementArray(AliceMenu aliceMenu) {
        Vector<JComponent> vector = new Vector<JComponent>();
        Component component = aliceMenu.getPopupMenu();
        while (true) {
            if (component instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = component;
                vector.insertElementAt(jPopupMenu, 0);
                component = jPopupMenu.getInvoker();
                continue;
            }
            if (component instanceof AliceMenu) {
                AliceMenu aliceMenu2 = (AliceMenu)component;
                vector.insertElementAt(aliceMenu2, 0);
                component = aliceMenu2.getParent();
                continue;
            }
            if (component instanceof JMenuBar) break;
        }
        JMenuBar jMenuBar = (JMenuBar)component;
        vector.insertElementAt(jMenuBar, 0);
        Object[] objectArray = new MenuElement[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJMenu
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener,
    AccessibleSelection {
        public AccessibleJMenu() {
            super(AliceMenu.this);
            AliceMenu.this.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public int getAccessibleChildrenCount() {
            Component[] componentArray = AliceMenu.this.getMenuComponents();
            int n = 0;
            int n2 = componentArray != null ? componentArray.length : 0;
            for (int i = 0; i < n2; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                ++n;
            }
            return n;
        }

        public Accessible getAccessibleChild(int n) {
            Component[] componentArray = AliceMenu.this.getMenuComponents();
            int n2 = 0;
            int n3 = componentArray != null ? componentArray.length : 0;
            for (int i = 0; i < n3; ++i) {
                if (!(componentArray[i] instanceof Accessible)) continue;
                if (n2 == n) {
                    if (componentArray[i] instanceof JComponent) {
                        AccessibleContext accessibleContext = ((Accessible)((Object)componentArray[i])).getAccessibleContext();
                        accessibleContext.setAccessibleParent(AliceMenu.this);
                    }
                    return (Accessible)((Object)componentArray[i]);
                }
                ++n2;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != AliceMenu.this || i + 1 >= menuElementArray.length) continue;
                    return 1;
                }
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n) {
            if (n < 0 || n >= AliceMenu.this.getItemCount()) {
                return null;
            }
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != AliceMenu.this) continue;
                    while (++i < menuElementArray.length) {
                        if (!(menuElementArray[i] instanceof JMenuItem)) continue;
                        return (Accessible)((Object)menuElementArray[i]);
                    }
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                JMenuItem jMenuItem = AliceMenu.this.getItem(n);
                int n2 = menuElementArray != null ? menuElementArray.length : 0;
                for (int i = 0; i < n2; ++i) {
                    if (menuElementArray[i] != jMenuItem) continue;
                    return true;
                }
            }
            return false;
        }

        public void addAccessibleSelection(int n) {
            if (n < 0 || n >= AliceMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = AliceMenu.this.getItem(n);
            if (jMenuItem != null) {
                if (jMenuItem instanceof AliceMenu) {
                    MenuElement[] menuElementArray = AliceMenu.this.buildMenuElementArray((AliceMenu)jMenuItem);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                } else {
                    jMenuItem.doClick();
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        public void removeAccessibleSelection(int n) {
            if (n < 0 || n >= AliceMenu.this.getItemCount()) {
                return;
            }
            JMenuItem jMenuItem = AliceMenu.this.getItem(n);
            if (jMenuItem != null && jMenuItem instanceof AliceMenu && ((AliceMenu)jMenuItem).isSelected()) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                for (int i = 0; i < menuElementArray.length - 2; ++i) {
                    menuElementArray2[i] = menuElementArray[i];
                }
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            }
        }

        public void clearAccessibleSelection() {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray != null) {
                for (int i = 0; i < menuElementArray.length; ++i) {
                    if (menuElementArray[i] != AliceMenu.this) continue;
                    MenuElement[] menuElementArray2 = new MenuElement[i + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, i);
                    menuElementArray2[i] = AliceMenu.this.getPopupMenu();
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                }
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected = false;

        MenuChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl = buttonModel.isSelected();
            if (bl != this.isSelected) {
                if (bl) {
                    AliceMenu.this.fireMenuSelected();
                } else {
                    AliceMenu.this.fireMenuDeselected();
                }
                this.isSelected = bl;
            }
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem jMenuItem) {
            this.setTarget(jMenuItem);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.menuItem.setText(string2);
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.menuItem.setEnabled(bl);
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }

        public void setTarget(JMenuItem jMenuItem) {
            this.menuItem = jMenuItem;
        }
    }
}

