/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.While;
import edu.cmu.cs.stage3.alice.core.response.WhileLoopInOrder;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class WhileElementPanel
extends CompositeElementPanel {
    protected JComponent conditionalInput;
    protected JLabel endHeader;
    protected BooleanProperty m_condition;
    protected static BufferedImage whileLoopBackgroundImage;
    protected static Dimension whileLoopBackgroundImageSize;

    public WhileElementPanel() {
        this.headerText = I18n.getString("commandT_While");
        this.backgroundColor = AuthoringToolResources.getColor("WhileLoopInOrder");
    }

    protected void variableInit() {
        super.variableInit();
        if (this.m_element instanceof WhileLoopInOrder) {
            WhileLoopInOrder whileLoopInOrder = (WhileLoopInOrder)this.m_element;
            this.m_condition = whileLoopInOrder.condition;
        } else if (this.m_element instanceof While) {
            While while_ = (While)this.m_element;
            this.m_condition = while_.condition;
        }
    }

    protected void startListening() {
        super.startListening();
        if (this.m_condition != null) {
            this.m_condition.addPropertyListener(this);
        }
    }

    protected void stopListening() {
        super.stopListening();
        if (this.m_condition != null) {
            this.m_condition.removePropertyListener(this);
        }
    }

    public void setHeaderLabel() {
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
            if (CompositeElementEditor.IS_JAVA) {
                this.headerLabel.setText(I18n.getString("commandT_While"));
            }
        }
        if (this.endHeader != null) {
            this.endHeader.setText("");
            if (CompositeElementEditor.IS_JAVA) {
                if (!this.isExpanded) {
                    this.endHeader.setText(") { " + this.getDots() + " }");
                } else {
                    this.endHeader.setText(") {");
                }
            }
        }
    }

    protected void generateGUI() {
        super.generateGUI();
        if (this.endHeader == null) {
            this.endHeader = new JLabel();
        }
    }

    protected void restoreDrag() {
        super.restoreDrag();
        this.addDragSourceComponent(this.endHeader);
    }

    protected void updateGUI() {
        super.updateGUI();
        SetPropertyImmediatelyFactory setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(this.m_condition);
        this.conditionalInput = GUIFactory.getPropertyViewController(this.m_condition, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_condition), setPropertyImmediatelyFactory);
        this.headerPanel.remove(this.glue);
        this.headerPanel.add((Component)this.conditionalInput, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)this.endHeader, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBackgroundImage(int n, int n2) {
        whileLoopBackgroundImageSize.setSize(n, n2);
        whileLoopBackgroundImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)whileLoopBackgroundImage.getGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
    }

    static {
        whileLoopBackgroundImageSize = new Dimension(-1, -1);
    }
}

