/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.questioneditor.MainCompositeQuestionPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.awt.DynamicFlowLayout;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class MainCompositeElementPanel
extends CompositeElementPanel
implements ObjectArrayPropertyListener {
    protected Color backgroundColor = AuthoringToolResources.getColor("userDefinedResponseEditor");
    protected JPanel parameterPanel;
    protected JPanel variablePanel;
    protected JPanel mainParameterPanel;
    protected JPanel mainVariablePanel;
    protected JButton newParameterButton;
    protected JButton newVariableButton;
    protected JScrollPane scrollPane;
    protected DropTargetHandler parameterDropHandler;
    protected DropTargetHandler variableDropHandler;
    protected JLabel methodNameLabel;
    protected JLabel noParametersLabel;
    protected JLabel noVariablesLabel;
    private ObjectArrayProperty requiredParameters;
    private ObjectArrayProperty keywordParameters;
    private ObjectArrayProperty localVariables;
    private int lineLocation = -1;
    private int lineHeight = 24;
    private int verticalLineLocation = 5;
    private boolean paintParameter = false;
    private boolean paintVariable = false;
    private static final int fontSize = 12;
    private static final Font noFont = new Font("Helvetica", 2, 12);
    private static final Font nameFont = new Font("Helvetica", 1, 12);
    static /* synthetic */ Class class$edu$cmu$cs$stage3$alice$core$Collection;
    static /* synthetic */ Class class$javax$swing$JTabbedPane;

    public MainCompositeElementPanel() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.setDragEnabled(false);
        this.setBorder(null);
        this.elementMouseListener = null;
    }

    public void set(Element element, AuthoringTool authoringTool) {
        super.set(element, authoringTool);
    }

    protected void setDropTargets() {
    }

    protected void variableInit() {
        super.variableInit();
        this.setVariableObjects(this.m_element);
    }

    protected void startListening() {
        super.startListening();
        if (this.keywordParameters != null) {
            this.keywordParameters.addObjectArrayPropertyListener(this);
        }
        if (this.requiredParameters != null) {
            this.requiredParameters.addObjectArrayPropertyListener(this);
        }
        if (this.localVariables != null) {
            this.localVariables.addObjectArrayPropertyListener(this);
        }
    }

    protected void stopListening() {
        super.stopListening();
        if (this.keywordParameters != null) {
            this.keywordParameters.removeObjectArrayPropertyListener(this);
        }
        if (this.requiredParameters != null) {
            this.requiredParameters.removeObjectArrayPropertyListener(this);
        }
        if (this.localVariables != null) {
            this.localVariables.removeObjectArrayPropertyListener(this);
        }
    }

    protected void removeAllListening() {
        super.removeAllListening();
        this.variablePanel.setDropTarget(null);
        this.parameterPanel.setDropTarget(null);
        this.parameterDropHandler = null;
        this.variableDropHandler = null;
    }

    protected boolean isValidName(String string, ObjectArrayProperty objectArrayProperty) {
        for (int i = 0; i < objectArrayProperty.size(); ++i) {
            if (string != ((Element)objectArrayProperty.get((int)i)).name.getStringValue()) continue;
            return false;
        }
        return true;
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        if (this.parameterPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainCompositeElementPanel.this.buildParameterPanel();
                }
            });
        }
        if (this.variablePanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MainCompositeElementPanel.this.buildVariablePanel();
                }
            });
        }
    }

    protected String getHeaderHTML() {
        String string = "<b>" + this.methodNameLabel.getText() + "</b>&nbsp;(&nbsp;";
        for (int i = 0; i < this.requiredParameters.size(); ++i) {
            Class clazz = ((Variable)this.requiredParameters.get((int)i)).valueClass.getClassValue();
            boolean bl = false;
            if ((class$edu$cmu$cs$stage3$alice$core$Collection == null ? MainCompositeElementPanel.class$("edu.cmu.cs.stage3.alice.core.Collection") : class$edu$cmu$cs$stage3$alice$core$Collection).isAssignableFrom(clazz)) {
                clazz = (Class)((Collection)((Variable)this.requiredParameters.get((int)i)).getValue()).valueClass.get();
                bl = true;
            }
            String string2 = AuthoringToolResources.getHTMLName(clazz.getName());
            if (bl) {
                string2 = string2 + AuthoringToolResources.getHTMLName("edu.cmu.cs.stage3.alice.core.Collection");
            }
            string = string + string2 + " <b>" + ((Element)this.requiredParameters.get((int)i)).name.getStringValue() + "</b>";
            if (i + 1 == this.requiredParameters.size()) continue;
            string = string + ", ";
        }
        string = CompositeElementEditor.IS_JAVA ? string + ") <b>{</b>\n<br>&nbsp;&nbsp;&nbsp;&nbsp;" : string + ")\n<br>&nbsp;&nbsp;&nbsp;&nbsp;";
        string = string + GUIFactory.getHTMLStringForComponent(this.mainVariablePanel);
        return string;
    }

    private void setVariableObjects(Element element) {
        if (element instanceof UserDefinedResponse) {
            UserDefinedResponse userDefinedResponse = (UserDefinedResponse)element;
            this.keywordParameters = userDefinedResponse.keywordFormalParameters;
            this.requiredParameters = userDefinedResponse.requiredFormalParameters;
            this.localVariables = userDefinedResponse.localVariables;
        } else if (element instanceof UserDefinedQuestion) {
            UserDefinedQuestion userDefinedQuestion = (UserDefinedQuestion)element;
            this.keywordParameters = userDefinedQuestion.keywordFormalParameters;
            this.requiredParameters = userDefinedQuestion.requiredFormalParameters;
            this.localVariables = userDefinedQuestion.localVariables;
        }
        if (this.keywordParameters != null && this.requiredParameters != null && this.localVariables != null) {
            this.keywordParameters.addObjectArrayPropertyListener(this);
            this.requiredParameters.addObjectArrayPropertyListener(this);
            this.localVariables.addObjectArrayPropertyListener(this);
            this.parameterDropHandler.setProperty(this.requiredParameters);
            this.variableDropHandler.setProperty(this.localVariables);
        }
    }

    protected int buildVariablePanel(String string, JPanel jPanel, ObjectArrayProperty objectArrayProperty, JButton jButton, DropTargetHandler dropTargetHandler, int n) {
        int n2 = 0;
        if (objectArrayProperty != null == objectArrayProperty.size() > 0) {
            for (int i = 0; i < objectArrayProperty.size(); ++i) {
                try {
                    JPanel jPanel2;
                    if (!(objectArrayProperty.get(i) instanceof Variable)) continue;
                    Variable variable = (Variable)objectArrayProperty.get(i);
                    SetPropertyImmediatelyFactory setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(variable.value);
                    GroupingPanel groupingPanel = null;
                    groupingPanel = jPanel != this.parameterPanel ? GUIFactory.getVariableGUI(variable, true, setPropertyImmediatelyFactory) : GUIFactory.getVariableDnDPanel(variable);
                    ++n2;
                    groupingPanel.setDropTarget(new DropTarget(groupingPanel, dropTargetHandler));
                    if (groupingPanel instanceof Container) {
                        jPanel2 = groupingPanel;
                        for (int j = 0; j < jPanel2.getComponentCount(); ++j) {
                            jPanel2.getComponent(j).setDropTarget(new DropTarget(jPanel2.getComponent(j), dropTargetHandler));
                            if (!(jPanel2.getComponent(j) instanceof Container)) continue;
                            Container container = (Container)jPanel2.getComponent(j);
                            for (int k = 0; k < container.getComponentCount(); ++k) {
                                container.getComponent(k).setDropTarget(new DropTarget(container.getComponent(k), dropTargetHandler));
                            }
                        }
                    }
                    if (n2 != objectArrayProperty.size()) {
                        jPanel2 = new JPanel();
                        jPanel2.setBorder(null);
                        jPanel2.setLayout(new FlowLayout(0, 0, 0));
                        jPanel2.setBackground(jPanel.getBackground());
                        jPanel2.setDropTarget(new DropTarget(jPanel2, dropTargetHandler));
                        JLabel jLabel = new JLabel(" " + string);
                        jLabel.setDropTarget(new DropTarget(jLabel, dropTargetHandler));
                        jPanel2.add(groupingPanel);
                        jPanel2.add(jLabel);
                        jPanel.add(jPanel2);
                        jPanel2.setDropTarget(new DropTarget(jPanel2, dropTargetHandler));
                        continue;
                    }
                    jPanel.add(groupingPanel);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("MainCompositeElementPanel.java: buildVariablePanel(...): " + exception.toString());
                }
            }
        } else {
            JLabel jLabel = this.noParametersLabel;
            if (objectArrayProperty == this.localVariables) {
                jLabel = this.noVariablesLabel;
            }
            jLabel.setDropTarget(new DropTarget(jLabel, dropTargetHandler));
            jPanel.add(jLabel);
        }
        return n2;
    }

    protected int buildJavaVariablePanel(String string, JPanel jPanel, ObjectArrayProperty objectArrayProperty, JButton jButton, DropTargetHandler dropTargetHandler, int n) {
        int n2 = 0;
        if (objectArrayProperty != null) {
            for (int i = 0; i < objectArrayProperty.size(); ++i) {
                JPanel jPanel2;
                String string2;
                if (!(objectArrayProperty.get(i) instanceof Variable)) continue;
                Variable variable = (Variable)objectArrayProperty.get(i);
                SetPropertyImmediatelyFactory setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(variable.value);
                String string3 = variable.getValueClass().getName();
                boolean bl = false;
                if ((class$edu$cmu$cs$stage3$alice$core$Collection == null ? MainCompositeElementPanel.class$("edu.cmu.cs.stage3.alice.core.Collection") : class$edu$cmu$cs$stage3$alice$core$Collection).isAssignableFrom(variable.getValueClass())) {
                    string3 = ((Class)((Collection)variable.getValue()).valueClass.get()).getName();
                    bl = true;
                }
                if ((string2 = AuthoringToolResources.getHTMLName(string3)) == null) {
                    string2 = variable.getValueClass().getName();
                    string2 = string2.substring(string2.lastIndexOf(46) + 1);
                }
                if (bl) {
                    string2 = string2 + "[]";
                }
                JLabel jLabel = new JLabel(string2 + " ");
                GroupingPanel groupingPanel = null;
                groupingPanel = jPanel != this.parameterPanel ? GUIFactory.getVariableGUI(variable, true, setPropertyImmediatelyFactory) : GUIFactory.getVariableDnDPanel(variable);
                ++n2;
                groupingPanel.setDropTarget(new DropTarget(groupingPanel, dropTargetHandler));
                if (groupingPanel instanceof Container) {
                    jPanel2 = groupingPanel;
                    for (int j = 0; j < jPanel2.getComponentCount(); ++j) {
                        jPanel2.getComponent(j).setDropTarget(new DropTarget(jPanel2.getComponent(j), dropTargetHandler));
                        if (!(jPanel2.getComponent(j) instanceof Container)) continue;
                        Container container = (Container)jPanel2.getComponent(j);
                        for (int k = 0; k < container.getComponentCount(); ++k) {
                            container.getComponent(k).setDropTarget(new DropTarget(container.getComponent(k), dropTargetHandler));
                        }
                    }
                }
                if (n2 != objectArrayProperty.size()) {
                    jPanel2 = new JPanel();
                    jPanel2.setBorder(null);
                    jPanel2.setLayout(new FlowLayout(0, 0, 0));
                    jPanel2.setBackground(jPanel.getBackground());
                    jPanel2.setDropTarget(new DropTarget(jPanel2, dropTargetHandler));
                    JLabel jLabel2 = new JLabel(" " + string + " ");
                    jLabel2.setDropTarget(new DropTarget(jLabel2, dropTargetHandler));
                    jLabel.setDropTarget(new DropTarget(jLabel, dropTargetHandler));
                    jPanel2.add(jLabel);
                    jPanel2.add(groupingPanel);
                    jPanel2.add(jLabel2);
                    jPanel.add(jPanel2);
                    continue;
                }
                jPanel2 = new JPanel();
                jPanel2.setBorder(null);
                jPanel2.setLayout(new FlowLayout(0, 0, 0));
                jPanel2.setBackground(jPanel.getBackground());
                jPanel2.setDropTarget(new DropTarget(jPanel2, dropTargetHandler));
                jLabel.setDropTarget(new DropTarget(jLabel, dropTargetHandler));
                jPanel2.add(jLabel);
                jPanel2.add(groupingPanel);
                jPanel.add(jPanel2);
            }
        }
        return n2;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.parameterPanel != null) {
            this.parameterPanel.setBackground(color);
        }
        if (this.variablePanel != null) {
            this.variablePanel.setBackground(color);
        }
        if (this.mainVariablePanel != null) {
            this.mainVariablePanel.setBackground(color);
        }
        if (this.mainParameterPanel != null) {
            this.mainParameterPanel.setBackground(color);
        }
        if (this.componentElementPanel != null) {
            this.componentElementPanel.setBackground(color);
        }
    }

    protected void buildParameterPanel() {
        this.parameterPanel.removeAll();
        String string = this.m_element.name.getStringValue();
        if (CompositeElementEditor.IS_JAVA) {
            Object object;
            Object object2;
            string = string.replace(' ', '_');
            String string2 = "void";
            if (this instanceof MainCompositeQuestionPanel) {
                object2 = (UserDefinedQuestion)this.m_element;
                object = ((UserDefinedQuestion)object2).getValueClass().getName();
                boolean bl = false;
                if ((class$edu$cmu$cs$stage3$alice$core$Collection == null ? (class$edu$cmu$cs$stage3$alice$core$Collection = MainCompositeElementPanel.class$("edu.cmu.cs.stage3.alice.core.Collection")) : class$edu$cmu$cs$stage3$alice$core$Collection).isAssignableFrom(((UserDefinedQuestion)object2).getValueClass())) {
                    object = ((Class)((Collection)((UserDefinedQuestion)object2).getValue()).valueClass.get()).getName();
                    bl = true;
                }
                if ((string2 = AuthoringToolResources.getHTMLName(object)) == null) {
                    string2 = ((UserDefinedQuestion)object2).getValueClass().getName();
                    string2 = string2.substring(string2.lastIndexOf(46) + 1);
                }
                if (bl) {
                    string2 = string2 + "[]";
                }
            }
            this.methodNameLabel.setText("public " + string2 + " " + string);
            this.parameterPanel.add(this.methodNameLabel);
            this.parameterPanel.add(new JLabel("("));
            this.buildJavaVariablePanel(",", this.parameterPanel, this.requiredParameters, this.newParameterButton, this.parameterDropHandler, 3);
            object2 = new JLabel("{");
            ((Component)object2).setDropTarget(new DropTarget((Component)object2, this.parameterDropHandler));
            object = new JLabel(")");
            ((Component)object).setDropTarget(new DropTarget((Component)object, this.parameterDropHandler));
            this.parameterPanel.add((Component)object);
            this.parameterPanel.add((Component)object2);
        } else {
            this.methodNameLabel.setText(this.m_element.getTrimmedKey());
            this.parameterPanel.add(this.methodNameLabel);
            this.buildVariablePanel(",", this.parameterPanel, this.requiredParameters, this.newParameterButton, this.parameterDropHandler, 3);
        }
        this.newParameterButton.setDropTarget(new DropTarget(this.newParameterButton, this.parameterDropHandler));
        this.parameterPanel.validate();
        this.parameterPanel.repaint();
    }

    protected void buildVariablePanel() {
        this.variablePanel.removeAll();
        if (CompositeElementEditor.IS_JAVA) {
            int n = this.buildJavaVariablePanel(";", this.variablePanel, this.localVariables, this.newVariableButton, this.variableDropHandler, 1);
            if (n > 0) {
                JLabel jLabel = new JLabel(";");
                jLabel.setDropTarget(new DropTarget(jLabel, this.parameterDropHandler));
                this.variablePanel.add(jLabel);
            }
        } else {
            this.buildVariablePanel(",", this.variablePanel, this.localVariables, this.newVariableButton, this.variableDropHandler, 1);
        }
        this.newVariableButton.setDropTarget(new DropTarget(this.newVariableButton, this.variableDropHandler));
        this.variablePanel.revalidate();
        this.variablePanel.repaint();
    }

    private Component getAnchor(Component component) {
        if (component == null || component instanceof JTabbedPane) {
            return component;
        }
        return this.getAnchor(component.getParent());
    }

    protected void generateGUI() {
        int n = 140;
        int n2 = 26;
        Component component = this.getAnchor(this);
        if (this.newParameterButton == null) {
            this.newParameterButton = new JButton(I18n.getString("msg_New_parameter"));
            this.newParameterButton.setBackground(new Color(240, 240, 255));
            this.newParameterButton.setMargin(new Insets(2, 2, 2, 2));
            this.newParameterButton.setMinimumSize(new Dimension(n, n2));
            this.newParameterButton.setPreferredSize(new Dimension(n, n2));
            this.newParameterButton.setMaximumSize(new Dimension(n, n2));
            this.newParameterButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    Variable variable = MainCompositeElementPanel.this.authoringTool.showNewVariableDialog(I18n.getString("msg_createNewParam"), MainCompositeElementPanel.this.requiredParameters.getOwner(), false, false);
                    if (variable != null && MainCompositeElementPanel.this.requiredParameters != null) {
                        MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().startCompound();
                        try {
                            MainCompositeElementPanel.this.requiredParameters.getOwner().addChild(variable);
                            MainCompositeElementPanel.this.requiredParameters.add(variable);
                        }
                        finally {
                            MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().stopCompound();
                        }
                    }
                }
            });
            this.newParameterButton.setDropTarget(new DropTarget(this.newParameterButton, this.parameterDropHandler));
            this.newParameterButton.setToolTipText(I18n.getString("msg_help_createNewParam"));
        }
        if (this.newVariableButton == null) {
            this.newVariableButton = new JButton(I18n.getString("msg_New_local_var"));
            this.newVariableButton.setBackground(new Color(240, 240, 255));
            this.newVariableButton.setMargin(new Insets(2, 2, 2, 2));
            this.newVariableButton.setMinimumSize(new Dimension(n, n2));
            this.newVariableButton.setPreferredSize(new Dimension(n, n2));
            this.newVariableButton.setMaximumSize(new Dimension(n, n2));
            this.newVariableButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    Variable variable = MainCompositeElementPanel.this.authoringTool.showNewVariableDialog(I18n.getString("msg_createNewVar"), MainCompositeElementPanel.this.localVariables.getOwner(), false, true);
                    if (variable != null && MainCompositeElementPanel.this.localVariables != null) {
                        MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().startCompound();
                        try {
                            MainCompositeElementPanel.this.localVariables.getOwner().addChild(variable);
                            MainCompositeElementPanel.this.localVariables.add(variable);
                        }
                        finally {
                            MainCompositeElementPanel.this.authoringTool.getUndoRedoStack().stopCompound();
                        }
                    }
                }
            });
            this.newVariableButton.setDropTarget(new DropTarget(this.newVariableButton, this.variableDropHandler));
            this.newVariableButton.setToolTipText(I18n.getString("msg_help_createNewVar"));
        } else {
            System.out.println("MainCompositeElementPanel.java: generateGUI(): newVariableButton!=null");
        }
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(20, 30){

                public void printComponent(Graphics graphics) {
                }
            };
            this.scrollPane.getViewport().setOpaque(false);
            this.scrollPane.setOpaque(false);
            this.scrollPane.setBorder(null);
        }
        if (this.parameterDropHandler == null) {
            this.parameterDropHandler = new DropTargetHandler(this.requiredParameters);
        }
        if (this.parameterPanel == null) {
            this.parameterPanel = new JPanel(){

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (MainCompositeElementPanel.this.lineLocation > -1 && MainCompositeElementPanel.this.paintParameter) {
                        this.getBounds();
                        graphics.setColor(Color.black);
                        graphics.fillRect(MainCompositeElementPanel.this.lineLocation, MainCompositeElementPanel.this.verticalLineLocation, 2, MainCompositeElementPanel.this.lineHeight);
                    }
                }
            };
            this.parameterPanel.setBackground(this.backgroundColor);
            this.parameterPanel.setBorder(null);
            this.parameterPanel.setLayout(new DynamicFlowLayout(0, component, class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = MainCompositeElementPanel.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane, 152));
            this.parameterPanel.setDropTarget(new DropTarget(this.parameterPanel, this.parameterDropHandler));
            this.parameterDropHandler.setPanel(this.parameterPanel);
        }
        if (this.variableDropHandler == null) {
            this.variableDropHandler = new DropTargetHandler(this.localVariables);
        }
        if (this.variablePanel == null) {
            this.variablePanel = new JPanel(){

                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (MainCompositeElementPanel.this.lineLocation > -1 && MainCompositeElementPanel.this.paintVariable) {
                        this.getBounds();
                        graphics.setColor(Color.black);
                        graphics.fillRect(MainCompositeElementPanel.this.lineLocation, MainCompositeElementPanel.this.verticalLineLocation, 2, MainCompositeElementPanel.this.lineHeight);
                    }
                }
            };
            this.variablePanel.setBackground(this.backgroundColor);
            this.variablePanel.setBorder(null);
            this.variablePanel.setLayout(new DynamicFlowLayout(0, component, class$javax$swing$JTabbedPane == null ? (class$javax$swing$JTabbedPane = MainCompositeElementPanel.class$("javax.swing.JTabbedPane")) : class$javax$swing$JTabbedPane, 152));
            this.variablePanel.setDropTarget(new DropTarget(this.variablePanel, this.variableDropHandler));
            this.variableDropHandler.setPanel(this.variablePanel);
        }
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setOpaque(false);
            this.headerPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.gray));
            this.headerPanel.setLayout(new GridBagLayout());
        }
        if (this.methodNameLabel == null) {
            this.methodNameLabel = new JLabel();
            this.methodNameLabel.setFont(nameFont);
            this.methodNameLabel.setDropTarget(new DropTarget(this.methodNameLabel, this.parameterDropHandler));
        } else {
            System.out.println("MainCompositeElementPanel.java: generateGUI(): methodNameLabel!=null");
        }
        if (this.noParametersLabel == null) {
            this.noParametersLabel = new JLabel(I18n.getString("msg_parameters_no"));
            this.noParametersLabel.setDropTarget(new DropTarget(this.noParametersLabel, this.parameterDropHandler));
            this.noParametersLabel.setFont(noFont);
        } else {
            System.out.println("MainCompositeElementPanel.java: generateGUI(): noParametersLabel!=null");
        }
        if (this.noVariablesLabel == null) {
            this.noVariablesLabel = new JLabel(I18n.getString("msg_variables_no"));
            this.noVariablesLabel.setDropTarget(new DropTarget(this.noVariablesLabel, this.variableDropHandler));
            this.noVariablesLabel.setFont(noFont);
        } else {
            System.out.println("MainCompositeElementPanel.java: generateGUI(): noVariablesLabel!=null");
        }
        if (this.mainParameterPanel == null) {
            this.mainParameterPanel = new JPanel();
            this.mainParameterPanel.setBackground(this.backgroundColor);
            this.mainParameterPanel.setOpaque(true);
            this.mainParameterPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.lightGray));
            this.mainParameterPanel.setLayout(new GridBagLayout());
            this.mainParameterPanel.add((Component)this.parameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.mainParameterPanel.add((Component)this.newParameterButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
        } else {
            System.out.println("MainCompositeElementPanel.java: generateGUI(): mainParameterPanel!=null");
        }
        if (this.mainVariablePanel == null) {
            this.mainVariablePanel = new JPanel();
            this.mainVariablePanel.setOpaque(true);
            this.mainVariablePanel.setBackground(this.backgroundColor);
            this.mainVariablePanel.setBorder(null);
            this.mainVariablePanel.setLayout(new GridBagLayout());
            this.mainVariablePanel.add((Component)this.variablePanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.mainVariablePanel.add((Component)this.newVariableButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(4, 4, 4, 4), 0, 0));
        } else {
            System.out.println("MainCompositeElementPanel.java: generateGUI(): mainVariablePanel!=null");
        }
    }

    protected void updateGUI() {
        this.removeAll();
        this.buildParameterPanel();
        this.buildVariablePanel();
        this.headerPanel.add((Component)this.mainParameterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headerPanel.add((Component)this.mainVariablePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollPane.setViewportView(this.componentElementPanel);
        this.scrollPane.getViewport().setOpaque(false);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.headerPanel, "North");
        if (CompositeElementEditor.IS_JAVA) {
            this.closeBrace.setText(" }");
            this.add((Component)this.closeBrace, "South");
        }
        this.setBackground(this.getCustomBackgroundColor());
        this.repaint();
        this.revalidate();
    }

    protected boolean isInGroup(Object object, ObjectArrayProperty objectArrayProperty) {
        if (object instanceof Element) {
            return objectArrayProperty.contains(object);
        }
        return false;
    }

    public void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isInGroup(propertyEvent.getProperty().getOwner(), this.requiredParameters)) {
            this.buildParameterPanel();
        } else if (this.isInGroup(propertyEvent.getProperty().getOwner(), this.localVariables)) {
            this.buildVariablePanel();
        } else if (propertyEvent.getProperty() == this.m_element.name) {
            this.buildParameterPanel();
        }
        this.repaint();
        this.revalidate();
    }

    private Variable isPromotable(Transferable transferable) {
        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.variableReferenceFlavor)) {
            try {
                Variable variable = (Variable)transferable.getTransferData(ElementReferenceTransferable.variableReferenceFlavor);
                if (this.localVariables.contains(variable) || this.requiredParameters.contains(variable)) {
                    return variable;
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public Component getWorkSpace() {
        return this.scrollPane;
    }

    public Component getParameterPanel() {
        return this.parameterPanel;
    }

    public Component getVariablePanel() {
        return this.variablePanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private ObjectArrayProperty m_group;
        private JPanel containingPanel;
        private int variablePosition;
        boolean isParameter = false;

        public DropTargetHandler(ObjectArrayProperty objectArrayProperty) {
            this.m_group = objectArrayProperty;
            if (objectArrayProperty == MainCompositeElementPanel.this.requiredParameters) {
                this.isParameter = true;
            }
        }

        public void setProperty(ObjectArrayProperty objectArrayProperty) {
            this.m_group = objectArrayProperty;
            this.isParameter = objectArrayProperty == MainCompositeElementPanel.this.requiredParameters;
        }

        public void setPanel(JPanel jPanel) {
            this.containingPanel = jPanel;
        }

        protected int getStartIndex() {
            int n = 0;
            for (int i = 0; i < this.containingPanel.getComponentCount(); ++i) {
                Component component = this.containingPanel.getComponent(i);
                if (component == MainCompositeElementPanel.this.methodNameLabel || component == MainCompositeElementPanel.this.noParametersLabel || component == MainCompositeElementPanel.this.noVariablesLabel) {
                    ++n;
                    continue;
                }
                return n;
            }
            return n;
        }

        private void turnNoPanelOn() {
            if (this.isParameter) {
                if (!MainCompositeElementPanel.this.noParametersLabel.isOpaque()) {
                    MainCompositeElementPanel.this.noParametersLabel.setBackground(Color.white);
                    MainCompositeElementPanel.this.noParametersLabel.setOpaque(true);
                    MainCompositeElementPanel.this.noParametersLabel.repaint();
                }
            } else if (!MainCompositeElementPanel.this.noVariablesLabel.isOpaque()) {
                MainCompositeElementPanel.this.noVariablesLabel.setBackground(Color.white);
                MainCompositeElementPanel.this.noVariablesLabel.setOpaque(true);
                MainCompositeElementPanel.this.noVariablesLabel.repaint();
            }
        }

        private void turnNoPanelOff() {
            if (this.isParameter) {
                if (MainCompositeElementPanel.this.noParametersLabel.isOpaque()) {
                    MainCompositeElementPanel.this.noParametersLabel.setBackground(Color.white);
                    MainCompositeElementPanel.this.noParametersLabel.setOpaque(false);
                    MainCompositeElementPanel.this.noParametersLabel.repaint();
                }
            } else if (MainCompositeElementPanel.this.noVariablesLabel.isOpaque()) {
                MainCompositeElementPanel.this.noVariablesLabel.setBackground(Color.white);
                MainCompositeElementPanel.this.noVariablesLabel.setOpaque(false);
                MainCompositeElementPanel.this.noVariablesLabel.repaint();
            }
        }

        protected void calculateLineLocation(int n, int n2) {
            int n3 = this.m_group.size() + 1;
            int[] nArray = new int[n3];
            int[] nArray2 = new int[n3];
            int n4 = this.getStartIndex();
            if (this.m_group.size() == 0) {
                this.variablePosition = 0;
                MainCompositeElementPanel.this.verticalLineLocation = -1;
                MainCompositeElementPanel.this.lineLocation = -1;
                this.turnNoPanelOn();
            } else {
                int n5;
                this.turnNoPanelOff();
                JComponent jComponent = (JComponent)this.containingPanel.getComponent(n4);
                nArray[0] = jComponent.getBounds().x - jComponent.getInsets().left - 4;
                nArray2[0] = 5 + MainCompositeElementPanel.this.lineHeight / 2;
                int n6 = 1;
                for (n5 = 0; n5 < n3 - 1; ++n5) {
                    JComponent jComponent2 = (JComponent)this.containingPanel.getComponent(n4);
                    Insets insets = jComponent2.getInsets();
                    nArray[n6] = jComponent2.getBounds().x + jComponent2.getBounds().width + insets.left;
                    nArray2[n6] = jComponent2.getBounds().y + MainCompositeElementPanel.this.lineHeight / 2;
                    ++n6;
                    ++n4;
                }
                n5 = -2;
                int n7 = Integer.MAX_VALUE;
                for (int i = 0; i < n3; ++i) {
                    int n8 = Math.abs(n - nArray[i]) + Math.abs(n2 - nArray2[i]);
                    if (n8 >= n7) continue;
                    n7 = n8;
                    n5 = i;
                }
                this.variablePosition = n5;
                MainCompositeElementPanel.this.verticalLineLocation = nArray2[n5] - MainCompositeElementPanel.this.lineHeight / 2;
                MainCompositeElementPanel.this.lineLocation = nArray[n5];
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, ElementReferenceTransferable.variableReferenceFlavor)) {
                dropTargetDragEvent.acceptDrag(2);
            } else {
                this.turnNoPanelOff();
                MainCompositeElementPanel.this.lineLocation = -1;
                MainCompositeElementPanel.this.paintParameter = false;
                MainCompositeElementPanel.this.paintVariable = false;
                dropTargetDragEvent.rejectDrag();
                this.containingPanel.repaint();
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            MainCompositeElementPanel.this.lineLocation = -1;
            MainCompositeElementPanel.this.paintParameter = false;
            MainCompositeElementPanel.this.paintVariable = false;
            this.turnNoPanelOff();
            this.containingPanel.repaint();
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (MainCompositeElementPanel.this.isPromotable(DnDManager.getCurrentTransferable()) != null) {
                dropTargetDragEvent.acceptDrag(2);
                Point point = SwingUtilities.convertPoint(dropTargetDragEvent.getDropTargetContext().getComponent(), dropTargetDragEvent.getLocation(), this.containingPanel);
                int n = MainCompositeElementPanel.this.lineLocation;
                this.calculateLineLocation(point.x, point.y);
                if (n != MainCompositeElementPanel.this.lineLocation) {
                    if (this.isParameter) {
                        MainCompositeElementPanel.this.paintParameter = true;
                        MainCompositeElementPanel.this.paintVariable = false;
                    } else {
                        MainCompositeElementPanel.this.paintParameter = false;
                        MainCompositeElementPanel.this.paintVariable = true;
                    }
                    this.containingPanel.repaint();
                }
            } else {
                MainCompositeElementPanel.this.lineLocation = -1;
                MainCompositeElementPanel.this.paintParameter = false;
                MainCompositeElementPanel.this.paintVariable = false;
                this.turnNoPanelOff();
                dropTargetDragEvent.rejectDrag();
                this.containingPanel.repaint();
            }
        }

        protected ObjectArrayProperty getGroup(Variable variable) {
            Element element;
            ElementArrayProperty elementArrayProperty = null;
            if (variable.getParent() instanceof UserDefinedResponse) {
                element = (UserDefinedResponse)variable.getParent();
                if (element.keywordFormalParameters.contains(variable)) {
                    elementArrayProperty = element.keywordFormalParameters;
                } else if (element.localVariables.contains(variable)) {
                    elementArrayProperty = element.localVariables;
                } else if (element.requiredFormalParameters.contains(variable)) {
                    elementArrayProperty = element.requiredFormalParameters;
                } else if (element.requiredFormalParameters.contains(variable)) {
                    elementArrayProperty = element.requiredFormalParameters;
                }
            }
            if (variable.getParent() instanceof UserDefinedQuestion) {
                element = (UserDefinedQuestion)variable.getParent();
                if (((UserDefinedQuestion)element).keywordFormalParameters.contains(variable)) {
                    elementArrayProperty = ((UserDefinedQuestion)element).keywordFormalParameters;
                } else if (((UserDefinedQuestion)element).localVariables.contains(variable)) {
                    elementArrayProperty = ((UserDefinedQuestion)element).localVariables;
                } else if (((UserDefinedQuestion)element).requiredFormalParameters.contains(variable)) {
                    elementArrayProperty = ((UserDefinedQuestion)element).requiredFormalParameters;
                } else if (((UserDefinedQuestion)element).requiredFormalParameters.contains(variable)) {
                    elementArrayProperty = ((UserDefinedQuestion)element).requiredFormalParameters;
                }
            }
            return elementArrayProperty;
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Variable variable = MainCompositeElementPanel.this.isPromotable(DnDManager.getCurrentTransferable());
            MainCompositeElementPanel.this.paintParameter = false;
            MainCompositeElementPanel.this.paintVariable = false;
            boolean bl = true;
            if (variable != null) {
                dropTargetDropEvent.acceptDrop(2);
                Point point = SwingUtilities.convertPoint(dropTargetDropEvent.getDropTargetContext().getComponent(), dropTargetDropEvent.getLocation(), this.containingPanel);
                this.calculateLineLocation(point.x, point.y);
                ObjectArrayProperty objectArrayProperty = this.getGroup(variable);
                if (this.variablePosition > this.m_group.size()) {
                    this.variablePosition = this.m_group.size();
                }
                if (objectArrayProperty == this.m_group) {
                    int n = this.variablePosition;
                    int n2 = objectArrayProperty.indexOf(variable);
                    if (n2 < n) {
                        --n;
                    }
                    objectArrayProperty.shift(n2, n);
                } else if (objectArrayProperty != null) {
                    objectArrayProperty.remove(variable);
                    this.m_group.add(this.variablePosition, variable);
                }
                this.turnNoPanelOff();
                MainCompositeElementPanel.this.lineLocation = -1;
            } else {
                this.turnNoPanelOff();
                MainCompositeElementPanel.this.lineLocation = -1;
                dropTargetDropEvent.rejectDrop();
                bl = false;
            }
            dropTargetDropEvent.dropComplete(bl);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (MainCompositeElementPanel.this.isPromotable(DnDManager.getCurrentTransferable()) != null) {
                dropTargetDragEvent.acceptDrag(2);
            } else {
                System.err.println("\n\nMainCompositeElementPanel.java: dropActionChanged(java.awt.dnd.DropTargetDragEvent): drop rejected");
                dropTargetDragEvent.rejectDrag();
            }
        }
    }
}

