/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.property.ListProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.VariableProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.question.userdefined.ForEach;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class ForEachElementPanel
extends CompositeElementPanel
implements ObjectArrayPropertyListener {
    protected boolean nameListening = false;
    protected JLabel endHeader;
    protected String endHeaderText;
    protected String middleHeaderText;
    protected JComponent listInput;
    protected JComponent variable;
    protected ListProperty m_list;
    protected VariableProperty m_each;
    protected static BufferedImage forEachBackgroundImage;
    protected static Dimension forEachBackgroundImageSize;

    public ForEachElementPanel() {
        this.backgroundColor = AuthoringToolResources.getColor("ForEachInOrder");
        this.headerText = I18n.getString("commandT_Listiterator");
        this.endHeaderText = I18n.getString("commandT_atTime");
        this.middleHeaderText = I18n.getString("commandT_one");
    }

    protected void variableInit() {
        super.variableInit();
        if (this.m_element instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
            edu.cmu.cs.stage3.alice.core.response.ForEach forEach = (edu.cmu.cs.stage3.alice.core.response.ForEach)this.m_element;
            this.m_list = forEach.list;
            this.m_each = forEach.each;
        } else if (this.m_element instanceof ForEach) {
            ForEach forEach = (ForEach)this.m_element;
            this.m_list = forEach.list;
            this.m_each = forEach.each;
        }
    }

    protected void setDropTargets() {
        super.setDropTargets();
        this.endHeader.setDropTarget(new DropTarget(this.endHeader, this.componentElementPanel));
    }

    protected void listenToChildren(ObjectArrayProperty objectArrayProperty) {
        if (objectArrayProperty != null) {
            objectArrayProperty.addObjectArrayPropertyListener(this);
            for (int i = 0; i < objectArrayProperty.size(); ++i) {
                Code code;
                if (objectArrayProperty.get(i) instanceof CompositeResponse) {
                    code = (CompositeResponse)objectArrayProperty.get(i);
                    this.listenToChildren(code.componentResponses);
                    continue;
                }
                if (!(objectArrayProperty.get(i) instanceof Composite)) continue;
                code = (Composite)objectArrayProperty.get(i);
                this.listenToChildren(((Composite)code).components);
            }
        }
    }

    protected void stopListenToChildren(ObjectArrayProperty objectArrayProperty) {
        if (objectArrayProperty != null) {
            objectArrayProperty.removeObjectArrayPropertyListener(this);
            for (int i = 0; i < objectArrayProperty.size(); ++i) {
                Code code;
                if (objectArrayProperty.get(i) instanceof CompositeResponse) {
                    code = (CompositeResponse)objectArrayProperty.get(i);
                    this.stopListenToChildren(code.componentResponses);
                    continue;
                }
                if (!(objectArrayProperty.get(i) instanceof Composite)) continue;
                code = (Composite)objectArrayProperty.get(i);
                this.stopListenToChildren(((Composite)code).components);
            }
        }
    }

    protected void startListening() {
        super.startListening();
        if (this.m_list != null) {
            this.m_list.addPropertyListener(this);
            if (this.m_list.get() != null) {
                ((Element)this.m_list.get()).name.addPropertyListener(this);
                this.nameListening = true;
            }
        }
        if (this.m_each != null) {
            this.m_each.addPropertyListener(this);
        }
        this.listenToChildren(this.m_components);
    }

    protected void stopListening() {
        super.stopListening();
        if (this.m_list != null) {
            this.m_list.removePropertyListener(this);
            if (this.m_list.get() != null) {
                ((Element)this.m_list.get()).name.removePropertyListener(this);
                this.nameListening = true;
            }
        }
        if (this.m_each != null) {
            this.m_each.removePropertyListener(this);
        }
        this.stopListenToChildren(this.m_components);
    }

    public int countPreviousInstances(Element element, Object object) {
        if (element == null) {
            return 0;
        }
        ListProperty listProperty = null;
        if (element instanceof ForEach) {
            listProperty = ((ForEach)element).list;
        }
        if (element instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
            listProperty = ((edu.cmu.cs.stage3.alice.core.response.ForEach)element).list;
        }
        if (listProperty != null && listProperty.get() == object) {
            if (element.getParent() != null && !(element.getParent() instanceof Sandbox)) {
                return this.countPreviousInstances(element.getParent(), object) + 1;
            }
            return 1;
        }
        if (element.getParent() != null && !(element.getParent() instanceof Sandbox)) {
            return this.countPreviousInstances(element.getParent(), object);
        }
        return 0;
    }

    private String makeVariableName(Element element) {
        int n = 0;
        if (this.m_element.getParent() != null && !(this.m_element.getParent() instanceof Sandbox)) {
            n = this.countPreviousInstances(this.m_element.getParent(), element);
        }
        String string = "";
        if (n > 0) {
            string = "_#" + (n + 1);
        }
        return I18n.getString("command_itemFrom") + element.name.getStringValue() + string;
    }

    public void setHeaderLabel() {
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
        }
        if (this.endHeader != null) {
            this.endHeader.setText(this.endHeaderText);
            if (CompositeElementEditor.IS_JAVA) {
                if (!this.isExpanded) {
                    this.endHeader.setText(this.endHeaderText + " { " + this.getDots() + " }");
                } else {
                    this.endHeader.setText(this.endHeaderText + " {");
                }
            }
        }
    }

    protected void generateGUI() {
        super.generateGUI();
        if (this.endHeader == null) {
            this.endHeader = new JLabel(this.endHeaderText);
        }
    }

    protected void restoreDrag() {
        super.restoreDrag();
        this.addDragSourceComponent(this.endHeader);
    }

    protected void updateName() {
        Variable variable = (Variable)this.m_each.getValue();
        variable.name.set(this.makeVariableName((Element)this.m_list.get()));
        this.headerPanel.remove(this.variable);
        this.variable = GUIFactory.getVariableDnDPanel((Variable)this.m_each.get());
        this.headerPanel.add((Component)this.variable, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
    }

    protected void updateGUI() {
        super.updateGUI();
        SetPropertyImmediatelyFactory setPropertyImmediatelyFactory = new SetPropertyImmediatelyFactory(this.m_list){

            public void run(Object object) {
                if (!(object instanceof List)) {
                    if (object instanceof Variable) {
                        if (!(((Variable)object).value.get() instanceof List)) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                super.run(object);
            }
        };
        if (this.m_list.get() != null) {
            this.setVariable();
        }
        this.variable = GUIFactory.getVariableDnDPanel((Variable)this.m_each.get());
        this.listInput = GUIFactory.getPropertyViewController(this.m_list, false, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_list), setPropertyImmediatelyFactory);
        this.headerPanel.remove(this.glue);
        this.headerPanel.add((Component)this.listInput, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)new JLabel(this.middleHeaderText), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)this.variable, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)this.endHeader, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(7, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected boolean isTopOccurrance(Element element, Object object) {
        if (element == null) {
            return true;
        }
        ListProperty listProperty = null;
        if (element instanceof ForEach) {
            listProperty = ((ForEach)element).list;
        }
        if (element instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
            listProperty = ((edu.cmu.cs.stage3.alice.core.response.ForEach)element).list;
        }
        if (listProperty != null && listProperty.get() == object) {
            return false;
        }
        return this.isTopOccurrance(element.getParent(), object);
    }

    protected void setVariableName() {
        Element element = (Element)this.m_list.get();
        String string = this.makeVariableName(element);
        ((Element)this.m_each.get()).name.set(string);
    }

    private void setVariable() {
        if (this.m_each.get() != null && this.m_list.get() != null) {
            Element element = (Element)this.m_list.get();
            Class clazz = null;
            if (element instanceof List) {
                clazz = (Class)((List)element).valueClass.get();
            } else if (element instanceof Variable) {
                clazz = (Class)((List)((Variable)element).value.get()).valueClass.get();
            }
            ((Variable)this.m_each.get()).valueClass.set(clazz);
            this.setVariableName();
        }
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
    }

    protected void setAllNames(ObjectArrayProperty objectArrayProperty, int n) {
        String string = I18n.getString("command_itemFrom") + ((Element)this.m_list.get()).name.getStringValue();
        for (int i = 0; i < objectArrayProperty.size(); ++i) {
            Object object = null;
            Element element = null;
            if (objectArrayProperty.get(i) instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
                object = ((edu.cmu.cs.stage3.alice.core.response.ForEach)objectArrayProperty.get((int)i)).list.get();
                element = (Element)((edu.cmu.cs.stage3.alice.core.response.ForEach)objectArrayProperty.get((int)i)).each.get();
            } else if (objectArrayProperty.get(i) instanceof ForEach) {
                object = ((ForEach)objectArrayProperty.get((int)i)).list.get();
                element = (Element)((ForEach)objectArrayProperty.get((int)i)).each.get();
            }
            if (object == this.m_list.get()) {
                element.name.set(string + "_#" + n);
            }
            if (objectArrayProperty.get(i) instanceof CompositeResponse) {
                this.setAllNames(((CompositeResponse)objectArrayProperty.get((int)i)).componentResponses, n + 1);
                continue;
            }
            if (!(objectArrayProperty.get(i) instanceof Composite)) continue;
            this.setAllNames(((Composite)objectArrayProperty.get((int)i)).components, n + 1);
        }
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        this.stopListening();
        this.startListening();
        if (this.isTopOccurrance(this.m_element.getParent(), this.m_list.get())) {
            this.m_each.getElementValue().name.set(I18n.getString("command_itemFrom") + ((Element)this.m_list.get()).name.getStringValue());
            this.setAllNames(this.m_components, 2);
        }
    }

    public void propertyChanged(PropertyEvent propertyEvent) {
        if (propertyEvent.getProperty() == this.m_each && this.m_each.get() != null) {
            Element element = (Element)this.m_list.get();
            Class clazz = null;
            if (element instanceof List) {
                clazz = (Class)((List)element).valueClass.get();
            } else if (element instanceof Variable) {
                clazz = (Class)((List)((Variable)element).value.get()).valueClass.get();
            }
            ((Variable)this.m_each.get()).valueClass.set(clazz);
            this.setVariableName();
        }
        if (propertyEvent.getProperty() == this.m_list) {
            if (this.m_list.get() != null && !this.nameListening) {
                ((Element)this.m_list.get()).name.addPropertyListener(this);
                this.nameListening = true;
            }
            this.setVariable();
        } else if (this.m_list.get() != null && propertyEvent.getProperty() == ((Element)this.m_list.get()).name) {
            this.setVariableName();
        } else {
            super.propertyChanged(propertyEvent);
        }
    }

    protected void createBackgroundImage(int n, int n2) {
        forEachBackgroundImageSize.setSize(n, n2);
        forEachBackgroundImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)forEachBackgroundImage.getGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
    }

    static {
        forEachBackgroundImageSize = new Dimension(-1, -1);
    }
}

