/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.OutputComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RenderContentPane
extends ContentPane {
    private static final int HEIGHT = 500;
    protected JPanel renderPanel = new JPanel(new BorderLayout());
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JSplitPane stdOutSplitPane = new JSplitPane(0);
    protected double aspectRatio;
    protected AuthoringTool authoringTool;
    protected boolean showStdOut = true;
    protected int stdOutHeight = 200;
    protected int watcherWidth = 200;
    protected OutputComponent stdOutOutputComponent;
    protected WatcherPanel watcherPanel;
    protected JScrollPane watcherScrollPane;
    protected JSplitPane watcherSplitPane = new JSplitPane(1);
    protected JButton pauseButton;
    protected JButton resumeButton;
    protected JButton restartButton;
    protected JButton stopButton;
    protected RenderCanvasFocusListener renderCanvasFocusListener = new RenderCanvasFocusListener();
    protected boolean shiftIsDown = false;
    protected JScrollPane textScrollPane;
    protected StyledStreamTextPane detailTextPane = new StyledStreamTextPane();
    protected boolean doNotListenToResize = false;
    protected final int dividerSize = 5;
    protected String title;
    protected ActionListener okActionListener;
    protected TextOutputDocumentListener textListener = new TextOutputDocumentListener();
    protected RenderComponentListener renderResizeListener = new RenderComponentListener();

    public RenderContentPane(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.stdOutOutputComponent = AuthoringTool.getInstance().getStdOutOutputComponent();
        this.watcherPanel = authoringTool.getWatcherPanel();
        this.guiInit();
    }

    public void setAspectRatio(double d) {
        this.aspectRatio = d;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    protected void setRenderWindowSizeBasedOnSavedBounds() {
        this.renderPanel.setPreferredSize(new Dimension(500, 10));
    }

    public void preDialogShow(JDialog jDialog) {
        super.preDialogShow(jDialog);
        final Component component = this.getRenderCanvas();
        if (component != null) {
            component.addFocusListener(this.renderCanvasFocusListener);
            Timer timer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    component.requestFocus();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
        this.stdOutOutputComponent.stdOutStream.println("*****" + I18n.getString("ivprogRun") + "*****");
        this.stdOutOutputComponent.stdOutStream.flush();
        this.stdOutOutputComponent.getTextPane().getDocument().addDocumentListener(this.textListener);
        this.renderPanel.setPreferredSize(new Dimension(500, 10));
        jDialog.setLocation(170, 170);
        this.keyMapInit();
        this.updateGUI();
    }

    public void postDialogShow(JDialog jDialog) {
        super.postDialogShow(jDialog);
        this.authoringTool.worldStopRunning();
        this.saveRenderBounds();
        Component component = this.getRenderCanvas();
        if (component != null) {
            component.removeFocusListener(this.renderCanvasFocusListener);
        }
        this.stdOutOutputComponent.getTextPane().getDocument().removeDocumentListener(this.textListener);
        this.stdOutOutputComponent.stdOutStream.println("*****" + I18n.getString("ivprogStop") + "*****");
        this.stdOutOutputComponent.stdOutStream.flush();
    }

    public void addOKActionListener(ActionListener actionListener) {
        this.okActionListener = actionListener;
        this.stopButton.addActionListener(actionListener);
    }

    public void removeOKActionListener(ActionListener actionListener) {
        this.okActionListener = null;
        this.stopButton.removeActionListener(actionListener);
    }

    private void guiInit() {
        this.title = I18n.getString("ivprogRun");
        this.setRenderWindowSizeBasedOnSavedBounds();
        this.renderPanel.addComponentListener(this.renderResizeListener);
        this.watcherScrollPane = new JScrollPane(this.watcherPanel, 20, 30);
        this.textScrollPane = new JScrollPane(this.detailTextPane, 20, 30);
        this.detailTextPane.setEditable(false);
        this.pauseButton = new JButton(this.authoringTool.getActions().pauseWorldAction);
        this.resumeButton = new JButton(this.authoringTool.getActions().resumeWorldAction);
        this.restartButton = new JButton(this.authoringTool.getActions().restartWorldAction);
        this.stopButton = new JButton(this.authoringTool.getActions().stopWorldAction);
        this.pauseButton.setMargin(new Insets(3, 2, 3, 2));
        this.resumeButton.setMargin(new Insets(3, 2, 3, 2));
        this.restartButton.setMargin(new Insets(3, 2, 3, 2));
        this.stopButton.setMargin(new Insets(3, 2, 3, 2));
        this.buttonPanel.add((Component)this.pauseButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.resumeButton, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.restartButton, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.stopButton, new GridBagConstraints(7, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.watcherSplitPane = new JSplitPane(1);
        this.watcherSplitPane.setContinuousLayout(true);
        this.watcherSplitPane.setDividerSize(0);
        this.watcherSplitPane.setResizeWeight(1.0);
        this.watcherSplitPane.setLeftComponent(this.renderPanel);
        this.stdOutSplitPane.setContinuousLayout(true);
        this.stdOutSplitPane.setDividerSize(0);
        this.stdOutSplitPane.setResizeWeight(1.0);
        this.stdOutSplitPane.setTopComponent(this.watcherSplitPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.stdOutSplitPane, "Center");
        this.updateGUI();
    }

    private void keyMapInit() {
        Iterator iterator = this.authoringTool.getActions().renderActions.iterator();
        while (iterator.hasNext()) {
            Component component;
            String string;
            KeyStroke keyStroke;
            Action action = (Action)iterator.next();
            try {
                keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                string = (String)action.getValue("ActionCommandKey");
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (keyStroke == null || string == null || !((component = SwingUtilities.getRoot(this)) instanceof JDialog)) continue;
            ((JDialog)component).getRootPane().registerKeyboardAction(action, string, keyStroke, 2);
        }
    }

    public void saveRenderBounds() {
        Point point = new Point(0, 0);
        Component component = SwingUtilities.getRoot(this);
        if (component instanceof JDialog) {
            SwingUtilities.convertPointToScreen(point, component);
        } else {
            SwingUtilities.convertPointToScreen(point, this.renderPanel);
        }
    }

    public void saveRenderBounds(Rectangle rectangle) {
    }

    protected boolean shouldConstrainAspectOnResize() {
        return !this.showStdOut && !this.authoringTool.getWatcherPanel().isThereSomethingToWatch();
    }

    public JPanel getRenderPanel() {
        System.out.println("RenderContentPane.java: getRenderPanel()");
        return this.renderPanel;
    }

    public void constrainToAspectRatio(Rectangle rectangle, boolean bl) {
        if (this.aspectRatio > 0.0) {
            if (bl) {
                rectangle.width = (int)Math.round((double)rectangle.height * this.aspectRatio);
            } else {
                rectangle.height = (int)Math.round((double)rectangle.width / this.aspectRatio);
            }
        }
    }

    public void stopWorld() {
        if (this.okActionListener != null) {
            this.okActionListener.actionPerformed(null);
        }
    }

    public void updateGUI() {
        int n = this.renderPanel.getWidth();
        int n2 = this.renderPanel.getHeight();
        if (this.showStdOut) {
            this.textScrollPane.setPreferredSize(new Dimension(n, this.stdOutHeight));
            this.stdOutSplitPane.setBottomComponent(this.textScrollPane);
            this.stdOutSplitPane.setDividerSize(5);
        } else {
            this.stdOutSplitPane.setBottomComponent(null);
            this.stdOutSplitPane.setDividerLocation(0);
            this.stdOutSplitPane.setDividerSize(0);
        }
        if (this.authoringTool.getWatcherPanel().isThereSomethingToWatch()) {
            this.watcherScrollPane.setPreferredSize(new Dimension(this.watcherWidth, n2));
            this.watcherSplitPane.setRightComponent(this.watcherScrollPane);
            this.watcherSplitPane.setDividerSize(5);
        } else {
            this.watcherSplitPane.setRightComponent(null);
            this.watcherSplitPane.setDividerLocation(0);
            this.watcherSplitPane.setDividerSize(0);
        }
        this.packDialog();
    }

    public void addNotify() {
        super.addNotify();
        this.updateGUI();
    }

    public Component getRenderCanvas() {
        Component component = this.renderPanel.getComponent(0);
        if (component instanceof Container) {
            try {
                return ((Container)component).getComponent(0);
            }
            catch (Exception exception) {
                System.err.println("Error: RenderContentPane.java: getRenderCanvas(): " + exception.toString());
            }
        }
        return null;
    }

    public class RenderCanvasFocusListener
    extends FocusAdapter {
        public void focusLost() {
            Component component = RenderContentPane.this.getRenderCanvas();
            if (component != null && component.isShowing()) {
                System.out.println("\n\n\nRenderContentPane.java: focusLost: renderCanvas.requestFocus");
                component.requestFocus();
            }
        }
    }

    protected class RenderComponentListener
    extends ComponentAdapter {
        protected RenderComponentListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (RenderContentPane.this.shouldConstrainAspectOnResize() && !RenderContentPane.this.doNotListenToResize) {
                RenderContentPane.this.packDialog();
                RenderContentPane.this.doNotListenToResize = false;
            }
        }
    }

    protected class TextOutputDocumentListener
    implements DocumentListener {
        protected TextOutputDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            SwingUtilities.invokeLater(new Runnable(this, documentEvent){
                private final /* synthetic */ DocumentEvent val$ev;
                private final /* synthetic */ TextOutputDocumentListener this$1;
                {
                    this.this$1 = textOutputDocumentListener;
                    this.val$ev = documentEvent;
                }

                public void run() {
                    try {
                        String string = this.val$ev.getDocument().getText(this.val$ev.getOffset(), this.val$ev.getLength());
                        TextOutputDocumentListener.access$000((TextOutputDocumentListener)this.this$1).detailTextPane.getDocument().insertString(TextOutputDocumentListener.access$000((TextOutputDocumentListener)this.this$1).detailTextPane.getDocument().getLength(), string, TextOutputDocumentListener.access$000((TextOutputDocumentListener)this.this$1).detailTextPane.stdOutStyle);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    TextOutputDocumentListener.access$100(this.this$1);
                }
            });
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.update();
        }

        private void update() {
            if (!RenderContentPane.this.showStdOut) {
                RenderContentPane.this.saveRenderBounds();
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ TextOutputDocumentListener this$1;
                    {
                        this.this$1 = textOutputDocumentListener;
                    }

                    public void run() {
                        TextOutputDocumentListener.access$000(this.this$1).updateGUI();
                        TextOutputDocumentListener.access$000((TextOutputDocumentListener)this.this$1).showStdOut = true;
                        Component component = TextOutputDocumentListener.access$000(this.this$1).getRenderCanvas();
                        if (component != null) {
                            component.requestFocus();
                        }
                    }
                });
            }
        }

        static /* synthetic */ RenderContentPane access$000(TextOutputDocumentListener textOutputDocumentListener) {
            return textOutputDocumentListener.RenderContentPane.this;
        }

        static /* synthetic */ void access$100(TextOutputDocumentListener textOutputDocumentListener) {
            textOutputDocumentListener.update();
        }
    }
}

