/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.util.CheckForValidityCallback;
import edu.cmu.cs.stage3.alice.authoringtool.util.NameTextField;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class NewNamedElementContentPane
extends ContentPane {
    private JButton m_okButton = new JButton(I18n.getString("buttonOK"));
    private JButton m_cancelButton = new JButton(I18n.getString("buttonCancel"));
    private HashMap validityHashmap = new HashMap();
    private CheckForValidityCallback validityChecker = new CheckForValidityCallback(){

        public void setValidity(Object object, boolean bl) {
            NewNamedElementContentPane.this.okButtonEnabler(object, bl);
        }

        public void doAction() {
            if (NewNamedElementContentPane.this.m_okButton.isEnabled()) {
                NewNamedElementContentPane.this.m_okButton.doClick();
            }
        }
    };
    private NameTextField m_nameTextField = new NameTextField(this.validityChecker);

    public NewNamedElementContentPane() {
        this.m_nameTextField.setMinimumSize(new Dimension(4, 26));
        this.m_nameTextField.setPreferredSize(new Dimension(4, 26));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.initTopComponents(gridBagConstraints);
        this.initBottomComponents(gridBagConstraints);
    }

    protected void initTopComponents(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets.top = 8;
        gridBagConstraints.insets.left = 8;
        this.add((Component)new JLabel(I18n.getString("msgName") + ":"), gridBagConstraints);
        gridBagConstraints.insets.right = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.m_nameTextField, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
    }

    protected void initBottomComponents(GridBagConstraints gridBagConstraints) {
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel.add((Component)this.m_okButton, gridBagConstraints2);
        jPanel.add((Component)this.m_cancelButton, gridBagConstraints2);
        gridBagConstraints.anchor = 15;
        this.add((Component)jPanel, gridBagConstraints);
    }

    public void addOKActionListener(ActionListener actionListener) {
        this.m_okButton.addActionListener(actionListener);
    }

    public void removeOKActionListener(ActionListener actionListener) {
        this.m_okButton.removeActionListener(actionListener);
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.m_cancelButton.addActionListener(actionListener);
    }

    public void removeCancelActionListener(ActionListener actionListener) {
        this.m_cancelButton.removeActionListener(actionListener);
    }

    public void reset(Element element) {
        this.m_nameTextField.setText("");
        this.m_nameTextField.setParent(element);
        this.m_nameTextField.grabFocus();
    }

    public String getNameValue() {
        return this.m_nameTextField.getText();
    }

    private void okButtonEnabler(Object object, boolean bl) {
        this.validityHashmap.put(object, new Boolean(bl));
        Iterator iterator = this.validityHashmap.values().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (!(v instanceof Boolean) || ((Boolean)v).booleanValue()) continue;
            bl2 = false;
            break;
        }
        this.m_okButton.setEnabled(bl2);
    }

    protected CheckForValidityCallback getValidityChecker() {
        return this.validityChecker;
    }
}

