/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.event.UndoRedoListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.ChildChangeUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CompoundUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.PropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import java.util.HashSet;
import java.util.Iterator;

public class MainUndoRedoStack
extends DefaultUndoRedoStack
implements PropertyListener,
ObjectArrayPropertyListener,
ChildrenListener,
AuthoringToolStateListener {
    protected AuthoringTool authoringTool;
    private boolean isListening = true;
    private boolean inCompound = false;
    private CompoundUndoableRedoable compoundItem;
    private int unmodifiedIndex = -1;
    protected HashSet listeners = new HashSet();
    protected Object preChangeValue;

    public MainUndoRedoStack(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public void addUndoRedoListener(UndoRedoListener undoRedoListener) {
        this.listeners.add(undoRedoListener);
    }

    public int getUnmodifiedIndex() {
        return this.unmodifiedIndex;
    }

    protected synchronized void fireChange() {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((UndoRedoListener)iterator.next()).onChange();
        }
    }

    public synchronized void setUnmodified() {
        this.unmodifiedIndex = this.getCurrentUndoableRedoableIndex();
        this.fireChange();
    }

    public synchronized void setIsListening(boolean bl) {
        this.isListening = bl;
    }

    public synchronized boolean getIsListening() {
        return this.isListening;
    }

    public synchronized void startCompound() {
        if (!this.inCompound) {
            this.compoundItem = new CompoundUndoableRedoable();
            this.compoundItem.setContext(this.authoringTool.getContext());
            this.push(this.compoundItem);
            this.inCompound = true;
        }
    }

    public synchronized void stopCompound() {
        this.inCompound = false;
    }

    public synchronized UndoableRedoable undo() {
        UndoableRedoable undoableRedoable = null;
        try {
            this.stopCompound();
            boolean bl = this.isListening;
            this.isListening = false;
            undoableRedoable = super.undo();
            this.loadContext(undoableRedoable.getContext());
            this.isListening = bl;
            this.fireChange();
            return undoableRedoable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return undoableRedoable;
        }
    }

    public synchronized UndoableRedoable redo() {
        this.stopCompound();
        boolean bl = this.isListening;
        this.isListening = false;
        int n = this.getCurrentUndoableRedoableIndex();
        if (n < this.size() - 1) {
            this.loadContext(((UndoableRedoable)this.get(n + 1)).getContext());
        }
        UndoableRedoable undoableRedoable = super.redo();
        this.isListening = bl;
        this.fireChange();
        return undoableRedoable;
    }

    protected synchronized void loadContext(Object object) {
        this.authoringTool.setContext(object);
    }

    public synchronized void push(UndoableRedoable undoableRedoable) {
        if (undoableRedoable instanceof ContextAssignableUndoableRedoable) {
            ((ContextAssignableUndoableRedoable)undoableRedoable).setContext(this.authoringTool.getContext());
        }
        if (this.inCompound) {
            this.compoundItem.addItem(undoableRedoable);
        } else {
            super.push(undoableRedoable);
        }
        this.fireChange();
    }

    public synchronized UndoableRedoable pop() {
        this.stopCompound();
        UndoableRedoable undoableRedoable = super.pop();
        this.fireChange();
        return undoableRedoable;
    }

    public synchronized void clear() {
        super.clear();
        this.setUnmodified();
        this.fireChange();
    }

    public synchronized UndoableRedoable removeUndoable(int n) {
        UndoableRedoable undoableRedoable = super.removeUndoable(n);
        this.fireChange();
        return undoableRedoable;
    }

    public synchronized void propertyChanging(PropertyEvent propertyEvent) {
        if (this.isListening) {
            this.preChangeValue = propertyEvent.getProperty().get();
        }
    }

    public synchronized void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isListening) {
            if (propertyEvent.getProperty() instanceof ObjectArrayProperty) {
                return;
            }
            if (this.authoringTool.getOneShotScheduler().isPropertyAffected(propertyEvent.getProperty())) {
                return;
            }
            this.push(new PropertyUndoableRedoable(propertyEvent.getProperty(), this.preChangeValue, propertyEvent.getProperty().get()));
        }
    }

    public synchronized void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
    }

    public synchronized void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        if (this.isListening) {
            if (this.authoringTool.getOneShotScheduler().isPropertyAffected(objectArrayPropertyEvent.getObjectArrayProperty())) {
                return;
            }
            this.push(new ObjectArrayPropertyUndoableRedoable(objectArrayPropertyEvent.getObjectArrayProperty(), objectArrayPropertyEvent.getChangeType(), objectArrayPropertyEvent.getOldIndex(), objectArrayPropertyEvent.getNewIndex(), objectArrayPropertyEvent.getItem()));
        }
    }

    public synchronized void childrenChanging(ChildrenEvent childrenEvent) {
    }

    public synchronized void childrenChanged(ChildrenEvent childrenEvent) {
        int n;
        if (this.isListening) {
            this.push(new ChildChangeUndoableRedoable(childrenEvent));
        }
        if ((n = childrenEvent.getChangeType()) == 1) {
            this.listenTo(childrenEvent.getChild());
        } else if (n == 3) {
            this.stopListeningTo(childrenEvent.getChild());
        }
    }

    public synchronized void listenTo(Element element) {
        if (element != null) {
            Element[] elementArray = element.getDescendants();
            Element element2 = null;
            int n = elementArray != null ? elementArray.length : 0;
            for (int i = 0; i < n; ++i) {
                int n2;
                element2 = elementArray[i];
                Property[] propertyArray = element2.getProperties();
                Property property = null;
                int n3 = propertyArray != null ? propertyArray.length : 0;
                for (n2 = 0; n2 < n3; ++n2) {
                    property = propertyArray[n2];
                    property.addPropertyListener(this);
                    if (!(property instanceof ObjectArrayProperty)) continue;
                    ((ObjectArrayProperty)property).addObjectArrayPropertyListener(this);
                }
                n2 = 0;
                ChildrenListener[] childrenListenerArray = element2.getChildrenListeners();
                n3 = childrenListenerArray != null ? childrenListenerArray.length : 0;
                for (int j = 0; j < n3; ++j) {
                    if (childrenListenerArray[j] != this) continue;
                    n2 = 1;
                }
                if (n2 != 0) continue;
                element2.addChildrenListener(this);
            }
        }
    }

    public synchronized void stopListeningTo(Element element) {
        if (element != null) {
            Element[] elementArray = element.getDescendants();
            Element element2 = null;
            int n = elementArray != null ? elementArray.length : 0;
            for (int i = 0; i < n; ++i) {
                element2 = elementArray[i];
                Property[] propertyArray = element2.getProperties();
                Property property = null;
                int n2 = propertyArray != null ? propertyArray.length : 0;
                for (int j = 0; j < n2; ++j) {
                    property = propertyArray[j];
                    property.removePropertyListener(this);
                    if (!(property instanceof ObjectArrayProperty)) continue;
                    ((ObjectArrayProperty)property).removeObjectArrayPropertyListener(this);
                }
                element2.removeChildrenListener(this);
            }
        }
    }

    public void stateChanged(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
        if (authoringToolStateChangedEvent.getCurrentState() == 3) {
            this.stopListeningTo(authoringToolStateChangedEvent.getWorld());
        } else {
            this.listenTo(authoringToolStateChangedEvent.getWorld());
        }
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
        this.stopListeningTo(authoringToolStateChangedEvent.getWorld());
    }

    public void worldLoaded(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
        this.listenTo(authoringToolStateChangedEvent.getWorld());
    }

    public void stateChanging(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStarted(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent authoringToolStateChangedEvent) {
    }
}

